/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.Digest;

public abstract class LongDigest
implements Digest {
    private byte[] xBuf;
    private int xBufOff;
    private long byteCount1;
    private long byteCount2;
    protected long H1;
    protected long H2;
    protected long H3;
    protected long H4;
    protected long H5;
    protected long H6;
    protected long H7;
    protected long H8;
    private long[] W = new long[80];
    private int wOff;
    static final long[] K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};

    protected LongDigest() {
        this.xBuf = new byte[8];
        this.xBufOff = 0;
        this.reset();
    }

    protected LongDigest(LongDigest longDigest) {
        this.xBuf = new byte[longDigest.xBuf.length];
        System.arraycopy(longDigest.xBuf, 0, this.xBuf, 0, longDigest.xBuf.length);
        this.xBufOff = longDigest.xBufOff;
        this.byteCount1 = longDigest.byteCount1;
        this.byteCount2 = longDigest.byteCount2;
        this.H1 = longDigest.H1;
        this.H2 = longDigest.H2;
        this.H3 = longDigest.H3;
        this.H4 = longDigest.H4;
        this.H5 = longDigest.H5;
        this.H6 = longDigest.H6;
        this.H7 = longDigest.H7;
        this.H8 = longDigest.H8;
        System.arraycopy(longDigest.W, 0, this.W, 0, longDigest.W.length);
        this.wOff = longDigest.wOff;
    }

    public void update(byte by) {
        this.xBuf[this.xBufOff++] = by;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount1;
    }

    public void update(byte[] byArray, int n, int n2) {
        while (this.xBufOff != 0 && n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
        while (n2 > this.xBuf.length) {
            this.processWord(byArray, n);
            n += this.xBuf.length;
            n2 -= this.xBuf.length;
            this.byteCount1 += (long)this.xBuf.length;
        }
        while (n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
    }

    public void finish() {
        this.adjustByteCounts();
        long l = this.byteCount1 << 3;
        long l2 = this.byteCount2;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(l, l2);
        this.processBlock();
    }

    public void reset() {
        this.byteCount1 = 0L;
        this.byteCount2 = 0L;
        this.xBufOff = 0;
        int n = 0;
        while (n < this.xBuf.length) {
            this.xBuf[n] = 0;
            ++n;
        }
        this.wOff = 0;
        int n2 = 0;
        while (n2 != this.W.length) {
            this.W[n2] = 0L;
            ++n2;
        }
    }

    protected void processWord(byte[] byArray, int n) {
        this.W[this.wOff++] = (long)(byArray[n] & 0xFF) << 56 | (long)(byArray[n + 1] & 0xFF) << 48 | (long)(byArray[n + 2] & 0xFF) << 40 | (long)(byArray[n + 3] & 0xFF) << 32 | (long)(byArray[n + 4] & 0xFF) << 24 | (long)(byArray[n + 5] & 0xFF) << 16 | (long)(byArray[n + 6] & 0xFF) << 8 | (long)(byArray[n + 7] & 0xFF);
        if (this.wOff == 16) {
            this.processBlock();
        }
    }

    protected void unpackWord(long l, byte[] byArray, int n) {
        byArray[n] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)l;
    }

    private void adjustByteCounts() {
        if (this.byteCount1 > 0x1FFFFFFFFFFFFFFFL) {
            this.byteCount2 += this.byteCount1 >>> 61;
            this.byteCount1 &= 0x1FFFFFFFFFFFFFFFL;
        }
    }

    protected void processLength(long l, long l2) {
        if (this.wOff > 14) {
            this.processBlock();
        }
        this.W[14] = l2;
        this.W[15] = l;
    }

    protected void processBlock() {
        this.adjustByteCounts();
        int n = 16;
        while (n <= 79) {
            this.W[n] = this.Sigma1(this.W[n - 2]) + this.W[n - 7] + this.Sigma0(this.W[n - 15]) + this.W[n - 16];
            ++n;
        }
        long l = this.H1;
        long l2 = this.H2;
        long l3 = this.H3;
        long l4 = this.H4;
        long l5 = this.H5;
        long l6 = this.H6;
        long l7 = this.H7;
        long l8 = this.H8;
        int n2 = 0;
        while (n2 <= 79) {
            long l9 = l8 + this.Sum1(l5) + this.Ch(l5, l6, l7) + K[n2] + this.W[n2];
            long l10 = this.Sum0(l) + this.Maj(l, l2, l3);
            l8 = l7;
            l7 = l6;
            l6 = l5;
            l5 = l4 + l9;
            l4 = l3;
            l3 = l2;
            l2 = l;
            l = l9 + l10;
            ++n2;
        }
        this.H1 += l;
        this.H2 += l2;
        this.H3 += l3;
        this.H4 += l4;
        this.H5 += l5;
        this.H6 += l6;
        this.H7 += l7;
        this.H8 += l8;
        this.wOff = 0;
        int n3 = 0;
        while (n3 != this.W.length) {
            this.W[n3] = 0L;
            ++n3;
        }
    }

    private long rotateRight(long l, int n) {
        return l >>> n | l << 64 - n;
    }

    private long Ch(long l, long l2, long l3) {
        return l & l2 ^ (l ^ 0xFFFFFFFFFFFFFFFFL) & l3;
    }

    private long Maj(long l, long l2, long l3) {
        return l & l2 ^ l & l3 ^ l2 & l3;
    }

    private long Sum0(long l) {
        return this.rotateRight(l, 28) ^ this.rotateRight(l, 34) ^ this.rotateRight(l, 39);
    }

    private long Sum1(long l) {
        return this.rotateRight(l, 14) ^ this.rotateRight(l, 18) ^ this.rotateRight(l, 41);
    }

    private long Sigma0(long l) {
        return this.rotateRight(l, 1) ^ this.rotateRight(l, 8) ^ l >>> 7;
    }

    private long Sigma1(long l) {
        return this.rotateRight(l, 19) ^ this.rotateRight(l, 61) ^ l >>> 6;
    }

    public abstract String getAlgorithmName();

    public abstract int getDigestSize();

    public abstract int doFinal(byte[] var1, int var2);
}

