/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.math.BigInteger;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x9.X9Curve;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9FieldID;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class X9ECParameters
implements DEREncodable,
X9ObjectIdentifiers {
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private X9FieldID fieldID;
    private ECCurve curve;
    private ECPoint g;
    private BigInteger n;
    private BigInteger h;
    private byte[] seed;

    public X9ECParameters(DERConstructedSequence dERConstructedSequence) {
        if (!(dERConstructedSequence.getObjectAt(0) instanceof DERInteger) || !((DERInteger)dERConstructedSequence.getObjectAt(0)).getValue().equals(ONE)) {
            throw new IllegalArgumentException("bad version in X9ECParameters");
        }
        X9Curve x9Curve = new X9Curve(new X9FieldID((DERConstructedSequence)dERConstructedSequence.getObjectAt(1)), (DERConstructedSequence)dERConstructedSequence.getObjectAt(2));
        this.curve = x9Curve.getCurve();
        this.g = new X9ECPoint(this.curve, (DEROctetString)dERConstructedSequence.getObjectAt(3)).getPoint();
        this.n = ((DERInteger)dERConstructedSequence.getObjectAt(4)).getValue();
        this.seed = x9Curve.getSeed();
        if (dERConstructedSequence.getSize() == 6) {
            this.h = ((DERInteger)dERConstructedSequence.getObjectAt(5)).getValue();
        }
    }

    public X9ECParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger) {
        this(eCCurve, eCPoint, bigInteger, ONE, null);
    }

    public X9ECParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCCurve, eCPoint, bigInteger, bigInteger2, null);
    }

    public X9ECParameters(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        this.curve = eCCurve;
        this.g = eCPoint;
        this.n = bigInteger;
        this.h = bigInteger2;
        this.seed = byArray;
        if (eCCurve instanceof ECCurve.Fp) {
            this.fieldID = new X9FieldID(X9ObjectIdentifiers.prime_field, ((ECCurve.Fp)eCCurve).getQ());
            return;
        }
        this.fieldID = new X9FieldID(X9ObjectIdentifiers.characteristic_two_field, null);
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECPoint getG() {
        return this.g;
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getH() {
        return this.h;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(new DERInteger(1));
        dERConstructedSequence.addObject(this.fieldID);
        dERConstructedSequence.addObject(new X9Curve(this.curve, this.seed));
        dERConstructedSequence.addObject(new X9ECPoint(this.g));
        dERConstructedSequence.addObject(new DERInteger(this.n));
        if (!this.h.equals(BigInteger.valueOf(1L))) {
            dERConstructedSequence.addObject(new DERInteger(this.h));
        }
        return dERConstructedSequence;
    }
}

