/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.X509NameTokenizer;

public class X509Name
implements DEREncodable {
    public static final DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
    public static final DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
    public static final DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
    public static final DERObjectIdentifier T = new DERObjectIdentifier("2.5.4.12");
    public static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
    public static final DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
    public static final DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
    public static final DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
    public static final DERObjectIdentifier EmailAddress;
    public static final DERObjectIdentifier E;
    public static final DERObjectIdentifier DC;
    public static Hashtable OIDLookUp;
    public static Hashtable SymbolLookUp;
    private Vector ordering = new Vector();
    private Vector values = new Vector();
    private ASN1Sequence seq;

    public static X509Name getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return X509Name.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static X509Name getInstance(Object object) {
        if (object instanceof X509Name) {
            return (X509Name)object;
        }
        if (object instanceof ASN1Sequence) {
            return new X509Name((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public X509Name(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            DERSet dERSet = (DERSet)enumeration.nextElement();
            DERConstructedSequence dERConstructedSequence = (DERConstructedSequence)dERSet.getSequence();
            this.ordering.addElement(dERConstructedSequence.getObjectAt(0));
            this.values.addElement(((DERString)((Object)dERConstructedSequence.getObjectAt(1))).getString());
        }
    }

    public X509Name(Hashtable hashtable) {
        this(null, hashtable);
    }

    public X509Name(Vector vector, Hashtable hashtable) {
        if (vector != null) {
            int n = 0;
            while (n != vector.size()) {
                this.ordering.addElement(vector.elementAt(n));
                ++n;
            }
        } else {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                this.ordering.addElement(enumeration.nextElement());
            }
        }
        int n = 0;
        while (n != this.ordering.size()) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.ordering.elementAt(n);
            if (OIDLookUp.get(dERObjectIdentifier) == null) {
                throw new IllegalArgumentException("Unknown object id - " + dERObjectIdentifier.getId() + " - passed to distinguished name");
            }
            if (hashtable.get(dERObjectIdentifier) == null) {
                throw new IllegalArgumentException("No attribute for object id - " + dERObjectIdentifier.getId() + " - passed to distinguished name");
            }
            this.values.addElement(hashtable.get(dERObjectIdentifier));
            ++n;
        }
    }

    public X509Name(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            throw new IllegalArgumentException("ordering vector must be same length as values.");
        }
        int n = 0;
        while (n < vector.size()) {
            this.ordering.addElement(vector.elementAt(n));
            this.values.addElement(vector2.elementAt(n));
            ++n;
        }
    }

    public X509Name(String string) {
        X509NameTokenizer x509NameTokenizer = new X509NameTokenizer(string);
        while (x509NameTokenizer.hasMoreTokens()) {
            String string2 = x509NameTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)SymbolLookUp.get(string3.toLowerCase());
            if (dERObjectIdentifier == null) {
                throw new IllegalArgumentException("Unknown object id - " + string3 + " - passed to distinguished name");
            }
            this.ordering.addElement(dERObjectIdentifier);
            this.values.addElement(string4);
        }
    }

    private boolean canBePrintable(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) > '\u007f') {
                return false;
            }
            --n;
        }
        return true;
    }

    public DERObject getDERObject() {
        if (this.seq == null) {
            this.seq = new DERConstructedSequence();
            int n = 0;
            while (n != this.ordering.size()) {
                DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.ordering.elementAt(n);
                dERConstructedSequence.addObject(dERObjectIdentifier);
                String string = (String)this.values.elementAt(n);
                if (dERObjectIdentifier.equals(EmailAddress)) {
                    dERConstructedSequence.addObject(new DERIA5String(string));
                } else if (this.canBePrintable(string)) {
                    dERConstructedSequence.addObject(new DERPrintableString(string));
                } else {
                    dERConstructedSequence.addObject(new DERUTF8String(string));
                }
                this.seq.addObject(new DERSet(dERConstructedSequence));
                ++n;
            }
        }
        return this.seq;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof X509Name)) {
            return false;
        }
        X509Name x509Name = (X509Name)object;
        int n = this.ordering.size();
        if (n != x509Name.ordering.size()) {
            return false;
        }
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            boolean bl = false;
            String string = ((DERObjectIdentifier)this.ordering.elementAt(n2)).getId();
            String string2 = (String)this.values.elementAt(n2);
            int n3 = 0;
            while (n3 < n) {
                if (!blArray[n3]) {
                    String string3 = ((DERObjectIdentifier)x509Name.ordering.elementAt(n3)).getId();
                    String string4 = (String)x509Name.values.elementAt(n3);
                    if (string.equals(string3) && string2.equals(string4)) {
                        blArray[n3] = true;
                        bl = true;
                        break;
                    }
                }
                ++n3;
            }
            if (!bl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        DERConstructedSequence dERConstructedSequence = (DERConstructedSequence)this.getDERObject();
        Enumeration enumeration = dERConstructedSequence.getObjects();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            n ^= enumeration.nextElement().hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Enumeration enumeration = this.ordering.elements();
        Enumeration enumeration2 = this.values.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = (String)OIDLookUp.get(e);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            if (string != null) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(((DERObjectIdentifier)e).getId());
            }
            stringBuffer.append("=");
            stringBuffer.append((String)enumeration2.nextElement());
        }
        return stringBuffer.toString();
    }

    static {
        E = EmailAddress = new DERObjectIdentifier("1.2.840.113549.1.9.1");
        DC = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
        OIDLookUp = new Hashtable();
        SymbolLookUp = new Hashtable();
        OIDLookUp.put(C, "C");
        OIDLookUp.put(O, "O");
        OIDLookUp.put(T, "T");
        OIDLookUp.put(OU, "OU");
        OIDLookUp.put(CN, "CN");
        OIDLookUp.put(L, "L");
        OIDLookUp.put(ST, "ST");
        OIDLookUp.put(SN, "SN");
        OIDLookUp.put(EmailAddress, "E");
        OIDLookUp.put(DC, "DC");
        SymbolLookUp.put("c", C);
        SymbolLookUp.put("o", O);
        SymbolLookUp.put("t", T);
        SymbolLookUp.put("ou", OU);
        SymbolLookUp.put("cn", CN);
        SymbolLookUp.put("l", L);
        SymbolLookUp.put("st", ST);
        SymbolLookUp.put("sn", SN);
        SymbolLookUp.put("emailaddress", E);
        SymbolLookUp.put("dc", DC);
        SymbolLookUp.put("e", E);
    }
}

