/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.util.DERDump;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class EncryptedPrivateKeyInfoTest
implements Test {
    static byte[] sample1 = Base64.decode("MIIBozA9BgkqhkiG9w0BBQ0wMDAbBgkqhkiG9w0BBQwwDgQIfWBDXwLp4K4CAggAMBEGBSsOAwIHBAiaCF/AvOgQ6QSCAWDWX4BdAzCRNSQSANSuNsT5X8mWYO27mr3Y9c9LoBVXGNmYWKA77MI4967f7SmjNcgXj3xNE/jmnVz6hhsjS8E5VPT3kfyVkpdZ0lr5e9Yk2m3JWpPU7++v5zBkZmC4V/MwV/XuIs6U+vykgzMgpxQg0oZKS9zgmiZof/4dOCL0UtCDnyOSvqT7mCVIcMDIEKu8QbVlgZYBop08l60EuEU3gARUo8WsYQmODz/ldx0Z+znIT0SXVuOwc+RVItC5T/Qx+aijmmpt+9l14nmaGBrEkmuhmtdvU/4vaptewGRgmjOfD6cqK+zs0O5NrrJ3P/6ZSxXj91CQgrThGfOv72bUncXEMNtc8pks2jpHFjGMdKufnadAD7XuMgzkkaklEXZ4f5tU6heIIwr51g0GBEGF96gYPFnjnSQM75JE02Clo+DfcfXpcybPTwwFg2jd6JTTOfkdf6OdSlA/1XNK43FA");
    static byte[] sample2 = Base64.decode("MIIBpjBABgkqhkiG9w0BBQ0wMzAbBgkqhkiG9w0BBQwwDgQIeFeOWl1jywYCAggAMBQGCCqGSIb3DQMHBAjUJ5eGBhQGtQSCAWBrHrRgqO8UUMLcWzZEtpk1l3mjxiF/koCMkHsFwowgyWhEbgIkTgbSViK54LVK8PskekcGNLph+rB6bGZ7pPbL5pbXASJ8+MkQcG3FZdlS4Ek9tTJDApj3O1UubZGFG4uvTlJJFbF1BOJ3MkY3XQ9Gl1qwv7j56e103Da7Cq9+oIDKmznza78XXQYrUsPo8mJGjUxPskEYlzwvHjKubRnYm/K6RKhi5f4zX4BQ/Dt3H812ZjRXrsjAJP0KrD/jyD/jCT7zNBVPH1izBds+RwizyQAHwfNJBFR78TH4cgzB619X47FDVOnT0LqQNVd0O3cSwnPrXE9XR3tPayE+iOB15llFSmi8z0ByOXldEpkezCn92Umk++suzIVj1qfsK+bv2phZWJPbLEIWPDRHUbYf76q5ArAru4xtxT/hoK3krEs/IN3d70qjlUJ36SEw1UaZ82PWhakQbdtu39ZraMJB");
    static byte[] sample3 = Base64.decode("MIIBrjBIBgkqhkiG9w0BBQ0wOzAeBgkqhkiG9w0BBQwwEQQIrHyQPBZqWLUCAggAAgEQMBkGCCqGSIb3DQMCMA0CAToECEhbh7YZKiPSBIIBYCT1zp6o5jpFlIkgwPop7bW1+8ACr4exqzkeb3WflQ8cWJ4cURxzVdvxUnXeW1VJdaQZtjS/QHs5GhPTG/0fwtvnaPfwrIJ3FeGaZfcg2CrYhalOFmEb4xrE4KyoEQmUN8tb/Cg94uzd16BOPw21RDnE8bnPdIGY7TyL95kbkqH23mK53pi7h+xWIgduW+atIqDyyt55f7WMZcvDvlj6VpN/V0h+qxBHL274WA4dj6GYgeyUFpi60HdGCK7By2TBy8h1ZvKGjmB9h8jZvkx1MkbRumXxyFsowTZawyYvO8Um6lbfEDP9zIEUq0IV8RqH2MRyblsPNSikyYhxX/cztdDxRKhilySbSBg5Kr8OfcwKp9bpinN96nmG4xr3Tch1bnVvqJzOQ5+Vva2WwVvH2JkWvYm5WaANg4Q6bRxu9vz7DuhbJjQdZbxFezIAgrJdSe92B00jO/0Kny1WjiVO6DA=");

    public String getName() {
        return "EncryptedPrivateKeyInfoTest";
    }

    private TestResult test(int n, byte[] byArray) {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
        try {
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo((DERConstructedSequence)dERInputStream.readObject());
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": test " + n + " failed construction - exception " + exception.toString());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(encryptedPrivateKeyInfo);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": test " + n + " failed writing - exception " + exception.toString());
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length != byArray.length) {
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray2);
                dERInputStream = new DERInputStream(byteArrayInputStream);
                DERObject dERObject = dERInputStream.readObject();
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": test " + n + " length mismatch - expected " + byArray.length + System.getProperty("line.separator") + DERDump.dumpAsString(encryptedPrivateKeyInfo) + " got " + byArray2.length + System.getProperty("line.separator") + DERDump.dumpAsString(dERObject));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": test " + n + " length mismatch - exception " + exception.toString());
            }
        }
        int n2 = 0;
        while (n2 != byArray2.length) {
            if (byArray2[n2] != byArray[n2]) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": test " + n + " data mismatch");
            }
            ++n2;
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": test " + n + " Okay");
    }

    public TestResult perform() {
        TestResult testResult = this.test(0, sample1);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.test(1, sample2);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.test(2, sample3);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }

    public static void main(String[] stringArray) {
        EncryptedPrivateKeyInfoTest encryptedPrivateKeyInfoTest = new EncryptedPrivateKeyInfoTest();
        TestResult testResult = encryptedPrivateKeyInfoTest.perform();
        System.out.println(testResult.toString());
    }
}

