/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.smime;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import org.bouncycastle.asn1.cms.SubjectKeyIdentifier;
import org.bouncycastle.asn1.smime.SMIMEObjectIdentifiers;

public class SMIMEEncryptionKeyPreferenceAttribute
extends Attribute {
    protected SMIMEEncryptionKeyPreferenceAttribute() {
        this.attrType = SMIMEObjectIdentifiers.id_aa_encrypKeyPref;
    }

    public SMIMEEncryptionKeyPreferenceAttribute(IssuerAndSerialNumber issuerAndSerialNumber) {
        this();
        this.attrValues = new DERConstructedSet();
        this.attrValues.addObject(issuerAndSerialNumber);
    }

    public SMIMEEncryptionKeyPreferenceAttribute(RecipientKeyIdentifier recipientKeyIdentifier) {
        this();
        this.attrValues = new DERConstructedSet();
        this.attrValues.addObject(recipientKeyIdentifier);
    }

    public SMIMEEncryptionKeyPreferenceAttribute(SubjectKeyIdentifier subjectKeyIdentifier) {
        this();
        this.attrValues = new DERConstructedSet();
        this.attrValues.addObject(subjectKeyIdentifier);
    }

    public SMIMEEncryptionKeyPreferenceAttribute(ASN1Sequence aSN1Sequence) {
        this();
        this.attrValues = (DERConstructedSet)aSN1Sequence.getObjectAt(1);
    }

    public SMIMEEncryptionKeyPreferenceAttribute(SMIMEEncryptionKeyPreferenceAttribute sMIMEEncryptionKeyPreferenceAttribute) {
        this();
        this.attrValues = sMIMEEncryptionKeyPreferenceAttribute.attrValues;
    }

    public static Attribute getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SMIMEEncryptionKeyPreferenceAttribute.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static Attribute getInstance(Object object) {
        if (object == null || object instanceof SMIMEEncryptionKeyPreferenceAttribute) {
            return (SMIMEEncryptionKeyPreferenceAttribute)object;
        }
        if (object instanceof IssuerAndSerialNumber) {
            return new SMIMEEncryptionKeyPreferenceAttribute((IssuerAndSerialNumber)object);
        }
        if (object instanceof RecipientKeyIdentifier) {
            return new SMIMEEncryptionKeyPreferenceAttribute((RecipientKeyIdentifier)object);
        }
        if (object instanceof SubjectKeyIdentifier) {
            return new SMIMEEncryptionKeyPreferenceAttribute((SubjectKeyIdentifier)object);
        }
        if (object instanceof ASN1Sequence) {
            return new SMIMEEncryptionKeyPreferenceAttribute((ASN1Sequence)object);
        }
        if (object instanceof ASN1TaggedObject) {
            return SMIMEEncryptionKeyPreferenceAttribute.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SMIMEEncryptionKeyPreferenceAttribute: " + object.getClass().getName());
    }

    public DEREncodable getEncryptionKeyPreference() {
        return this.attrValues.getObjectAt(0);
    }
}

