/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class SignedData
implements DEREncodable,
PKCSObjectIdentifiers {
    private DERInteger version;
    private DERConstructedSet digestAlgorithms;
    private ContentInfo contentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private DERConstructedSet signerInfos;

    public static SignedData getInstance(Object object) {
        if (object instanceof SignedData) {
            return (SignedData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SignedData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public SignedData(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.version = (DERInteger)enumeration.nextElement();
        this.digestAlgorithms = (DERConstructedSet)enumeration.nextElement();
        this.contentInfo = ContentInfo.getInstance(enumeration.nextElement());
        block4: while (enumeration.hasMoreElements()) {
            DERObject dERObject = (DERObject)enumeration.nextElement();
            if (dERObject instanceof DERTaggedObject) {
                DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObject;
                switch (dERTaggedObject.getTagNo()) {
                    case 0: {
                        this.certificates = ASN1Set.getInstance(dERTaggedObject, false);
                        continue block4;
                    }
                    case 1: {
                        this.crls = ASN1Set.getInstance(dERTaggedObject, false);
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag value " + dERTaggedObject.getTagNo());
                    }
                }
            }
            this.signerInfos = (DERConstructedSet)dERObject;
        }
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public DERConstructedSet getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public ASN1Set getCRLS() {
        return this.crls;
    }

    public DERConstructedSet getSignerInfos() {
        return this.signerInfos;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.version);
        dERConstructedSequence.addObject(this.digestAlgorithms);
        dERConstructedSequence.addObject(this.contentInfo);
        if (this.certificates != null) {
            dERConstructedSequence.addObject(new DERTaggedObject(false, 0, this.certificates));
        }
        if (this.crls != null) {
            dERConstructedSequence.addObject(new DERTaggedObject(false, 1, this.crls));
        }
        dERConstructedSequence.addObject(this.signerInfos);
        return dERConstructedSequence;
    }
}

