/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;

public class PBKDF2Params
extends KeyDerivationFunc {
    DERObjectIdentifier id;
    DEROctetString octStr;
    DERInteger iterationCount;
    DERInteger keyLength;

    PBKDF2Params(DERConstructedSequence dERConstructedSequence) {
        super(dERConstructedSequence);
        Enumeration enumeration = dERConstructedSequence.getObjects();
        this.id = (DERObjectIdentifier)enumeration.nextElement();
        DERConstructedSequence dERConstructedSequence2 = (DERConstructedSequence)enumeration.nextElement();
        enumeration = dERConstructedSequence2.getObjects();
        this.octStr = (DEROctetString)enumeration.nextElement();
        this.iterationCount = (DERInteger)enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            this.keyLength = (DERInteger)enumeration.nextElement();
            return;
        }
        this.keyLength = null;
    }

    public byte[] getSalt() {
        return this.octStr.getOctets();
    }

    public BigInteger getIterationCount() {
        return this.iterationCount.getValue();
    }

    public BigInteger getKeyLength() {
        if (this.keyLength != null) {
            return this.keyLength.getValue();
        }
        return null;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        DERConstructedSequence dERConstructedSequence2 = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.id);
        dERConstructedSequence2.addObject(this.octStr);
        dERConstructedSequence2.addObject(this.iterationCount);
        if (this.keyLength != null) {
            dERConstructedSequence2.addObject(this.keyLength);
        }
        dERConstructedSequence.addObject(dERConstructedSequence2);
        return dERConstructedSequence;
    }
}

