/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.DigestAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignatureAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.SignatureValue;
import org.bouncycastle.asn1.cms.SignedAttributes;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SubjectKeyIdentifier;
import org.bouncycastle.asn1.cms.UnsignedAttributes;

public class SignerInfo
extends CMSObject {
    private CMSVersion version;
    private SignerIdentifier sid;
    private DigestAlgorithmIdentifier digestAlgorithm;
    private SignedAttributes signedAttrs;
    private SignatureAlgorithmIdentifier signatureAlgorithm;
    private SignatureValue signature;
    private UnsignedAttributes unsignedAttrs;

    public SignerInfo(SignerIdentifier signerIdentifier, DigestAlgorithmIdentifier digestAlgorithmIdentifier, SignedAttributes signedAttributes, SignatureAlgorithmIdentifier signatureAlgorithmIdentifier, SignatureValue signatureValue, UnsignedAttributes unsignedAttributes) {
        this.setSid(signerIdentifier);
        this.setDigestAlgorithm(digestAlgorithmIdentifier);
        this.setSignedAttrs(signedAttributes);
        this.setSignatureAlgorithm(signatureAlgorithmIdentifier);
        this.setSignature(signatureValue);
        this.setUnsignedAttrs(unsignedAttributes);
        this.setVersion();
    }

    public SignerInfo(ASN1Sequence aSN1Sequence) {
        int n = 0;
        this.version = CMSVersion.getInstance(aSN1Sequence.getObjectAt(n++));
        this.sid = SignerIdentifier.getInstance(aSN1Sequence.getObjectAt(n++));
        this.digestAlgorithm = DigestAlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n++));
        DEREncodable dEREncodable = aSN1Sequence.getObjectAt(n++);
        if (dEREncodable instanceof ASN1TaggedObject) {
            this.signedAttrs = SignedAttributes.getInstance((ASN1TaggedObject)dEREncodable, false);
            dEREncodable = aSN1Sequence.getObjectAt(n++);
        }
        this.signatureAlgorithm = SignatureAlgorithmIdentifier.getInstance(dEREncodable);
        this.signature = SignatureValue.getInstance(aSN1Sequence.getObjectAt(n++));
        if (aSN1Sequence.getSize() > n) {
            this.unsignedAttrs = UnsignedAttributes.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n), false);
        }
    }

    public SignerInfo(SignerInfo signerInfo) {
        this.version = signerInfo.version;
        this.sid = signerInfo.sid;
        this.digestAlgorithm = signerInfo.digestAlgorithm;
        this.signedAttrs = signerInfo.signedAttrs;
        this.signatureAlgorithm = signerInfo.signatureAlgorithm;
        this.signature = signerInfo.signature;
        this.unsignedAttrs = signerInfo.unsignedAttrs;
    }

    public static SignerInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SignerInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static SignerInfo getInstance(Object object) {
        if (object == null || object instanceof SignerInfo) {
            return (SignerInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SignerInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid SignerInfo: " + object.getClass().getName());
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public SignerIdentifier getSid() {
        return this.sid;
    }

    public DigestAlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public SignedAttributes getSignedAttrs() {
        return this.signedAttrs;
    }

    public SignatureAlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public SignatureValue getSignature() {
        return this.signature;
    }

    public UnsignedAttributes getUnsignedAttrs() {
        return this.unsignedAttrs;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.sid);
        bERConstructedSequence.addObject(this.digestAlgorithm);
        if (this.signedAttrs != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.signedAttrs.getDERObject()));
        }
        bERConstructedSequence.addObject(this.signatureAlgorithm);
        bERConstructedSequence.addObject(this.signature);
        if (this.unsignedAttrs != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 1, this.unsignedAttrs.getDERObject()));
        }
        return bERConstructedSequence;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    private void setVersion() {
        DEREncodable dEREncodable = this.sid.getId();
        if (dEREncodable instanceof IssuerAndSerialNumber) {
            this.setVersion(new CMSVersion(new BigInteger("1")));
            return;
        }
        if (dEREncodable instanceof SubjectKeyIdentifier) {
            this.setVersion(new CMSVersion(new BigInteger("3")));
        }
    }

    private void setSid(SignerIdentifier signerIdentifier) {
        this.sid = signerIdentifier;
    }

    private void setDigestAlgorithm(DigestAlgorithmIdentifier digestAlgorithmIdentifier) {
        this.digestAlgorithm = digestAlgorithmIdentifier;
    }

    private void setSignedAttrs(SignedAttributes signedAttributes) {
        this.signedAttrs = signedAttributes;
    }

    private void setSignatureAlgorithm(SignatureAlgorithmIdentifier signatureAlgorithmIdentifier) {
        this.signatureAlgorithm = signatureAlgorithmIdentifier;
    }

    private void setSignature(SignatureValue signatureValue) {
        this.signature = signatureValue;
    }

    private void setUnsignedAttrs(UnsignedAttributes unsignedAttributes) {
        this.unsignedAttrs = unsignedAttributes;
    }
}

