/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SignatureAlgorithmIdentifier
extends CMSObject {
    private AlgorithmIdentifier alg;

    public SignatureAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public SignatureAlgorithmIdentifier(ASN1Sequence aSN1Sequence) {
        this(new AlgorithmIdentifier(aSN1Sequence));
    }

    public SignatureAlgorithmIdentifier(SignatureAlgorithmIdentifier signatureAlgorithmIdentifier) {
        this.alg = signatureAlgorithmIdentifier.alg;
    }

    public SignatureAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier) {
        this(new AlgorithmIdentifier(dERObjectIdentifier));
    }

    public SignatureAlgorithmIdentifier(String string) {
        this(new AlgorithmIdentifier(new DERObjectIdentifier(string)));
    }

    public SignatureAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this(new AlgorithmIdentifier(dERObjectIdentifier, dERObject));
    }

    public static SignatureAlgorithmIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return new SignatureAlgorithmIdentifier(AlgorithmIdentifier.getInstance(aSN1TaggedObject, bl));
    }

    public static SignatureAlgorithmIdentifier getInstance(Object object) {
        if (object == null || object instanceof SignatureAlgorithmIdentifier) {
            return (SignatureAlgorithmIdentifier)object;
        }
        return new SignatureAlgorithmIdentifier(AlgorithmIdentifier.getInstance(object));
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }
}

