/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.EncryptedKey;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;

public class RecipientEncryptedKey
extends CMSObject {
    private KeyAgreeRecipientIdentifier rid;
    private EncryptedKey encryptedKey;

    public RecipientEncryptedKey(KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier, EncryptedKey encryptedKey) {
        this.setRid(keyAgreeRecipientIdentifier);
        this.setEncryptedKey(encryptedKey);
    }

    public RecipientEncryptedKey(ASN1Sequence aSN1Sequence) {
        this.rid = KeyAgreeRecipientIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.encryptedKey = EncryptedKey.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public RecipientEncryptedKey(RecipientEncryptedKey recipientEncryptedKey) {
        this.rid = recipientEncryptedKey.rid;
        this.encryptedKey = recipientEncryptedKey.encryptedKey;
    }

    public static RecipientEncryptedKey getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RecipientEncryptedKey.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static RecipientEncryptedKey getInstance(Object object) {
        if (object == null || object instanceof RecipientEncryptedKey) {
            return (RecipientEncryptedKey)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RecipientEncryptedKey((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid RecipientEncryptedKey: " + object.getClass().getName());
    }

    public KeyAgreeRecipientIdentifier getRid() {
        return this.rid;
    }

    public EncryptedKey getEncryptedKey() {
        return this.encryptedKey;
    }

    private void setEncryptedKey(EncryptedKey encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.rid);
        bERConstructedSequence.addObject(this.encryptedKey);
        return bERConstructedSequence;
    }

    private void setRid(KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier) {
        this.rid = keyAgreeRecipientIdentifier;
    }
}

