/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.OtherKeyAttribute;

public class KEKIdentifier
extends CMSObject {
    private ASN1OctetString keyIdentifier;
    private DERGeneralizedTime date;
    private OtherKeyAttribute other;

    public KEKIdentifier(byte[] byArray, String string, OtherKeyAttribute otherKeyAttribute) {
        this.setKeyIdentifier(byArray);
        this.setDate(string);
        this.setOther(otherKeyAttribute);
    }

    public KEKIdentifier(ASN1Sequence aSN1Sequence) {
        this.keyIdentifier = (ASN1OctetString)aSN1Sequence.getObjectAt(0);
        switch (aSN1Sequence.getSize()) {
            case 2: {
                try {
                    this.date = (DERGeneralizedTime)aSN1Sequence.getObjectAt(1);
                    return;
                }
                catch (Exception exception) {
                    this.other = OtherKeyAttribute.getInstance(aSN1Sequence.getObjectAt(2));
                    return;
                }
            }
            case 3: {
                this.date = (DERGeneralizedTime)aSN1Sequence.getObjectAt(1);
                this.other = OtherKeyAttribute.getInstance(aSN1Sequence.getObjectAt(2));
                return;
            }
            default: {
                throw new IllegalArgumentException("Invalid KEKIdentifier");
            }
            case 1: 
        }
    }

    public KEKIdentifier(KEKIdentifier kEKIdentifier) {
        this.keyIdentifier = kEKIdentifier.keyIdentifier;
        this.date = kEKIdentifier.date;
        this.other = kEKIdentifier.other;
    }

    public static KEKIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return KEKIdentifier.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static KEKIdentifier getInstance(Object object) {
        if (object == null || object instanceof KEKIdentifier) {
            return (KEKIdentifier)object;
        }
        if (object instanceof ASN1Sequence) {
            return new KEKIdentifier((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid KEKIdentifier: " + object.getClass().getName());
    }

    public byte[] getKeyIdentifier() {
        return this.keyIdentifier.getOctets();
    }

    public String getDate() {
        return this.date.getTime();
    }

    public OtherKeyAttribute getOther() {
        return this.other;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.keyIdentifier);
        if (this.date != null) {
            bERConstructedSequence.addObject(this.date);
        }
        if (this.other != null) {
            bERConstructedSequence.addObject(this.other);
        }
        return bERConstructedSequence;
    }

    private void setKeyIdentifier(byte[] byArray) {
        this.keyIdentifier = new BERConstructedOctetString(byArray);
    }

    private void setDate(String string) {
        if (string == null) {
            this.date = null;
            return;
        }
        this.date = new DERGeneralizedTime(string);
    }

    private void setOther(OtherKeyAttribute otherKeyAttribute) {
        this.other = otherKeyAttribute;
    }
}

