/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.UnauthAttributes;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class ExtendedCertificateInfo
extends CMSObject {
    private CMSVersion version;
    private X509CertificateStructure certificate;
    private UnauthAttributes attributes;

    public ExtendedCertificateInfo(ASN1Sequence aSN1Sequence) {
        this.version = CMSVersion.getInstance(aSN1Sequence.getObjectAt(0));
        this.certificate = X509CertificateStructure.getInstance(aSN1Sequence.getObjectAt(1));
        this.attributes = UnauthAttributes.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public ExtendedCertificateInfo(ExtendedCertificateInfo extendedCertificateInfo) {
        this.version = extendedCertificateInfo.version;
        this.certificate = extendedCertificateInfo.certificate;
        this.attributes = extendedCertificateInfo.attributes;
    }

    public static ExtendedCertificateInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ExtendedCertificateInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static ExtendedCertificateInfo getInstance(Object object) {
        if (object == null || object instanceof ExtendedCertificateInfo) {
            return (ExtendedCertificateInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ExtendedCertificateInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid ExtendedCertificateInfo: " + object.getClass().getName());
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.version);
        dERConstructedSequence.addObject(this.certificate);
        dERConstructedSequence.addObject(this.attributes);
        return dERConstructedSequence;
    }

    protected static int getASN1Type() {
        return 1;
    }
}

