/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;

public class EncryptedContent
extends CMSObject {
    private ASN1OctetString content;

    public EncryptedContent(byte[] byArray) {
        this.setContent(byArray);
    }

    public EncryptedContent(ASN1OctetString aSN1OctetString) {
        this.content = aSN1OctetString;
    }

    public EncryptedContent(EncryptedContent encryptedContent) {
        this.content = encryptedContent.content;
    }

    public static EncryptedContent getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return EncryptedContent.getInstance(ASN1OctetString.getInstance(aSN1TaggedObject, bl));
    }

    public static EncryptedContent getInstance(Object object) {
        if (object == null || object instanceof EncryptedContent) {
            return (EncryptedContent)object;
        }
        if (object instanceof ASN1OctetString) {
            return new EncryptedContent((ASN1OctetString)object);
        }
        throw new IllegalArgumentException("Invalid EncryptedContent: " + object.getClass().getName());
    }

    public byte[] getContent() {
        return this.content.getOctets();
    }

    public DERObject getDERObject() {
        return this.content;
    }

    private void setContent(byte[] byArray) {
        this.content = new BERConstructedOctetString(byArray);
    }
}

