/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;

public class ContentType
implements DEREncodable {
    DERObjectIdentifier type;

    public ContentType(DERObjectIdentifier dERObjectIdentifier) {
        this.type = dERObjectIdentifier;
    }

    public ContentType(String string) {
        this.setContentType(string);
    }

    public ContentType(ContentType contentType) {
        this.type = contentType.type;
    }

    public static ContentType getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ContentType.getInstance(DERObjectIdentifier.getInstance(aSN1TaggedObject, bl));
    }

    public static ContentType getInstance(Object object) {
        if (object == null || object instanceof ContentType) {
            return (ContentType)object;
        }
        if (object instanceof DERObjectIdentifier) {
            return new ContentType((DERObjectIdentifier)object);
        }
        if (object instanceof String) {
            return new ContentType((String)object);
        }
        throw new IllegalArgumentException("Invalid ContentType: " + object.getClass().getName());
    }

    public String getContentType() {
        return this.type.getId();
    }

    public DERObject getDERObject() {
        return this.type;
    }

    private void setContentType(String string) {
        this.type = new DERObjectIdentifier(string);
    }
}

