/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.ContentType;

public class ContentInfo
extends CMSObject {
    private ContentType contentType;
    private DEREncodable content;

    public ContentInfo(ContentType contentType, DEREncodable dEREncodable) {
        this.setContentType(contentType);
        this.setContent(dEREncodable);
    }

    public ContentInfo(ASN1Sequence aSN1Sequence) {
        this.contentType = ContentType.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.getSize() > 1) {
            this.content = ((ASN1TaggedObject)aSN1Sequence.getObjectAt(1)).getObject();
        }
    }

    public ContentInfo(ContentInfo contentInfo) {
        this.contentType = contentInfo.contentType;
        this.content = contentInfo.content;
    }

    public static ContentInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ContentInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static ContentInfo getInstance(Object object) {
        if (object == null || object instanceof ContentInfo) {
            return (ContentInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ContentInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid ContentInfo: " + object.getClass().getName());
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public DEREncodable getContent() {
        return this.content;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.contentType);
        if (this.content != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(true, 0, this.content.getDERObject()));
        }
        return bERConstructedSequence;
    }

    private void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    private void setContent(DEREncodable dEREncodable) {
        this.content = dEREncodable;
    }
}

