/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.JCEUtil;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class KeyGenerator {
    private KeyGeneratorSpi keyGenerator;
    private Provider provider;
    private String algorithm;

    protected KeyGenerator(KeyGeneratorSpi keyGeneratorSpi, Provider provider, String string) {
        this.keyGenerator = keyGeneratorSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyGenerator getInstance(String string) throws NoSuchAlgorithmException {
        try {
            JCEUtil.Implementation implementation = JCEUtil.getImplementation("KeyGenerator", string, null);
            if (implementation == null) {
                throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
            }
            KeyGenerator keyGenerator = new KeyGenerator((KeyGeneratorSpi)implementation.getEngine(), implementation.getProvider(), string);
            return keyGenerator;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
    }

    public static final KeyGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("No provider specified to KeyGenerator.getInstance()");
        }
        JCEUtil.Implementation implementation = JCEUtil.getImplementation("KeyGenerator", string, string2);
        if (implementation == null) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
        KeyGenerator keyGenerator = new KeyGenerator((KeyGeneratorSpi)implementation.getEngine(), implementation.getProvider(), string);
        return keyGenerator;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(SecureRandom secureRandom) {
        this.keyGenerator.engineInit(secureRandom);
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.keyGenerator.engineInit(algorithmParameterSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.keyGenerator.engineInit(algorithmParameterSpec, secureRandom);
    }

    public final void init(int n) {
        this.keyGenerator.engineInit(n, new SecureRandom());
    }

    public final void init(int n, SecureRandom secureRandom) {
        this.keyGenerator.engineInit(n, secureRandom);
    }

    public final SecretKey generateKey() {
        return this.keyGenerator.engineGenerateKey();
    }
}

