/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.JCEUtil;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class Cipher {
    private static final int UNINITIALIZED = 0;
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int WRAP_MODE = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int PUBLIC_KEY = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int SECRET_KEY = 3;
    private CipherSpi cipherSpi;
    private Provider provider;
    private String transformation;
    private int mode = 0;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        this.cipherSpi = cipherSpi;
        this.provider = provider;
        this.transformation = string;
    }

    public static final Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            JCEUtil.Implementation implementation = JCEUtil.getImplementation("Cipher", string, null);
            if (implementation != null) {
                return new Cipher((CipherSpi)implementation.getEngine(), implementation.getProvider(), string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string2 = stringTokenizer.nextToken();
            implementation = JCEUtil.getImplementation("Cipher", string2, null);
            if (implementation == null) {
                throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
            }
            CipherSpi cipherSpi = (CipherSpi)implementation.getEngine();
            if (stringTokenizer.hasMoreTokens() && !string.regionMatches(string2.length(), "//", 0, 2)) {
                cipherSpi.engineSetMode(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                cipherSpi.engineSetPadding(stringTokenizer.nextToken());
            }
            return new Cipher(cipherSpi, implementation.getProvider(), string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
    }

    public static final Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        JCEUtil.Implementation implementation = JCEUtil.getImplementation("Cipher", string, string2);
        if (implementation != null) {
            return new Cipher((CipherSpi)implementation.getEngine(), implementation.getProvider(), string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string3 = stringTokenizer.nextToken();
        implementation = JCEUtil.getImplementation("Cipher", string3, string2);
        if (implementation == null) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
        CipherSpi cipherSpi = (CipherSpi)implementation.getEngine();
        if (stringTokenizer.hasMoreTokens() && !string.regionMatches(string3.length(), "//", 0, 2)) {
            cipherSpi.engineSetMode(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            cipherSpi.engineSetPadding(stringTokenizer.nextToken());
        }
        return new Cipher(cipherSpi, implementation.getProvider(), string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() {
        return this.cipherSpi.engineGetBlockSize();
    }

    public final int getOutputSize(int n) throws IllegalStateException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is uninitialised");
        }
        return this.cipherSpi.engineGetOutputSize(n);
    }

    public final byte[] getIV() {
        return this.cipherSpi.engineGetIV();
    }

    public final AlgorithmParameters getParameters() {
        return this.cipherSpi.engineGetParameters();
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return null;
    }

    public final void init(int n, Key key) throws InvalidKeyException {
        this.cipherSpi.engineInit(n, key, new SecureRandom());
        this.mode = n;
    }

    public final void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.cipherSpi.engineInit(n, key, secureRandom);
        this.mode = n;
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(n, key, algorithmParameterSpec, new SecureRandom());
        this.mode = n;
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(n, key, algorithmParameterSpec, secureRandom);
        this.mode = n;
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(n, key, algorithmParameters, new SecureRandom());
        this.mode = n;
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(n, key, algorithmParameters, secureRandom);
        this.mode = n;
    }

    public final void init(int n, Certificate certificate) throws InvalidKeyException {
        this.cipherSpi.engineInit(n, certificate.getPublicKey(), new SecureRandom());
        this.mode = n;
    }

    public final void init(int n, Certificate certificate, SecureRandom secureRandom) throws InvalidKeyException {
        this.cipherSpi.engineInit(n, certificate.getPublicKey(), secureRandom);
        this.mode = n;
    }

    public final byte[] update(byte[] byArray) throws IllegalStateException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is uninitialised");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        if (byArray.length == 0) {
            return null;
        }
        return this.cipherSpi.engineUpdate(byArray, 0, byArray.length);
    }

    public final byte[] update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is uninitialised");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input passed");
        }
        if (n2 < 0 || n < 0 || n2 > byArray.length - n) {
            throw new IllegalArgumentException("Bad inputOffset/inputLen");
        }
        if (n2 == 0) {
            return null;
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is uninitialised");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input passed");
        }
        if (n2 < 0 || n < 0 || n2 > byArray.length - n) {
            throw new IllegalArgumentException("Bad inputOffset/inputLen");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("Null output passed");
        }
        if (n2 == 0) {
            return 0;
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2, byArray2, 0);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is uninitialised");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input passed");
        }
        if (n2 < 0 || n < 0 || n2 > byArray.length - n) {
            throw new IllegalArgumentException("Bad inputOffset/inputLen");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("Null output passed");
        }
        if (n3 < 0 || n3 >= byArray2.length) {
            throw new IllegalArgumentException("Bad outputOffset");
        }
        if (n2 == 0) {
            return 0;
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is uninitialised");
        }
        return this.cipherSpi.engineDoFinal(null, 0, 0);
    }

    public final int doFinal(byte[] byArray, int n) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is uninitialised");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null output passed");
        }
        if (n < 0 || n >= byArray.length) {
            throw new IllegalArgumentException("Bad outputOffset");
        }
        return this.cipherSpi.engineDoFinal(null, 0, 0, byArray, n);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is uninitialised");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input passed");
        }
        return this.cipherSpi.engineDoFinal(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is uninitialised");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input passed");
        }
        if (n2 < 0 || n < 0 || n2 > byArray.length - n) {
            throw new IllegalArgumentException("Bad inputOffset/inputLen");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is uninitialised");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input passed");
        }
        if (n2 < 0 || n < 0 || n2 > byArray.length - n) {
            throw new IllegalArgumentException("Bad inputOffset/inputLen");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("Null output passed");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2, byArray2, 0);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Cipher is uninitialised");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null input passed");
        }
        if (n2 < 0 || n < 0 || n2 > byArray.length - n) {
            throw new IllegalArgumentException("Bad inputOffset/inputLen");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("Null output passed");
        }
        if (n3 < 0 || n3 >= byArray2.length) {
            throw new IllegalArgumentException("Bad outputOffset");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        if (this.mode != 3) {
            throw new IllegalStateException("Cipher is not initialised for wrapping");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key passed");
        }
        return this.cipherSpi.engineWrap(key);
    }

    public final Key unwrap(byte[] byArray, String string, int n) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (this.mode != 4) {
            throw new IllegalStateException("Cipher is not initialised for unwrapping");
        }
        if (n != 3 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid key type argument");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null wrappedKey passed");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null wrappedKeyAlgorithm string passed");
        }
        return this.cipherSpi.engineUnwrap(byArray, string, n);
    }
}

