/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertUtil;

public class CertPathBuilder {
    private CertPathBuilderSpi builderSpi;
    private Provider provider;
    private String algorithm;

    protected CertPathBuilder(CertPathBuilderSpi certPathBuilderSpi, Provider provider, String string) {
        this.builderSpi = certPathBuilderSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static CertPathBuilder getInstance(String string) throws NoSuchAlgorithmException {
        try {
            CertUtil.Implementation implementation = CertUtil.getImplementation("CertPathBuilder", string, null);
            if (implementation != null) {
                return new CertPathBuilder((CertPathBuilderSpi)implementation.getEngine(), implementation.getProvider(), string);
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {}
        throw new NoSuchAlgorithmException("can't find type " + string);
    }

    public static CertPathBuilder getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider must be non-null");
        }
        CertUtil.Implementation implementation = CertUtil.getImplementation("CertPathBuilder", string, string2);
        if (implementation != null) {
            return new CertPathBuilder((CertPathBuilderSpi)implementation.getEngine(), implementation.getProvider(), string);
        }
        throw new NoSuchAlgorithmException("can't find type " + string);
    }

    public static CertPathBuilder getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("provider must be non-null");
        }
        CertUtil.Implementation implementation = CertUtil.getImplementation("CertPathBuilder", string, provider);
        if (implementation != null) {
            return new CertPathBuilder((CertPathBuilderSpi)implementation.getEngine(), provider, string);
        }
        throw new NoSuchAlgorithmException("can't find type " + string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final CertPathBuilderResult build(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        return this.builderSpi.engineBuild(certPathParameters);
    }

    public static final String getDefaultType() {
        String string = null;
        string = Security.getProperty("certpathbuilder.type");
        if (string == null || string.length() <= 0) {
            return "PKIX";
        }
        return string;
    }
}

