/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecurityUtil;
import java.security.spec.AlgorithmParameterSpec;

public class AlgorithmParameterGenerator {
    AlgorithmParameterGeneratorSpi spi;
    Provider provider;
    String algorithm;

    protected AlgorithmParameterGenerator(AlgorithmParameterGeneratorSpi algorithmParameterGeneratorSpi, Provider provider, String string) {
        this.spi = algorithmParameterGeneratorSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final AlgorithmParameters generateParameters() {
        return this.spi.engineGenerateParameters();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static AlgorithmParameterGenerator getInstance(String string) throws NoSuchAlgorithmException {
        try {
            SecurityUtil.Implementation implementation = SecurityUtil.getImplementation("KeyFactory", string, null);
            if (implementation != null) {
                return new AlgorithmParameterGenerator((AlgorithmParameterGeneratorSpi)implementation.getEngine(), implementation.getProvider(), string);
            }
            throw new NoSuchAlgorithmException("can't find algorithm " + string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
    }

    public static AlgorithmParameterGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtil.Implementation implementation = SecurityUtil.getImplementation("KeyFactory", string, null);
        if (implementation != null) {
            return new AlgorithmParameterGenerator((AlgorithmParameterGeneratorSpi)implementation.getEngine(), implementation.getProvider(), string);
        }
        throw new NoSuchAlgorithmException("can't find algorithm " + string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.spi.engineInit(algorithmParameterSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.spi.engineInit(algorithmParameterSpec, secureRandom);
    }

    public final void init(int n) {
        this.spi.engineInit(n, new SecureRandom());
    }

    public final void init(int n, SecureRandom secureRandom) {
        this.spi.engineInit(n, secureRandom);
    }
}

