/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jce.netscape.NetscapeCertRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class NetscapeCertRequestTest
implements Test {
    static final String test1 = "MIIBRzCBsTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAmwdh+LJXQ8AtXczo4EIGfXjpmDwsoIRpPaXEx1CBHhpon/Dpo/o5Vw2WoWNICXj5lmqhftIpCPO9qKxx85x6k/fuyTPH8P02hkmscAYsgqOgb/1yRCNXFryuFOATqxw1tsuye5Q3lTU9JCLUUilQ6BV8n3fm2egtPPUaJEuCvcsCAwEAARYNZml4ZWQtZm9yLW5vdzANBgkqhkiG9w0BAQQFAAOBgQAImbJD6xHbJtXl6kOTbCFoMnDk7U0o6pHy9l56DYVsiluXegiY6twB4o7OWsrqTb+gVvzK65FfP+NBVVzxY8UzcjbqC51yvO/9wnpUsIBqD/Gvi1gEqvw7RHwVEhdzsvLwlL22G8CfDxHnWLww39j8uRJsmoNiKJly3BcsZkLd9g==";

    public String getName() {
        return "NetscapeCertRequest";
    }

    public TestResult perform() {
        try {
            String string = "fixed-for-now";
            byte[] byArray = Base64.decode(test1);
            DERInputStream dERInputStream = new DERInputStream(new ByteArrayInputStream(byArray));
            DERConstructedSequence dERConstructedSequence = (DERConstructedSequence)dERInputStream.readObject();
            NetscapeCertRequest netscapeCertRequest = new NetscapeCertRequest(dERConstructedSequence);
            if (!netscapeCertRequest.verify(string)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": 1 - not verified");
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(netscapeCertRequest.getKeyAlgorithm().getObjectId().getId(), "BC");
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            netscapeCertRequest.setPublicKey(keyPair.getPublic());
            netscapeCertRequest.sign(keyPair.getPrivate());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(netscapeCertRequest);
            dEROutputStream.close();
            DERInputStream dERInputStream2 = new DERInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            DERConstructedSequence dERConstructedSequence2 = (DERConstructedSequence)dERInputStream2.readObject();
            NetscapeCertRequest netscapeCertRequest2 = new NetscapeCertRequest(dERConstructedSequence2);
            if (!netscapeCertRequest2.verify(string)) {
                return new SimpleTestResult(false, String.valueOf(this.getName()) + ": 2 - not verified");
            }
            string = "try it";
            NetscapeCertRequest netscapeCertRequest3 = new NetscapeCertRequest(string, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, null), keyPair.getPublic());
            netscapeCertRequest3.sign(keyPair.getPrivate());
            if (netscapeCertRequest3.verify(string)) {
                return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
            }
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": 3 - not verified");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": exception - " + exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        NetscapeCertRequestTest netscapeCertRequestTest = new NetscapeCertRequestTest();
        TestResult testResult = netscapeCertRequestTest.perform();
        System.out.println(testResult.toString());
    }
}

