/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class AESWrapEngine
implements Wrapper {
    private BlockCipher engine = new AESEngine();
    private KeyParameter param;
    private boolean forWrapping;
    private byte[] iv = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forWrapping = bl;
        if (cipherParameters instanceof KeyParameter) {
            this.param = (KeyParameter)cipherParameters;
            return;
        }
        if (cipherParameters instanceof ParametersWithIV) {
            this.iv = ((ParametersWithIV)cipherParameters).getIV();
            this.param = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
            if (this.iv.length != 8) {
                throw new IllegalArgumentException("IV not multiple of 8");
            }
        }
    }

    public String getAlgorithmName() {
        return "AES";
    }

    public byte[] wrap(byte[] byArray, int n, int n2) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n3 = n2 / 8;
        if (n3 * 8 != n2) {
            throw new DataLengthException("wrap data must be a multiple of 8 bytes");
        }
        byte[] byArray2 = new byte[n2 + this.iv.length];
        byte[] byArray3 = new byte[8 + this.iv.length];
        System.arraycopy(this.iv, 0, byArray2, 0, this.iv.length);
        System.arraycopy(byArray, 0, byArray2, this.iv.length, n2);
        this.engine.init(true, this.param);
        int n4 = 0;
        while (n4 != 6) {
            int n5 = 1;
            while (n5 <= n3) {
                System.arraycopy(byArray2, 0, byArray3, 0, this.iv.length);
                System.arraycopy(byArray2, 8 * n5, byArray3, this.iv.length, 8);
                this.engine.processBlock(byArray3, 0, byArray3, 0);
                int n6 = n3 * n4 + n5;
                int n7 = 1;
                while (n6 != 0) {
                    byte by = (byte)n6;
                    int n8 = this.iv.length - n7;
                    byArray3[n8] = (byte)(byArray3[n8] ^ by);
                    n6 >>>= 8;
                    ++n7;
                }
                System.arraycopy(byArray3, 0, byArray2, 0, 8);
                System.arraycopy(byArray3, 8, byArray2, 8 * n5, 8);
                ++n5;
            }
            ++n4;
        }
        return byArray2;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        int n3;
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n4 = n2 / 8;
        if (n4 * 8 != n2) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        byte[] byArray2 = new byte[n2 - this.iv.length];
        byte[] byArray3 = new byte[this.iv.length];
        byte[] byArray4 = new byte[8 + this.iv.length];
        System.arraycopy(byArray, 0, byArray3, 0, this.iv.length);
        System.arraycopy(byArray, this.iv.length, byArray2, 0, n2 - this.iv.length);
        this.engine.init(false, this.param);
        --n4;
        int n5 = 5;
        while (n5 >= 0) {
            n3 = n4;
            while (n3 >= 1) {
                System.arraycopy(byArray3, 0, byArray4, 0, this.iv.length);
                System.arraycopy(byArray2, 8 * (n3 - 1), byArray4, this.iv.length, 8);
                int n6 = n4 * n5 + n3;
                int n7 = 1;
                while (n6 != 0) {
                    byte by = (byte)n6;
                    int n8 = this.iv.length - n7;
                    byArray4[n8] = (byte)(byArray4[n8] ^ by);
                    n6 >>>= 8;
                    ++n7;
                }
                this.engine.processBlock(byArray4, 0, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray3, 0, 8);
                System.arraycopy(byArray4, 8, byArray2, 8 * (n3 - 1), 8);
                --n3;
            }
            --n5;
        }
        n3 = 0;
        while (n3 != this.iv.length) {
            if (byArray3[n3] != this.iv[n3]) {
                throw new InvalidCipherTextException("checksum failed");
            }
            ++n3;
        }
        return byArray2;
    }
}

