/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;

public class DHParameter
implements DEREncodable {
    DERInteger p;
    DERInteger g;
    DERInteger l;

    public DHParameter(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        this.p = new DERInteger(bigInteger);
        this.g = new DERInteger(bigInteger2);
        if (n != 0) {
            this.l = new DERInteger(n);
            return;
        }
        this.l = null;
    }

    public DHParameter(DERConstructedSequence dERConstructedSequence) {
        Enumeration enumeration = dERConstructedSequence.getObjects();
        this.p = (DERInteger)enumeration.nextElement();
        this.g = (DERInteger)enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            this.l = (DERInteger)enumeration.nextElement();
            return;
        }
        this.l = null;
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public BigInteger getL() {
        if (this.l == null) {
            return null;
        }
        return this.l.getPositiveValue();
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.p);
        dERConstructedSequence.addObject(this.g);
        if (this.getL() != null) {
            dERConstructedSequence.addObject(this.l);
        }
        return dERConstructedSequence;
    }
}

