/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;

public class RecipientInfo
extends CMSObject {
    private DEREncodable info;

    public RecipientInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        this.setInfo(keyTransRecipientInfo);
    }

    public RecipientInfo(KeyAgreeRecipientInfo keyAgreeRecipientInfo) {
        this.setInfo(keyAgreeRecipientInfo);
    }

    public RecipientInfo(KEKRecipientInfo kEKRecipientInfo) {
        this.setInfo(kEKRecipientInfo);
    }

    public RecipientInfo(DERObject dERObject) {
        if (dERObject instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)dERObject;
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    this.info = KeyAgreeRecipientInfo.getInstance(aSN1TaggedObject, false);
                    return;
                }
                case 2: {
                    this.info = KEKRecipientInfo.getInstance(aSN1TaggedObject, false);
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid RecipientInfo");
        }
        this.info = KeyTransRecipientInfo.getInstance(dERObject);
    }

    public RecipientInfo(RecipientInfo recipientInfo) {
        this.info = recipientInfo.info;
    }

    public static RecipientInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RecipientInfo.getInstance(aSN1TaggedObject);
    }

    public static RecipientInfo getInstance(Object object) {
        if (object == null || object instanceof RecipientInfo) {
            return (RecipientInfo)object;
        }
        if (object instanceof KeyTransRecipientInfo) {
            return new RecipientInfo((KeyTransRecipientInfo)object);
        }
        if (object instanceof KeyAgreeRecipientInfo) {
            return new RecipientInfo((KeyAgreeRecipientInfo)object);
        }
        if (object instanceof KEKRecipientInfo) {
            return new RecipientInfo((KEKRecipientInfo)object);
        }
        if (object instanceof DERObject) {
            return new RecipientInfo((DERObject)object);
        }
        throw new IllegalArgumentException("Invalid RecipientInfo: " + object.getClass().getName());
    }

    public DEREncodable getInfo() {
        return this.info;
    }

    public DERObject getDERObject() {
        if (this.info instanceof KeyAgreeRecipientInfo) {
            return new BERTaggedObject(false, 1, this.info.getDERObject());
        }
        if (this.info instanceof KEKRecipientInfo) {
            return new BERTaggedObject(false, 2, this.info.getDERObject());
        }
        return this.info.getDERObject();
    }

    public CMSVersion getVersion() {
        if (this.info instanceof KeyAgreeRecipientInfo) {
            return ((KeyAgreeRecipientInfo)this.info).getVersion();
        }
        if (this.info instanceof KEKRecipientInfo) {
            return ((KEKRecipientInfo)this.info).getVersion();
        }
        return ((KeyTransRecipientInfo)this.info).getVersion();
    }

    private void setInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        this.info = keyTransRecipientInfo;
    }

    private void setInfo(KeyAgreeRecipientInfo keyAgreeRecipientInfo) {
        this.info = keyAgreeRecipientInfo;
    }

    private void setInfo(KEKRecipientInfo kEKRecipientInfo) {
        this.info = kEKRecipientInfo;
    }
}

