/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollection
implements Collection {
    protected AbstractCollection() {
    }

    public abstract Iterator iterator();

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (!(object == null ? object2 == null : object.equals(object2))) continue;
            return true;
        }
        return false;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n++] = iterator.next();
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) throws NullPointerException, ArrayStoreException {
        Iterator iterator;
        if (objectArray == null) {
            throw new NullPointerException();
        }
        Object[] objectArray2 = null;
        int n = this.size();
        if (objectArray.length < n) {
            iterator = this.iterator();
            Object object = iterator.next();
            if (object == null) {
                throw new ArrayStoreException();
            }
            objectArray2 = (Object[])Array.newInstance(object.getClass(), n);
        } else {
            objectArray2 = objectArray;
            if (objectArray.length > n) {
                objectArray2[n] = null;
            }
        }
        iterator = this.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            objectArray2[n2++] = object;
        }
        return objectArray2;
    }

    public boolean add(Object object) throws UnsupportedOperationException, NullPointerException, ClassCastException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) throws UnsupportedOperationException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (object == null) {
                if (object2 != null) continue;
                iterator.remove();
                return true;
            }
            if (!object.equals(object2)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) throws UnsupportedOperationException {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    public boolean removeAll(Collection collection) throws UnsupportedOperationException {
        Iterator iterator = this.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) throws UnsupportedOperationException {
        Iterator iterator = this.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public void clear() throws UnsupportedOperationException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public String toString() {
        String string = "[";
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            string = String.valueOf(string) + String.valueOf(iterator.next());
        }
        while (iterator.hasNext()) {
            string = String.valueOf(string) + ", ";
            string = String.valueOf(string) + String.valueOf(iterator.next());
        }
        string = String.valueOf(string) + "]";
        return string;
    }
}

