/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;

public class UserKeyingMaterial
extends CMSObject {
    private ASN1OctetString material;

    public UserKeyingMaterial(byte[] byArray) {
        this.setMaterial(byArray);
    }

    public UserKeyingMaterial(ASN1OctetString aSN1OctetString) {
        this.material = aSN1OctetString;
    }

    public UserKeyingMaterial(UserKeyingMaterial userKeyingMaterial) {
        this.material = userKeyingMaterial.material;
    }

    public static UserKeyingMaterial getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return UserKeyingMaterial.getInstance(ASN1OctetString.getInstance(aSN1TaggedObject, bl));
    }

    public static UserKeyingMaterial getInstance(Object object) {
        if (object == null || object instanceof UserKeyingMaterial) {
            return (UserKeyingMaterial)object;
        }
        if (object instanceof ASN1OctetString) {
            return new UserKeyingMaterial((ASN1OctetString)object);
        }
        throw new IllegalArgumentException("Invalid UserKeyingMaterial: " + object.getClass().getName());
    }

    public byte[] getMaterial() {
        return this.material.getOctets();
    }

    public DERObject getDERObject() {
        return this.material;
    }

    private void setMaterial(byte[] byArray) {
        this.material = new BERConstructedOctetString(byArray);
    }
}

