/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.SignerInfo;

public class SignerInfos
extends CMSObject {
    private ASN1Set infos;

    public SignerInfos(Vector vector) {
        this.setInfos(vector);
    }

    public SignerInfos(ASN1Set aSN1Set) {
        this.infos = aSN1Set;
    }

    public SignerInfos(SignerInfos signerInfos) {
        this.infos = signerInfos.infos;
    }

    public static SignerInfos getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SignerInfos.getInstance(ASN1Set.getInstance(aSN1TaggedObject, bl));
    }

    public static SignerInfos getInstance(Object object) {
        if (object == null || object instanceof SignerInfos) {
            return (SignerInfos)object;
        }
        if (object instanceof ASN1Set) {
            return new SignerInfos((ASN1Set)object);
        }
        throw new IllegalArgumentException("Invalid SignerInfos: " + object.getClass().getName());
    }

    public Vector getInfos() {
        int n = this.infos.getSize();
        Vector<SignerInfo> vector = new Vector<SignerInfo>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(SignerInfo.getInstance(this.infos.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    public DERObject getDERObject() {
        return this.infos;
    }

    private void setInfos(Vector vector) {
        int n = vector.size();
        this.infos = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.infos.addObject(SignerInfo.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }
}

