/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.CertificateRevocationLists;
import org.bouncycastle.asn1.cms.CertificateSet;
import org.bouncycastle.asn1.cms.ContentType;
import org.bouncycastle.asn1.cms.DigestAlgorithmIdentifiers;
import org.bouncycastle.asn1.cms.EncapsulatedContentInfo;
import org.bouncycastle.asn1.cms.SignerInfos;

public class SignedData
extends CMSObject {
    private CMSVersion version;
    private DigestAlgorithmIdentifiers digestAlgorithms;
    private EncapsulatedContentInfo encapContentInfo;
    private CertificateSet certificates;
    private CertificateRevocationLists crls;
    private SignerInfos signerInfos;

    public SignedData(String string, byte[] byArray) {
        this.setDigestAlgorithms(new DigestAlgorithmIdentifiers(new Vector()));
        this.setEncapContentInfo(new EncapsulatedContentInfo(new ContentType(string), byArray));
        this.setCertificates(null);
        this.setCrls(null);
        this.setSignerInfos(new SignerInfos(new Vector()));
        this.setVersion();
    }

    public SignedData(DigestAlgorithmIdentifiers digestAlgorithmIdentifiers, EncapsulatedContentInfo encapsulatedContentInfo, CertificateSet certificateSet, CertificateRevocationLists certificateRevocationLists, SignerInfos signerInfos) {
        this.setDigestAlgorithms(digestAlgorithmIdentifiers);
        this.setEncapContentInfo(encapsulatedContentInfo);
        this.setCertificates(certificateSet);
        this.setCrls(certificateRevocationLists);
        this.setSignerInfos(signerInfos);
        this.setVersion();
    }

    public SignedData(ASN1Sequence aSN1Sequence) {
        int n = 0;
        this.version = CMSVersion.getInstance(aSN1Sequence.getObjectAt(n++));
        this.digestAlgorithms = DigestAlgorithmIdentifiers.getInstance(aSN1Sequence.getObjectAt(n++));
        this.encapContentInfo = EncapsulatedContentInfo.getInstance(aSN1Sequence.getObjectAt(n++));
        block0 : switch (aSN1Sequence.getSize()) {
            case 5: {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(n++);
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.certificates = CertificateSet.getInstance(aSN1TaggedObject, false);
                        break block0;
                    }
                    case 1: {
                        this.crls = CertificateRevocationLists.getInstance(aSN1TaggedObject, false);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid SignedData -- Bad tag: " + aSN1TaggedObject.getTagNo());
            }
            case 6: {
                this.certificates = CertificateSet.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n++), false);
                this.crls = CertificateRevocationLists.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n++), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid SignedData");
            }
            case 4: 
        }
        this.signerInfos = SignerInfos.getInstance(aSN1Sequence.getObjectAt(n));
    }

    public SignedData(SignedData signedData) {
        this.version = signedData.version;
        this.digestAlgorithms = signedData.digestAlgorithms;
        this.encapContentInfo = signedData.encapContentInfo;
        this.certificates = signedData.certificates;
        this.crls = signedData.crls;
        this.signerInfos = signedData.signerInfos;
    }

    public static SignedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SignedData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static SignedData getInstance(Object object) {
        if (object == null || object instanceof SignedData) {
            return (SignedData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SignedData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid SignedData: " + object.getClass().getName());
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public DigestAlgorithmIdentifiers getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public EncapsulatedContentInfo getEncapContentInfo() {
        return this.encapContentInfo;
    }

    public CertificateSet getCertificates() {
        return this.certificates;
    }

    public CertificateRevocationLists getCrls() {
        return this.crls;
    }

    public SignerInfos getSignerInfos() {
        return this.signerInfos;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.digestAlgorithms);
        bERConstructedSequence.addObject(this.encapContentInfo);
        if (this.certificates != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.certificates.getDERObject()));
        }
        if (this.crls != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 1, this.crls.getDERObject()));
        }
        bERConstructedSequence.addObject(this.signerInfos);
        return bERConstructedSequence;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    private void setVersion() {
        this.setVersion(new CMSVersion(new BigInteger("1")));
    }

    private void setDigestAlgorithms(DigestAlgorithmIdentifiers digestAlgorithmIdentifiers) {
        this.digestAlgorithms = digestAlgorithmIdentifiers;
    }

    private void setEncapContentInfo(EncapsulatedContentInfo encapsulatedContentInfo) {
        this.encapContentInfo = encapsulatedContentInfo;
    }

    private void setCertificates(CertificateSet certificateSet) {
        this.certificates = certificateSet;
    }

    private void setCrls(CertificateRevocationLists certificateRevocationLists) {
        this.crls = certificateRevocationLists;
    }

    private void setSignerInfos(SignerInfos signerInfos) {
        this.signerInfos = signerInfos;
    }
}

