/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;

public class Signature
extends CMSObject {
    private DERBitString bitString;

    public Signature(byte[] byArray) {
        this.setBitString(byArray);
    }

    public Signature(DERBitString dERBitString) {
        this.bitString = dERBitString;
    }

    public Signature(Signature signature) {
        this.bitString = signature.bitString;
    }

    public static Signature getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return Signature.getInstance(DERBitString.getInstance(aSN1TaggedObject, bl));
    }

    public static Signature getInstance(Object object) {
        if (object == null || object instanceof Signature) {
            return (Signature)object;
        }
        if (object instanceof DERBitString) {
            return new Signature((DERBitString)object);
        }
        throw new IllegalArgumentException("Invalid Signature: " + object.getClass().getName());
    }

    public byte[] getBitString() {
        return this.bitString.getBytes();
    }

    public DERObject getDERObject() {
        return this.bitString;
    }

    private void setBitString(byte[] byArray) {
        this.bitString = new DERBitString(byArray);
    }
}

