/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.x509.X509Name;

public class IssuerAndSerialNumber
extends CMSObject {
    private X509Name issuer;
    private DERInteger serialNumber;

    public IssuerAndSerialNumber(X509Name x509Name, BigInteger bigInteger) {
        this.setIssuer(x509Name);
        this.setSerialNumber(bigInteger);
    }

    public IssuerAndSerialNumber(ASN1Sequence aSN1Sequence) {
        this.issuer = X509Name.getInstance(aSN1Sequence.getObjectAt(0));
        this.serialNumber = (DERInteger)aSN1Sequence.getObjectAt(1);
    }

    public IssuerAndSerialNumber(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.issuer = issuerAndSerialNumber.issuer;
        this.serialNumber = issuerAndSerialNumber.serialNumber;
    }

    public static IssuerAndSerialNumber getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return IssuerAndSerialNumber.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static IssuerAndSerialNumber getInstance(Object object) {
        if (object == null || object instanceof IssuerAndSerialNumber) {
            return (IssuerAndSerialNumber)object;
        }
        if (object instanceof ASN1Sequence) {
            return new IssuerAndSerialNumber((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid IssuerAndSerialNumber: " + object.getClass().getName());
    }

    public X509Name getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber.getValue();
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.issuer);
        bERConstructedSequence.addObject(this.serialNumber);
        return bERConstructedSequence;
    }

    private void setIssuer(X509Name x509Name) {
        this.issuer = x509Name;
    }

    private void setSerialNumber(BigInteger bigInteger) {
        this.serialNumber = new DERInteger(bigInteger);
    }
}

