/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSObject;
import org.bouncycastle.asn1.cms.DigestAlgorithmIdentifier;

public class DigestAlgorithmIdentifiers
extends CMSObject {
    private ASN1Set identifiers;

    public DigestAlgorithmIdentifiers(Vector vector) {
        this.setIdentifiers(vector);
    }

    public DigestAlgorithmIdentifiers(ASN1Set aSN1Set) {
        this.identifiers = aSN1Set;
    }

    public DigestAlgorithmIdentifiers(DigestAlgorithmIdentifiers digestAlgorithmIdentifiers) {
        this.identifiers = digestAlgorithmIdentifiers.identifiers;
    }

    public static DigestAlgorithmIdentifiers getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DigestAlgorithmIdentifiers.getInstance(ASN1Set.getInstance(aSN1TaggedObject, bl));
    }

    public static DigestAlgorithmIdentifiers getInstance(Object object) {
        if (object == null || object instanceof DigestAlgorithmIdentifiers) {
            return (DigestAlgorithmIdentifiers)object;
        }
        if (object instanceof ASN1Set) {
            return new DigestAlgorithmIdentifiers((ASN1Set)object);
        }
        throw new IllegalArgumentException("Invalid DigestAlgorithmIdentifiers: " + object.getClass().getName());
    }

    public Vector getIdentifiers() {
        int n = this.identifiers.getSize();
        Vector<DigestAlgorithmIdentifier> vector = new Vector<DigestAlgorithmIdentifier>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(DigestAlgorithmIdentifier.getInstance(this.identifiers.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    public DERObject getDERObject() {
        return this.identifiers;
    }

    private void setIdentifiers(Vector vector) {
        int n = vector.size();
        this.identifiers = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.identifiers.addObject(DigestAlgorithmIdentifier.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }
}

