/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.SignerInfo;

public class CounterSignatureAttribute
extends Attribute {
    protected CounterSignatureAttribute() {
        this.attrType = CMSObjectIdentifiers.id_countersignature;
    }

    public CounterSignatureAttribute(ASN1Sequence aSN1Sequence) {
        super(aSN1Sequence);
        this.attrType = CMSObjectIdentifiers.id_countersignature;
    }

    public CounterSignatureAttribute(Attribute attribute) {
        this();
        this.attrValues = attribute.attrValues;
    }

    public CounterSignatureAttribute(CounterSignatureAttribute counterSignatureAttribute) {
        this();
        this.attrValues = counterSignatureAttribute.attrValues;
    }

    public CounterSignatureAttribute(SignerInfo signerInfo) {
        this();
        this.addSigner(signerInfo);
    }

    public static Attribute getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CounterSignatureAttribute.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static Attribute getInstance(Object object) {
        if (object == null || object instanceof CounterSignatureAttribute) {
            return (CounterSignatureAttribute)object;
        }
        if (object instanceof Attribute) {
            return new CounterSignatureAttribute((Attribute)object);
        }
        if (object instanceof ASN1Sequence) {
            return new CounterSignatureAttribute((ASN1Sequence)object);
        }
        return new CounterSignatureAttribute(SignerInfo.getInstance(object));
    }

    public void addSigner(SignerInfo signerInfo) {
        if (this.attrValues == null) {
            this.attrValues = new DERConstructedSet();
        }
        this.attrValues.addObject(signerInfo);
    }

    public Vector getSigners() {
        Vector<SignerInfo> vector = new Vector<SignerInfo>();
        int n = this.attrValues.getSize();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(SignerInfo.getInstance(this.attrValues.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }
}

