/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecurityUtil;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class KeyFactory {
    private KeyFactorySpi keyFacSpi;
    private Provider provider;
    private String algorithm;

    protected KeyFactory(KeyFactorySpi keyFactorySpi, Provider provider, String string) {
        this.keyFacSpi = keyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePrivate(keySpec);
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGeneratePublic(keySpec);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static KeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        try {
            SecurityUtil.Implementation implementation = SecurityUtil.getImplementation("KeyFactory", string, null);
            if (implementation != null) {
                return new KeyFactory((KeyFactorySpi)implementation.getEngine(), implementation.getProvider(), string);
            }
            throw new NoSuchAlgorithmException("can't find algorithm " + string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
    }

    public static KeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtil.Implementation implementation = SecurityUtil.getImplementation("KeyFactory", string, null);
        if (implementation != null) {
            return new KeyFactory((KeyFactorySpi)implementation.getEngine(), implementation.getProvider(), string);
        }
        throw new NoSuchAlgorithmException("can't find algorithm " + string);
    }

    public final KeySpec getKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        return this.keyFacSpi.engineGetKeySpec(key, clazz);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final Key translateKey(Key key) throws InvalidKeyException {
        return this.keyFacSpi.engineTranslateKey(key);
    }
}

