/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class DefaultTableColumnModelExt
extends DefaultTableColumnModel
implements TableColumnModelExt {
    private static final String IGNORE_EVENT = "TableColumnModelExt.ignoreEvent";
    private List allColumns = new ArrayList();
    private Set invisibleColumns = new HashSet();
    private Map oldIndexes = new HashMap();
    private VisibilityListener visibilityListener = new VisibilityListener();

    public List getColumns(boolean bl) {
        if (bl) {
            return new ArrayList(this.allColumns);
        }
        return Collections.list(this.getColumns());
    }

    public int getColumnCount(boolean bl) {
        if (bl) {
            return this.allColumns.size();
        }
        return this.getColumnCount();
    }

    public TableColumnExt getColumnExt(Object object) {
        for (TableColumn tableColumn : this.allColumns) {
            if (!(tableColumn instanceof TableColumnExt) || !object.equals(tableColumn.getIdentifier())) continue;
            return (TableColumnExt)tableColumn;
        }
        return null;
    }

    public Set getInvisibleColumns() {
        return new HashSet(this.invisibleColumns);
    }

    public boolean isRemovedToInvisibleEvent(int n) {
        Integer n2 = new Integer(n);
        return this.oldIndexes.containsValue(n2);
    }

    public boolean isAddedFromInvisibleEvent(int n) {
        if (!(this.getColumn(n) instanceof TableColumnExt)) {
            return false;
        }
        return Boolean.TRUE.equals(((TableColumnExt)this.getColumn(n)).getClientProperty(IGNORE_EVENT));
    }

    public void removeColumn(TableColumn tableColumn) {
        if (tableColumn instanceof TableColumnExt) {
            ((TableColumnExt)tableColumn).removePropertyChangeListener(this.visibilityListener);
        }
        this.invisibleColumns.remove(tableColumn);
        this.allColumns.remove(tableColumn);
        super.removeColumn(tableColumn);
    }

    public void addColumn(TableColumn tableColumn) {
        boolean bl = true;
        if (tableColumn instanceof TableColumnExt) {
            TableColumnExt tableColumnExt = (TableColumnExt)tableColumn;
            bl = tableColumnExt.isVisible();
            tableColumnExt.setVisible(true);
            tableColumnExt.addPropertyChangeListener(this.visibilityListener);
        }
        this.allColumns.add(tableColumn);
        super.addColumn(tableColumn);
        if (tableColumn instanceof TableColumnExt) {
            ((TableColumnExt)tableColumn).setVisible(bl);
        }
    }

    protected void moveToInvisible(TableColumnExt tableColumnExt) {
        int n = this.tableColumns.indexOf(tableColumnExt);
        this.invisibleColumns.add(tableColumnExt);
        this.oldIndexes.put(tableColumnExt, new Integer(n));
        super.removeColumn(tableColumnExt);
    }

    protected void moveToVisible(TableColumnExt tableColumnExt) {
        this.invisibleColumns.remove(tableColumnExt);
        Integer n = (Integer)this.oldIndexes.get(tableColumnExt);
        int n2 = n == null ? this.getColumnCount() : n.intValue();
        this.oldIndexes.remove(tableColumnExt);
        tableColumnExt.putClientProperty(IGNORE_EVENT, Boolean.TRUE);
        super.addColumn(tableColumnExt);
        this.moveColumn(this.getColumnCount() - 1, Math.min(this.getColumnCount() - 1, n2));
        tableColumnExt.putClientProperty(IGNORE_EVENT, null);
    }

    private final class VisibilityListener
    implements PropertyChangeListener {
        private VisibilityListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("visible")) {
                boolean bl = (Boolean)propertyChangeEvent.getOldValue();
                boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                TableColumnExt tableColumnExt = (TableColumnExt)propertyChangeEvent.getSource();
                if (bl && !bl2) {
                    DefaultTableColumnModelExt.this.moveToInvisible(tableColumnExt);
                } else if (!bl && bl2) {
                    DefaultTableColumnModelExt.this.moveToVisible(tableColumnExt);
                }
            }
        }
    }
}

