/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.plaf.TitledPanelUI;

public abstract class BasicTitledPanelUI
extends TitledPanelUI {
    private static final Logger LOG = Logger.getLogger(BasicTitledPanelUI.class.getName());
    private JLabel caption;
    private JGradientPanel topPanel;
    private PropertyChangeListener titleChangeListener;
    protected JXTitledPanel titledPanel;
    private JComponent left;
    private JComponent right;

    public void installUI(JComponent jComponent) {
        assert (jComponent instanceof JXTitledPanel);
        this.titledPanel = (JXTitledPanel)jComponent;
        this.installProperty(this.titledPanel, "titleForeground", UIManager.getColor("JXTitledPanel.title.foreground"));
        this.installProperty(this.titledPanel, "titleDarkBackground", UIManager.getColor("JXTitledPanel.title.darkBackground"));
        this.installProperty(this.titledPanel, "titleLightBackground", UIManager.getColor("JXTitledPanel.title.lightBackground"));
        this.installProperty(this.titledPanel, "titleFont", UIManager.getFont("JXTitledPanel.title.font"));
        this.caption = this.createAndConfigureCaption(this.titledPanel);
        this.topPanel = this.createAndConfigureTopPanel(this.titledPanel);
        this.fillTopPanel();
        this.titledPanel.setLayout(new BorderLayout());
        this.titledPanel.add((Component)this.topPanel, "North");
        this.titledPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.titledPanel.setOpaque(false);
        this.installListeners();
    }

    private void fillTopPanel() {
        this.topPanel.add((Component)this.caption, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 12, 4, 12), 0, 0));
        if (this.titledPanel.getClientProperty("JXTitledPanel.rightDecoration") instanceof JComponent) {
            this.addRightDecoration((JComponent)this.titledPanel.getClientProperty("JXTitledPanel.rightDecoration"));
        }
        if (this.titledPanel.getClientProperty("JXTitledPanel.leftDecoration") instanceof JComponent) {
            this.addLeftDecoration((JComponent)this.titledPanel.getClientProperty("JXTitledPanel.leftDecoration"));
        }
    }

    private JGradientPanel createAndConfigureTopPanel(JXTitledPanel jXTitledPanel) {
        JGradientPanel jGradientPanel = this.createTopPanel(jXTitledPanel);
        jGradientPanel.setBorder(BorderFactory.createEmptyBorder());
        jGradientPanel.setLayout(new GridBagLayout());
        return jGradientPanel;
    }

    private JLabel createAndConfigureCaption(JXTitledPanel jXTitledPanel) {
        JLabel jLabel = new JLabel(jXTitledPanel.getTitle());
        jLabel.setFont(jXTitledPanel.getTitleFont());
        jLabel.setForeground(jXTitledPanel.getTitleForeground());
        return jLabel;
    }

    public void uninstallUI(JComponent jComponent) {
        assert (jComponent instanceof JXTitledPanel);
        this.uninstallListeners(this.titledPanel);
        this.topPanel.removeAll();
        this.titledPanel.remove(this.topPanel);
        this.titledPanel.putClientProperty("JXTitledPanel.leftDecoration", this.left);
        this.titledPanel.putClientProperty("JXTitledPanel.rightDecoration", this.right);
        this.caption = null;
        this.topPanel = null;
        this.titledPanel = null;
        this.left = null;
        this.right = null;
    }

    protected void installListeners() {
        this.titleChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("title")) {
                    BasicTitledPanelUI.this.caption.setText((String)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getPropertyName().equals("titleForeground")) {
                    BasicTitledPanelUI.this.caption.setForeground((Color)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getPropertyName().equals("titleFont")) {
                    BasicTitledPanelUI.this.caption.setFont((Font)propertyChangeEvent.getNewValue());
                } else if ("titleDarkBackground".equals(propertyChangeEvent.getPropertyName())) {
                    BasicTitledPanelUI.this.topPanel.revalidateGradient();
                } else if ("titleLightBackground".equals(propertyChangeEvent.getPropertyName())) {
                    BasicTitledPanelUI.this.topPanel.revalidateGradient();
                }
            }
        };
        this.titledPanel.addPropertyChangeListener(this.titleChangeListener);
    }

    protected void uninstallListeners(JXTitledPanel jXTitledPanel) {
        this.titledPanel.removePropertyChangeListener(this.titleChangeListener);
    }

    protected void installProperty(JComponent jComponent, String string, Object object) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(jComponent.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                Method method;
                Object object2;
                if (!propertyDescriptor.getName().equals(string) || (object2 = (method = propertyDescriptor.getReadMethod()).invoke((Object)jComponent, new Object[0])) != null && !(object2 instanceof UIResource)) continue;
                method = propertyDescriptor.getWriteMethod();
                method.invoke((Object)jComponent, object);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "Failed to install property " + string, exception);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
    }

    public void addRightDecoration(JComponent jComponent) {
        if (this.right != null) {
            this.topPanel.remove(this.right);
        }
        this.right = jComponent;
        if (this.right != null) {
            this.topPanel.add((Component)jComponent, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void addLeftDecoration(JComponent jComponent) {
        if (this.left != null) {
            this.topPanel.remove(this.left);
        }
        this.left = jComponent;
        if (this.left != null) {
            this.topPanel.add((Component)this.left, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public Container getTitleBar() {
        return this.topPanel;
    }

    protected JGradientPanel createTopPanel(JXTitledPanel jXTitledPanel) {
        return new JGradientPanel(jXTitledPanel);
    }

    protected static class JGradientPanel
    extends JXPanel {
        private GradientPaint gp;
        private double oldWidth = -1.0;
        private double oldHeight = -1.0;
        private ImageIcon helper = new ImageIcon();
        private JXTitledPanel titledPanel;

        public JGradientPanel(JXTitledPanel jXTitledPanel) {
            this.titledPanel = jXTitledPanel;
        }

        public void invalidateGradient() {
            this.gp = null;
        }

        public void revalidateGradient() {
            this.invalidateGradient();
            this.repaint();
        }

        protected void paintComponent(Graphics graphics) {
            if (this.gp == null || this.oldWidth != (double)this.getWidth() || this.oldHeight != (double)this.getHeight()) {
                this.gp = this.createGradientPaint();
                Image image = this.createImage(this.getWidth(), this.getHeight());
                Graphics2D graphics2D = (Graphics2D)image.getGraphics();
                graphics2D.setPaint(this.gp);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.oldWidth = this.getWidth();
                this.oldHeight = this.getHeight();
                this.helper.setImage(image);
            }
            graphics.drawImage(this.helper.getImage(), 0, 0, this.getWidth(), this.getHeight(), this.helper.getImageObserver());
        }

        protected GradientPaint createGradientPaint() {
            return new GradientPaint(0.0f, 0.0f, this.titledPanel.getTitleDarkBackground(), this.getWidth(), 0.0f, this.titledPanel.getTitleLightBackground());
        }
    }
}

