/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.plaf.ContextMenuSource;
import org.jdesktop.swingx.plaf.TextContextMenuSource;

public class ContextMenuHandler
extends MouseAdapter {
    private ActionMap actionMap;
    private ContextMenuSource contextMenuSource;
    private JPopupMenu popup;

    public ContextMenuHandler() {
        this(null);
    }

    public ContextMenuHandler(ContextMenuSource contextMenuSource) {
        this.contextMenuSource = contextMenuSource;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowContext(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowContext(mouseEvent);
    }

    private void maybeShowContext(final MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() || !mouseEvent.getComponent().isEnabled()) {
            return;
        }
        if (mouseEvent.getComponent().hasFocus()) {
            this.showContextPopup(mouseEvent);
        } else {
            ((JComponent)mouseEvent.getComponent()).grabFocus();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ContextMenuHandler.this.showContextPopup(mouseEvent);
                }
            });
        }
    }

    private void showContextPopup(MouseEvent mouseEvent) {
        this.showContextPopup((JComponent)mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void showContextPopup(JComponent jComponent, int n, int n2) {
        JPopupMenu jPopupMenu = this.getPopupMenu(jComponent, true);
        jPopupMenu.show(jComponent, n, n2);
    }

    private JPopupMenu getPopupMenu(JComponent jComponent, boolean bl) {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            ActionMap actionMap = this.getActionMap(jComponent);
            String[] stringArray = this.getContextMenuSource().getKeys();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) {
                    this.popup.add(actionMap.get(stringArray[i]));
                    continue;
                }
                this.popup.addSeparator();
            }
        }
        if (bl) {
            this.getContextMenuSource().updateActionEnabled(jComponent, this.actionMap);
        }
        return this.popup;
    }

    private ActionMap getActionMap(JComponent jComponent) {
        if (this.actionMap == null) {
            this.actionMap = this.getContextMenuSource().createActionMap(jComponent);
        }
        return this.actionMap;
    }

    private ContextMenuSource getContextMenuSource() {
        if (this.contextMenuSource == null) {
            this.contextMenuSource = new TextContextMenuSource();
        }
        return this.contextMenuSource;
    }
}

