/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.awt.Component;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;

public abstract class ConditionalHighlighter
extends Highlighter {
    protected int testColumn = 0;
    protected int highlightColumn = -1;
    protected int mask = 255;

    public ConditionalHighlighter() {
    }

    public ConditionalHighlighter(Color color, Color color2, int n, int n2) {
        super(color, color2);
        this.testColumn = n;
        this.highlightColumn = n2;
    }

    public void setMask(int n) {
        this.mask = n;
        this.fireStateChanged();
    }

    public int getMask() {
        return this.mask;
    }

    public Component highlight(Component component, ComponentAdapter componentAdapter) {
        if (this.needsHighlight(componentAdapter)) {
            return this.doHighlight(component, componentAdapter);
        }
        if (this.getMask() < 256) {
            return this.doMask(component, componentAdapter);
        }
        return component;
    }

    protected Component doMask(Component component, ComponentAdapter componentAdapter) {
        this.maskBackground(component, componentAdapter);
        this.maskForeground(component, componentAdapter);
        return component;
    }

    protected void maskBackground(Component component, ComponentAdapter componentAdapter) {
        Color color;
        Color color2 = component.getBackground();
        Color color3 = color = componentAdapter.isSelected() ? this.computeSelectedBackground(color2) : color2;
        if (color != null) {
            component.setBackground(new Color(this.getMask() << 24 | color.getRGB() & 0xFFFFFF, true));
        }
    }

    protected void maskForeground(Component component, ComponentAdapter componentAdapter) {
        Color color;
        Color color2 = component.getForeground();
        Color color3 = color = componentAdapter.isSelected() ? this.computeSelectedForeground(color2) : color2;
        if (color != null) {
            component.setForeground(new Color(this.getMask() << 24 | color.getRGB() & 0xFFFFFF, true));
        }
    }

    protected Color computeBackground(Component component, ComponentAdapter componentAdapter) {
        return this.getBackground() == null ? null : super.computeBackground(component, componentAdapter);
    }

    protected Color computeForeground(Component component, ComponentAdapter componentAdapter) {
        return this.getForeground() == null ? null : super.computeForeground(component, componentAdapter);
    }

    protected Color computeSelectedForeground(Color color) {
        return this.getSelectedForeground() == null ? (color == null ? null : color.brighter()) : this.getSelectedForeground();
    }

    public int getTestColumnIndex() {
        return this.testColumn;
    }

    public void setTestColumnIndex(int n) {
        this.testColumn = n;
        this.fireStateChanged();
    }

    public int getHighlightColumnIndex() {
        return this.highlightColumn;
    }

    public void setHighlightColumnIndex(int n) {
        this.highlightColumn = n;
        this.fireStateChanged();
    }

    protected boolean needsHighlight(ComponentAdapter componentAdapter) {
        if (this.highlightColumn < 0 || this.highlightColumn == componentAdapter.viewToModel(componentAdapter.column)) {
            return this.test(componentAdapter);
        }
        return false;
    }

    protected abstract boolean test(ComponentAdapter var1);
}

