/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.UIManager;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;

public class AlternateRowHighlighter
extends Highlighter {
    private static final Color defaultOddRowColor = Color.white;
    private static final Color defaultEvenRowColor = new Color(240, 240, 224);
    public static final Highlighter beige = new AlternateRowHighlighter(Color.white, new Color(245, 245, 220), null, true);
    public static final Highlighter linePrinter = new AlternateRowHighlighter(Color.white, new Color(204, 204, 255), null, true);
    public static final Highlighter classicLinePrinter = new AlternateRowHighlighter(Color.white, new Color(204, 255, 204), null, true);
    public static final Highlighter floralWhite = new AlternateRowHighlighter(Color.white, new Color(255, 250, 240), null, true);
    public static final Highlighter quickSilver = new AlternateRowHighlighter(Color.white, defaultEvenRowColor, null, true);
    public static final AlternateRowHighlighter genericGrey = new AlternateRowHighlighter(Color.white, new Color(229, 229, 229), null, true);
    private Color oddRowBackground = defaultOddRowColor;
    private Color evenRowBackground = defaultEvenRowColor;

    public AlternateRowHighlighter() {
    }

    public AlternateRowHighlighter(Color color, Color color2, Color color3) {
        this(color, color2, color3, false);
    }

    public AlternateRowHighlighter(Color color, Color color2, Color color3, boolean bl) {
        super(color, color3, bl);
        this.oddRowBackground = color;
        this.evenRowBackground = color2;
    }

    public Color getOddRowBackground() {
        return this.oddRowBackground;
    }

    public void setOddRowBackground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.oddRowBackground = color;
        this.fireStateChanged();
    }

    public Color getEvenRowBackground() {
        return this.evenRowBackground;
    }

    public void setEvenRowBackground(Color color) {
        if (this.isImmutable()) {
            return;
        }
        this.evenRowBackground = color;
        this.fireStateChanged();
    }

    protected Color computeBackground(Component component, ComponentAdapter componentAdapter) {
        Color color;
        Color color2 = color = componentAdapter.row % 2 == 0 ? this.oddRowBackground : this.evenRowBackground;
        if (color != null && componentAdapter.isSelected()) {
            color = this.computeSelectedBackground(color);
        }
        return color;
    }

    protected Color computeSelectedBackground(Color color) {
        return this.getSelectedBackground();
    }

    protected Color computeSelectedForeground(Color color) {
        return this.getSelectedForeground();
    }

    public static class UIAlternateRowHighlighter
    extends AlternateRowHighlighter
    implements Highlighter.UIHighlighter {
        private HashMap<Color, Color> colorMap;

        public UIAlternateRowHighlighter() {
            super(Color.WHITE, null, null);
            this.initColorMap();
            this.updateUI();
        }

        public void updateUI() {
            Color color = UIManager.getColor("Table.selectionBackground");
            Color color2 = this.getMappedColor(color);
            this.setEvenRowBackground(color2);
        }

        private Color getMappedColor(Color color) {
            Color color2 = this.colorMap.get(color);
            if (color2 == null) {
                color2 = genericGrey.getEvenRowBackground();
            }
            return color2;
        }

        private void initColorMap() {
            this.colorMap = new HashMap();
            this.colorMap.put(new Color(184, 207, 229), new Color(230, 238, 246));
            this.colorMap.put(new Color(49, 106, 197), new Color(224, 233, 246));
            this.colorMap.put(new Color(178, 180, 191), new Color(235, 235, 236));
            this.colorMap.put(new Color(147, 160, 112), new Color(228, 231, 219));
            this.colorMap.put(new Color(10, 36, 106), new Color(218, 222, 233));
            this.colorMap.put(new Color(0, 0, 128), new Color(218, 222, 233));
            this.colorMap.put(new Color(205, 205, 255), new Color(235, 235, 255));
            this.colorMap.put(new Color(56, 117, 215), new Color(237, 243, 254));
        }
    }
}

