/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.EventHandler;
import java.beans.Statement;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.action.AbstractActionExt;

public class BoundAction
extends AbstractActionExt {
    private static final Logger LOG = Logger.getLogger(BoundAction.class.getName());
    private EventListenerList listeners;

    public BoundAction() {
        this("BoundAction");
    }

    public BoundAction(String string) {
        super(string);
    }

    public BoundAction(String string, String string2) {
        super(string, string2);
    }

    public BoundAction(String string, Icon icon) {
        super(string, icon);
    }

    public BoundAction(String string, String string2, Icon icon) {
        super(string, string2, icon);
    }

    public void setCallback(String string) {
        String[] stringArray = string.split("#", 2);
        if (stringArray.length == 2) {
            try {
                Class<?> clazz = Class.forName(stringArray[0]);
                Object obj = clazz.newInstance();
                this.registerCallback(obj, stringArray[1]);
            }
            catch (Exception exception) {
                LOG.fine("ERROR: setCallback(" + string + ") - " + exception.getMessage());
            }
        }
    }

    public void registerCallback(Object object, String string) {
        if (this.isStateAction()) {
            this.addItemListener(new BooleanInvocationHandler(object, string));
        } else {
            this.addActionListener(EventHandler.create(ActionListener.class, object, string));
        }
    }

    private void addListener(Class clazz, EventListener eventListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(clazz, eventListener);
    }

    private void removeListener(Class clazz, EventListener eventListener) {
        if (this.listeners != null) {
            this.listeners.remove(clazz, eventListener);
        }
    }

    private EventListener[] getListeners(Class clazz) {
        if (this.listeners == null) {
            return null;
        }
        return this.listeners.getListeners(clazz);
    }

    public void addActionListener(ActionListener actionListener) {
        this.addListener(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.removeListener(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    public void addItemListener(ItemListener itemListener) {
        this.addListener(ItemListener.class, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.removeListener(ItemListener.class, itemListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ActionListener[] actionListenerArray = this.getActionListeners();
        if (actionListenerArray != null) {
            for (int i = 0; i < actionListenerArray.length; ++i) {
                actionListenerArray[i].actionPerformed(actionEvent);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        boolean bl2 = this.isSelected();
        if (bl2 != (bl = itemEvent.getStateChange() == 1)) {
            this.setSelected(bl);
            ItemListener[] itemListenerArray = this.getItemListeners();
            if (itemListenerArray != null) {
                for (int i = 0; i < itemListenerArray.length; ++i) {
                    itemListenerArray[i].itemStateChanged(itemEvent);
                }
            }
        }
    }

    private class BooleanInvocationHandler
    implements ItemListener {
        private Statement falseStatement;
        private Statement trueStatement;

        public BooleanInvocationHandler(Object object, String string) {
            this.falseStatement = new Statement(object, string, new Object[]{Boolean.FALSE});
            this.trueStatement = new Statement(object, string, new Object[]{Boolean.TRUE});
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Statement statement = itemEvent.getStateChange() == 2 ? this.falseStatement : this.trueStatement;
            try {
                statement.execute();
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Couldn't execute boolean method via Statement " + statement, exception);
            }
        }
    }
}

