/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.ErrorReporter;
import org.jdesktop.swingx.IncidentInfo;
import org.jdesktop.swingx.util.MailTransportProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailErrorReporter
extends ErrorReporter {
    private String mailAddr;
    private List<String> toList = new ArrayList<String>();
    private MailTransportProxy mailTransportProxy;

    public MailErrorReporter(String string) {
        this.mailAddr = string;
        this.toList.add(this.mailAddr);
    }

    public String getMailAddr() {
        return this.mailAddr;
    }

    public void setMailAddr(String string) {
        this.toList.remove(this.mailAddr);
        this.mailAddr = string;
        this.toList.add(this.mailAddr);
    }

    public void setMailTransportProxy(MailTransportProxy mailTransportProxy) {
        this.mailTransportProxy = mailTransportProxy;
    }

    @Override
    public void reportIncident(IncidentInfo incidentInfo) {
        if (this.mailTransportProxy != null) {
            try {
                this.mailTransportProxy.mailMessage(this.toList, null, incidentInfo.getHeader(), this.getMessageBody(incidentInfo), this.getAttachments(incidentInfo));
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    public String getMessageBody(IncidentInfo incidentInfo) {
        String string = incidentInfo.getBasicErrorMessage();
        if (incidentInfo.getDetailedErrorMessage() != null) {
            string.concat("\n" + incidentInfo.getDetailedErrorMessage());
        }
        if (incidentInfo.getErrorException() != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            incidentInfo.getErrorException().printStackTrace(printWriter);
            string = string + "\n ----- " + stringWriter.toString();
        }
        return string;
    }

    public List<String> getAttachments(IncidentInfo incidentInfo) {
        return null;
    }
}

