/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.HeadlessException;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.plaf.JXTipOfTheDayAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.TipOfTheDayUI;
import org.jdesktop.swingx.tips.DefaultTipOfTheDayModel;
import org.jdesktop.swingx.tips.TipOfTheDayModel;

public class JXTipOfTheDay
extends JXPanel {
    public static final String uiClassID = "swingx/TipOfTheDayUI";
    public static final String PREFERENCE_KEY = "ShowTipOnStartup";
    public static final String CURRENT_TIP_CHANGED_KEY = "currentTip";
    private TipOfTheDayModel model;
    private int currentTip = 0;

    public JXTipOfTheDay() {
        this(new DefaultTipOfTheDayModel(new TipOfTheDayModel.Tip[0]));
    }

    public JXTipOfTheDay(TipOfTheDayModel tipOfTheDayModel) {
        this.model = tipOfTheDayModel;
        this.updateUI();
    }

    public void updateUI() {
        this.setUI((TipOfTheDayUI)LookAndFeelAddons.getUI(this, TipOfTheDayUI.class));
    }

    public void setUI(TipOfTheDayUI tipOfTheDayUI) {
        super.setUI(tipOfTheDayUI);
    }

    public TipOfTheDayUI getUI() {
        return (TipOfTheDayUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public TipOfTheDayModel getModel() {
        return this.model;
    }

    public void setModel(TipOfTheDayModel tipOfTheDayModel) {
        if (tipOfTheDayModel == null) {
            throw new IllegalArgumentException("model can not be null");
        }
        TipOfTheDayModel tipOfTheDayModel2 = this.model;
        this.model = tipOfTheDayModel;
        this.firePropertyChange("model", tipOfTheDayModel2, tipOfTheDayModel);
    }

    public int getCurrentTip() {
        return this.currentTip;
    }

    public void setCurrentTip(int n) {
        if (n < 0 || n >= this.getModel().getTipCount()) {
            throw new IllegalArgumentException("Current tip must be within the bounds [0, " + this.getModel().getTipCount() + "[");
        }
        int n2 = this.currentTip;
        this.currentTip = n;
        this.firePropertyChange(CURRENT_TIP_CHANGED_KEY, n2, n);
    }

    public void nextTip() {
        int n = this.getModel().getTipCount();
        if (n == 0) {
            return;
        }
        int n2 = this.currentTip + 1;
        if (n2 >= n) {
            n2 = 0;
        }
        this.setCurrentTip(n2);
    }

    public void previousTip() {
        int n = this.getModel().getTipCount();
        if (n == 0) {
            return;
        }
        int n2 = this.currentTip - 1;
        if (n2 < 0) {
            n2 = n - 1;
        }
        this.setCurrentTip(n2);
    }

    public void showDialog(Component component) throws HeadlessException {
        this.showDialog(component, (ShowOnStartupChoice)null);
    }

    public boolean showDialog(Component component, Preferences preferences) throws HeadlessException {
        return this.showDialog(component, preferences, false);
    }

    public boolean showDialog(Component component, final Preferences preferences, boolean bl) throws HeadlessException {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences can not be null");
        }
        ShowOnStartupChoice showOnStartupChoice = new ShowOnStartupChoice(){

            public boolean isShowingOnStartup() {
                return preferences.getBoolean(JXTipOfTheDay.PREFERENCE_KEY, true);
            }

            public void setShowingOnStartup(boolean bl) {
                if (!bl) {
                    preferences.putBoolean(JXTipOfTheDay.PREFERENCE_KEY, bl);
                }
            }
        };
        return this.showDialog(component, showOnStartupChoice, bl);
    }

    public boolean showDialog(Component component, ShowOnStartupChoice showOnStartupChoice) {
        return this.showDialog(component, showOnStartupChoice, false);
    }

    public boolean showDialog(Component component, ShowOnStartupChoice showOnStartupChoice, boolean bl) {
        if (showOnStartupChoice == null) {
            JDialog jDialog = this.createDialog(component, showOnStartupChoice);
            jDialog.setVisible(true);
            jDialog.dispose();
            return true;
        }
        if (bl || showOnStartupChoice.isShowingOnStartup()) {
            JDialog jDialog = this.createDialog(component, showOnStartupChoice);
            jDialog.setVisible(true);
            jDialog.dispose();
            return showOnStartupChoice.isShowingOnStartup();
        }
        return false;
    }

    public static boolean isShowingOnStartup(Preferences preferences) {
        return preferences.getBoolean(PREFERENCE_KEY, true);
    }

    public static void forceShowOnStartup(Preferences preferences) {
        preferences.remove(PREFERENCE_KEY);
    }

    protected JDialog createDialog(Component component, ShowOnStartupChoice showOnStartupChoice) {
        return this.getUI().createDialog(component, showOnStartupChoice);
    }

    static {
        LookAndFeelAddons.contribute(new JXTipOfTheDayAddon());
    }

    public static interface ShowOnStartupChoice {
        public void setShowingOnStartup(boolean var1);

        public boolean isShowingOnStartup();
    }
}

