/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JXRadioGroup
extends JPanel {
    private static final long serialVersionUID = 3257285842266567986L;
    private ButtonGroup buttonGroup;
    private List<Object> values = new ArrayList<Object>();
    private ActionSelectionListener actionHandler;
    private List<ActionListener> actionListeners;
    private int gapWidth;

    public JXRadioGroup() {
        this(0);
    }

    public JXRadioGroup(int n) {
        this.setLayout(new BoxLayout(this, 0));
        this.buttonGroup = new ButtonGroup();
        this.gapWidth = n;
    }

    public JXRadioGroup(Object[] objectArray) {
        this();
        for (int i = 0; i < objectArray.length; ++i) {
            this.add(objectArray[i]);
        }
    }

    public void setValues(Object[] objectArray) {
        this.clearAll();
        for (int i = 0; i < objectArray.length; ++i) {
            this.add(objectArray[i]);
        }
    }

    private void clearAll() {
        this.values.clear();
        this.removeAll();
        this.buttonGroup = new ButtonGroup();
    }

    public void add(Object object) {
        this.values.add(object);
        this.addButton(new JRadioButton(object.toString()));
    }

    public void add(AbstractButton abstractButton) {
        this.values.add(abstractButton.getText());
        this.addButton(abstractButton);
    }

    private void addButton(AbstractButton abstractButton) {
        this.buttonGroup.add(abstractButton);
        super.add(abstractButton);
        if (this.actionHandler == null) {
            this.actionHandler = new ActionSelectionListener();
        }
        abstractButton.addActionListener(this.actionHandler);
        abstractButton.addItemListener(this.actionHandler);
    }

    private void checkGap() {
        if (this.getGapWidth() > 0 && this.getComponentCount() > 0) {
            this.add(Box.createHorizontalStrut(this.getGapWidth()));
        }
    }

    private int getGapWidth() {
        return this.gapWidth;
    }

    public AbstractButton getSelectedButton() {
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        AbstractButton[] abstractButtonArray = this.getButtonComponents();
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            AbstractButton abstractButton = abstractButtonArray[i];
            if (abstractButton.getModel() != buttonModel) continue;
            return abstractButton;
        }
        return null;
    }

    private AbstractButton[] getButtonComponents() {
        Component[] componentArray = this.getComponents();
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AbstractButton)) continue;
            arrayList.add(componentArray[i]);
        }
        return arrayList.toArray(new AbstractButton[arrayList.size()]);
    }

    private int getSelectedIndex() {
        ButtonModel buttonModel = this.buttonGroup.getSelection();
        AbstractButton[] abstractButtonArray = this.getButtonComponents();
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            AbstractButton abstractButton = abstractButtonArray[i];
            if (abstractButton.getModel() != buttonModel) continue;
            return i;
        }
        return -1;
    }

    public Object getSelectedValue() {
        int n = this.getSelectedIndex();
        return n < 0 || n >= this.values.size() ? null : this.values.get(n);
    }

    public void setSelectedValue(Object object) {
        int n = this.values.indexOf(object);
        AbstractButton abstractButton = this.getButtonComponents()[n];
        abstractButton.setSelected(true);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>();
        }
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(actionListener);
        }
    }

    public ActionListener[] getActionListeners() {
        if (this.actionListeners != null) {
            return this.actionListeners.toArray(new ActionListener[0]);
        }
        return new ActionListener[0];
    }

    protected void fireActionEvent(ActionEvent actionEvent) {
        if (this.actionListeners != null) {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ActionListener actionListener = this.actionListeners.get(i);
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    private class ActionSelectionListener
    implements ActionListener,
    ItemListener {
        private ActionSelectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JXRadioGroup.this.fireActionEvent(actionEvent);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JXRadioGroup.this.fireActionEvent(null);
        }
    }
}

