/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import apple.laf.JRSUIUtils;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class AquaTreeUI
extends BasicTreeUI {
    private static final String LINE_STYLE = "JTree.lineStyle";
    private static final String LEG_LINE_STYLE_STRING = "Angled";
    private static final String HORIZ_STYLE_STRING = "Horizontal";
    private static final String NO_STYLE_STRING = "None";
    private static final int LEG_LINE_STYLE = 2;
    private static final int HORIZ_LINE_STYLE = 1;
    private static final int NO_LINE_STYLE = 0;
    private int lineStyle = 1;
    private final PropertyChangeListener lineStyleListener = new LineListener();
    protected TreePath fTrackingPath;
    protected boolean fIsPressed = false;
    protected boolean fIsInBounds = false;
    protected int fAnimationFrame = -1;
    protected TreeArrowMouseInputHandler fMouseHandler;
    protected final AquaPainter<JRSUIState.AnimationFrameState> painter = AquaPainter.create(JRSUIStateFactory.getDisclosureTriangle());

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTreeUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        Object object = jComponent.getClientProperty(LINE_STYLE);
        this.decodeLineStyle(object);
        jComponent.addPropertyChangeListener(this.lineStyleListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.lineStyleListener);
        super.uninstallUI(jComponent);
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected void decodeLineStyle(Object object) {
        if (object == null || NO_STYLE_STRING.equals(object)) {
            this.lineStyle = 0;
            return;
        }
        if (LEG_LINE_STYLE_STRING.equals(object)) {
            this.lineStyle = 2;
        } else if (HORIZ_STYLE_STRING.equals(object)) {
            this.lineStyle = 1;
        }
    }

    @Override
    public TreePath getClosestPathForLocation(JTree jTree, int n, int n2) {
        if (jTree == null || this.treeState == null) {
            return null;
        }
        Insets insets = jTree.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        return this.treeState.getPathClosestTo(n - insets.left, n2 - insets.top);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (this.lineStyle == 1 && !this.largeModel) {
            this.paintHorizontalSeparators(graphics, jComponent);
        }
    }

    protected void paintHorizontalSeparators(Graphics graphics, JComponent jComponent) {
        graphics.setColor(UIManager.getColor("Tree.line"));
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y));
        int n2 = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, rectangle.y + rectangle.height - 1));
        if (n <= -1 || n2 <= -1) {
            return;
        }
        for (int i = n; i <= n2; ++i) {
            Rectangle rectangle2;
            TreePath treePath = this.getPathForRow(this.tree, i);
            if (treePath == null || treePath.getPathCount() != 2 || (rectangle2 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i))) == null) continue;
            graphics.drawLine(rectangle.x, rectangle2.y, rectangle.x + rectangle.width, rectangle2.y);
        }
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (this.lineStyle == 2) {
            super.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath);
        }
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.lineStyle == 2) {
            super.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
        }
    }

    @Override
    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        Icon icon;
        Object object = treePath.getLastPathComponent();
        if (bl3 || bl2 && this.treeModel.getChildCount(object) <= 0) {
            return;
        }
        boolean bl4 = AquaUtils.isLeftToRight(this.tree);
        JRSUIConstants.State state = this.getState(treePath);
        if (this.fAnimationFrame == -1 && state != JRSUIConstants.State.PRESSED) {
            super.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
            return;
        }
        Icon icon2 = icon = bl ? this.getExpandedIcon() : this.getCollapsedIcon();
        if (!(icon instanceof UIResource)) {
            super.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
            return;
        }
        int n2 = bl4 ? rectangle2.x - (this.getRightChildIndent() - 1) : rectangle.x + rectangle.width / 2;
        int n3 = rectangle2.y + rectangle2.height / 2;
        int n4 = n2 - icon.getIconWidth() / 2;
        int n5 = n3 - icon.getIconHeight() / 2;
        int n6 = icon.getIconHeight();
        this.setupPainter(state, bl, bl4);
        this.painter.paint(graphics, this.tree, n4, n5, 20, n6);
    }

    @Override
    public Icon getCollapsedIcon() {
        Icon icon = super.getCollapsedIcon();
        if (AquaUtils.isLeftToRight(this.tree)) {
            return icon;
        }
        if (!(icon instanceof UIResource)) {
            return icon;
        }
        return UIManager.getIcon("Tree.rightToLeftCollapsedIcon");
    }

    protected void setupPainter(JRSUIConstants.State state, boolean bl, boolean bl2) {
        if (!this.fIsInBounds && state == JRSUIConstants.State.PRESSED) {
            state = JRSUIConstants.State.ACTIVE;
        }
        ((JRSUIState.AnimationFrameState)this.painter.state).set(state);
        if (JRSUIUtils.Tree.useLegacyTreeKnobs()) {
            if (this.fAnimationFrame == -1) {
                ((JRSUIState.AnimationFrameState)this.painter.state).set(bl ? JRSUIConstants.Direction.DOWN : JRSUIConstants.Direction.RIGHT);
            } else {
                ((JRSUIState.AnimationFrameState)this.painter.state).set(JRSUIConstants.Direction.NONE);
                ((JRSUIState.AnimationFrameState)this.painter.state).setAnimationFrame(this.fAnimationFrame - 1);
            }
        } else {
            ((JRSUIState.AnimationFrameState)this.painter.state).set(this.getDirection(bl, bl2));
            ((JRSUIState.AnimationFrameState)this.painter.state).setAnimationFrame(this.fAnimationFrame);
        }
    }

    protected JRSUIConstants.Direction getDirection(boolean bl, boolean bl2) {
        if (bl && this.fAnimationFrame == -1) {
            return JRSUIConstants.Direction.DOWN;
        }
        return bl2 ? JRSUIConstants.Direction.RIGHT : JRSUIConstants.Direction.LEFT;
    }

    protected JRSUIConstants.State getState(TreePath treePath) {
        if (!this.tree.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (this.fIsPressed && this.fTrackingPath.equals(treePath)) {
            return JRSUIConstants.State.PRESSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    @Override
    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        this.fMouseHandler = new TreeArrowMouseInputHandler(treePath);
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isMetaDown();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new MacPropertyChangeHandler();
    }

    protected int getRowForPath(TreePath treePath) {
        return this.treeState.getRowForPath(treePath);
    }

    protected Rectangle getPathArrowBounds(TreePath treePath) {
        int n;
        Rectangle rectangle = this.getPathBounds(this.tree, treePath);
        Insets insets = this.tree.getInsets();
        rectangle.width = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() : 8;
        int n2 = n = insets != null ? insets.left : 0;
        n = AquaUtils.isLeftToRight(this.tree) ? (n += (treePath.getPathCount() + this.depthOffset - 2) * this.totalChildIndent + this.getLeftChildIndent() - rectangle.width / 2) : (n += this.tree.getWidth() - 1 - (treePath.getPathCount() - 2 + this.depthOffset) * this.totalChildIndent - this.getLeftChildIndent() - rectangle.width / 2);
        rectangle.x = n;
        return rectangle;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.tree.getActionMap().put("aquaExpandNode", new KeyboardExpandCollapseAction(true, false));
        this.tree.getActionMap().put("aquaCollapseNode", new KeyboardExpandCollapseAction(false, false));
        this.tree.getActionMap().put("aquaFullyExpandNode", new KeyboardExpandCollapseAction(true, true));
        this.tree.getActionMap().put("aquaFullyCollapseNode", new KeyboardExpandCollapseAction(false, true));
    }

    void expandNode(int n, boolean bl) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath == null) {
            return;
        }
        this.tree.expandPath(treePath);
        if (!bl) {
            return;
        }
        this.expandAllNodes(treePath, n + 1);
    }

    void expandAllNodes(TreePath treePath, int n) {
        int n2 = n;
        TreePath treePath2;
        while (treePath.isDescendant(treePath2 = this.getPathForRow(this.tree, n2))) {
            this.tree.expandPath(treePath2);
            ++n2;
        }
        return;
    }

    void collapseNode(int n, boolean bl) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath == null) {
            return;
        }
        if (bl) {
            this.collapseAllNodes(treePath, n + 1);
        }
        this.tree.collapsePath(treePath);
    }

    void collapseAllNodes(TreePath treePath, int n) {
        TreePath treePath2;
        int n2 = -1;
        int n3 = n;
        while (n2 == -1) {
            treePath2 = this.getPathForRow(this.tree, n3);
            if (!treePath.isDescendant(treePath2)) {
                n2 = n3 - 1;
            }
            ++n3;
        }
        for (n3 = n2; n3 >= n; --n3) {
            treePath2 = this.getPathForRow(this.tree, n3);
            this.tree.collapsePath(treePath2);
        }
    }

    class KeyboardExpandCollapseAction
    extends AbstractAction {
        final boolean expand;
        final boolean recursive;

        public KeyboardExpandCollapseAction(boolean bl, boolean bl2) {
            this.expand = bl;
            this.recursive = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AquaTreeUI.this.tree == null || 0 > AquaTreeUI.this.getRowCount(AquaTreeUI.this.tree)) {
                return;
            }
            TreePath[] treePathArray = AquaTreeUI.this.tree.getSelectionPaths();
            if (treePathArray == null) {
                return;
            }
            for (int i = treePathArray.length - 1; i >= 0; --i) {
                TreePath treePath = treePathArray[i];
                if (this.expand) {
                    AquaTreeUI.this.expandNode(AquaTreeUI.this.tree.getRowForPath(treePath), this.recursive);
                    continue;
                }
                if (treePathArray.length == 1 && AquaTreeUI.this.tree.isCollapsed(treePath)) {
                    TreePath treePath2 = treePath.getParentPath();
                    if (treePath2 == null || treePath2.getParentPath() == null && !AquaTreeUI.this.tree.isRootVisible()) continue;
                    AquaTreeUI.this.tree.scrollPathToVisible(treePath2);
                    AquaTreeUI.this.tree.setSelectionPath(treePath2);
                    continue;
                }
                AquaTreeUI.this.collapseNode(AquaTreeUI.this.tree.getRowForPath(treePath), this.recursive);
            }
        }

        @Override
        public boolean isEnabled() {
            return AquaTreeUI.this.tree != null && AquaTreeUI.this.tree.isEnabled();
        }
    }

    class TreeArrowMouseInputHandler
    extends MouseInputAdapter {
        protected Rectangle fPathBounds = new Rectangle();
        protected boolean fIsLeaf;
        protected boolean fIsExpanded;
        protected boolean fHasBeenExpanded;
        protected Rectangle fBounds;
        protected Rectangle fVisibleRect;
        int fTrackingRow;
        Insets fInsets;
        Color fBackground;

        TreeArrowMouseInputHandler(TreePath treePath) {
            Serializable serializable;
            AquaTreeUI.this.fTrackingPath = treePath;
            AquaTreeUI.this.fIsPressed = true;
            AquaTreeUI.this.fIsInBounds = true;
            this.fPathBounds = AquaTreeUI.this.getPathArrowBounds(treePath);
            AquaTreeUI.this.tree.addMouseListener(this);
            AquaTreeUI.this.tree.addMouseMotionListener(this);
            this.fBackground = AquaTreeUI.this.tree.getBackground();
            if (!AquaTreeUI.this.tree.isOpaque() && (serializable = AquaTreeUI.this.tree.getParent()) != null) {
                this.fBackground = serializable.getBackground();
            }
            this.fVisibleRect = AquaTreeUI.this.tree.getVisibleRect();
            this.fInsets = AquaTreeUI.this.tree.getInsets();
            if (this.fInsets == null) {
                this.fInsets = new Insets(0, 0, 0, 0);
            }
            this.fIsLeaf = AquaTreeUI.this.treeModel.isLeaf(treePath.getLastPathComponent());
            if (this.fIsLeaf) {
                this.fHasBeenExpanded = false;
                this.fIsExpanded = false;
            } else {
                this.fIsExpanded = AquaTreeUI.this.treeState.getExpandedState(treePath);
                this.fHasBeenExpanded = AquaTreeUI.this.tree.hasBeenExpanded(treePath);
            }
            serializable = new Rectangle();
            this.fBounds = AquaTreeUI.this.treeState.getBounds(AquaTreeUI.this.fTrackingPath, (Rectangle)serializable);
            this.fBounds.x += this.fInsets.left;
            this.fBounds.y += this.fInsets.top;
            this.fTrackingRow = AquaTreeUI.this.getRowForPath(AquaTreeUI.this.fTrackingPath);
            this.paintOneControl();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            AquaTreeUI.this.fIsInBounds = this.fPathBounds.contains(mouseEvent.getX(), mouseEvent.getY());
            this.paintOneControl();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AquaTreeUI.this.fIsInBounds = this.fPathBounds.contains(mouseEvent.getX(), mouseEvent.getY());
            this.paintOneControl();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (AquaTreeUI.this.tree == null) {
                return;
            }
            if (AquaTreeUI.this.fIsPressed) {
                boolean bl = AquaTreeUI.this.fIsInBounds;
                AquaTreeUI.this.fIsPressed = false;
                AquaTreeUI.this.fIsInBounds = false;
                if (bl) {
                    this.fIsExpanded = !this.fIsExpanded;
                    this.paintAnimation(this.fIsExpanded);
                    if (mouseEvent.isAltDown()) {
                        if (this.fIsExpanded) {
                            AquaTreeUI.this.expandNode(this.fTrackingRow, true);
                        } else {
                            AquaTreeUI.this.collapseNode(this.fTrackingRow, true);
                        }
                    } else {
                        AquaTreeUI.this.toggleExpandState(AquaTreeUI.this.fTrackingPath);
                    }
                }
            }
            AquaTreeUI.this.fTrackingPath = null;
            this.removeFromSource();
        }

        protected void paintAnimation(boolean bl) {
            if (bl) {
                this.paintAnimationFrame(1);
                this.paintAnimationFrame(2);
                this.paintAnimationFrame(3);
            } else {
                this.paintAnimationFrame(3);
                this.paintAnimationFrame(2);
                this.paintAnimationFrame(1);
            }
            AquaTreeUI.this.fAnimationFrame = -1;
        }

        protected void paintAnimationFrame(int n) {
            AquaTreeUI.this.fAnimationFrame = n;
            this.paintOneControl();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void paintOneControl() {
            if (AquaTreeUI.this.tree == null) {
                return;
            }
            Graphics graphics = AquaTreeUI.this.tree.getGraphics();
            if (graphics == null) {
                return;
            }
            try {
                graphics.setClip(this.fVisibleRect);
                graphics.setColor(this.fBackground);
                graphics.fillRect(this.fPathBounds.x, this.fPathBounds.y, this.fPathBounds.width, this.fPathBounds.height);
                if (AquaTreeUI.this.fTrackingPath == null) {
                    return;
                }
                TreePath treePath = AquaTreeUI.this.fTrackingPath.getParentPath();
                if (treePath != null) {
                    AquaTreeUI.this.paintVerticalPartOfLeg(graphics, this.fPathBounds, this.fInsets, treePath);
                    AquaTreeUI.this.paintHorizontalPartOfLeg(graphics, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
                } else if (AquaTreeUI.this.isRootVisible() && this.fTrackingRow == 0) {
                    AquaTreeUI.this.paintHorizontalPartOfLeg(graphics, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
                }
                AquaTreeUI.this.paintExpandControl(graphics, this.fPathBounds, this.fInsets, this.fBounds, AquaTreeUI.this.fTrackingPath, this.fTrackingRow, this.fIsExpanded, this.fHasBeenExpanded, this.fIsLeaf);
            }
            finally {
                graphics.dispose();
            }
        }

        protected void removeFromSource() {
            AquaTreeUI.this.tree.removeMouseListener(this);
            AquaTreeUI.this.tree.removeMouseMotionListener(this);
        }
    }

    public class MacPropertyChangeHandler
    extends BasicTreeUI.PropertyChangeHandler {
        public MacPropertyChangeHandler() {
            super(AquaTreeUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("Frame.active")) {
                AquaBorder.repaintBorder(AquaTreeUI.this.tree);
                AquaFocusHandler.swapSelectionColors("Tree", AquaTreeUI.this.tree, propertyChangeEvent.getNewValue());
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }
    }

    class FocusHandler
    extends BasicTreeUI.FocusHandler {
        FocusHandler() {
            super(AquaTreeUI.this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            AquaBorder.repaintBorder(AquaTreeUI.this.tree);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            AquaBorder.repaintBorder(AquaTreeUI.this.tree);
        }
    }

    class LineListener
    implements PropertyChangeListener {
        LineListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(AquaTreeUI.LINE_STYLE)) {
                AquaTreeUI.this.decodeLineStyle(propertyChangeEvent.getNewValue());
            }
        }
    }
}

