/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.printj2;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.krysalis.barcode4j.tools.UnitConv;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSOConstants;
import prospektservice.printj2.PDFPrinterGraphics;
import prospektservice.printj2.PrintBarcodes;

public class PrintableObject
implements Printable,
PSOConstants {
    protected static final int LEFT_UP = 0;
    protected static final int RIGHT_UP = 1;
    protected static final int LEFT_DOWN = 2;
    protected static final int RIGHT_DOWN = 3;
    protected static Font Arial90;
    protected static Font Arial48;
    protected static Font Arial32;
    protected static Font Arial18;
    protected static Font Arial14;
    protected static Font Arial14n;
    protected static Font Arial12;
    protected static Font Arial12n;
    protected static Font Arial10;
    protected static Font Arial10n;
    protected static Font Arial9;
    protected static Font Arial9n;
    protected static Font Arial8;
    protected static Font Arial8n;
    protected static Font Arial7;
    protected static Font Arial6;
    protected static Font Arial6n;
    protected static Font Arial5;
    protected static Font Arial5n;
    protected static Font Arial4;
    protected int printModus;
    protected PrintBarcodes barCodeGenerator;

    public static Double getCalcValue(String value) {
        Double result = 0.0;
        try {
            value = PSEnvironment.replace(value, ".", "");
            value = PSEnvironment.replace(value, ",", ".");
            result = Double.parseDouble(value);
        }
        catch (Throwable ex) {
            result = 0.0;
        }
        return result;
    }

    public PrintableObject() {
        Arial90 = new Font("Arial", 1, 90);
        Arial48 = new Font("Arial", 1, 48);
        Arial32 = new Font("Arial", 1, 32);
        Arial18 = new Font("Arial", 1, 18);
        Arial14 = new Font("Arial", 1, 14);
        Arial14n = new Font("Arial", 0, 14);
        Arial12 = new Font("Arial", 1, 12);
        Arial12n = new Font("Arial", 0, 12);
        Arial10 = new Font("Arial", 1, 10);
        Arial10n = new Font("Arial", 0, 10);
        Arial9 = new Font("Arial", 1, 9);
        Arial9n = new Font("Arial", 0, 9);
        Arial8 = new Font("Arial", 1, 8);
        Arial8n = new Font("Arial", 0, 8);
        Arial7 = new Font("Arial", 0, 7);
        Arial6 = new Font("Arial", 1, 6);
        Arial6n = new Font("Arial", 0, 6);
        Arial5 = new Font("Arial", 1, 5);
        Arial5n = new Font("Arial", 0, 5);
        Arial4 = new Font("Arial", 1, 4);
        this.barCodeGenerator = new PrintBarcodes();
    }

    @Override
    public int print(Graphics arg0, PageFormat arg1, int arg2) throws PrinterException {
        return 0;
    }

    public int getFontWidth(String str, Graphics g) {
        int l = 0;
        if (!(g instanceof PDFPrinterGraphics)) {
            FontMetrics bla = g.getFontMetrics(g.getFont());
            l = bla.stringWidth(str);
            bla = null;
        } else {
            PDFPrinterGraphics pg = (PDFPrinterGraphics)g;
            l = pg.getFontWidth(str);
        }
        return l;
    }

    public String setRightFontSize(Graphics g, String toPrint, int maxSize, int start) {
        int w = 0;
        String result = toPrint;
        w = this.getFontWidth(toPrint, g);
        if (w > maxSize || start > 0) {
            g.setFont(Arial8);
            w = this.getFontWidth(toPrint, g);
            if (w > maxSize) {
                g.setFont(Arial7);
                w = this.getFontWidth(toPrint, g);
                if (w > maxSize) {
                    g.setFont(Arial6);
                    w = this.getFontWidth(toPrint, g);
                    if (w > maxSize) {
                        g.setFont(Arial5);
                        w = this.getFontWidth(toPrint, g);
                        if (w > maxSize) {
                            g.setFont(Arial4);
                            w = this.getFontWidth(toPrint, g);
                            if (w > maxSize) {
                                result = this.cutText(toPrint, g, maxSize);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public String cutText(String in, Graphics g, int maxSize) {
        String result = "";
        int cnt = 0;
        while (this.getFontWidth(result, g) < maxSize && cnt < in.length()) {
            result = String.valueOf(result) + in.charAt(cnt++);
        }
        return result;
    }

    public void drawImageLink(int x1, int y1, int x2, int y2, String Filename, String url, Graphics g) {
        if (g instanceof PDFPrinterGraphics) {
            if (Filename == null) {
                return;
            }
            if (Filename.indexOf(PSEnvironment.getPSStdPath()) < 0) {
                Filename = String.valueOf(PSEnvironment.getPSStdPath()) + Filename;
            }
            PDFPrinterGraphics pg = (PDFPrinterGraphics)g;
            pg.drawImageLink(x1, y1, x2, y2, Filename, url);
        } else {
            this.drawImage(x1, y1, x2, y2, Filename, g);
        }
    }

    protected Dimension convertPixToMM(float widthMM, float heightMM) {
        float mmToInch = 25.4f;
        Dimension d = new Dimension(0, 0);
        float res = 72.0f;
        d.width = Math.round(widthMM / 25.4f * 72.0f);
        d.height = Math.round(heightMM / 25.4f * 72.0f);
        return d;
    }

    public void drawImage(int x1, int y1, int x2, int y2, String Filename, Graphics g) {
        if (Filename == null) {
            return;
        }
        if (Filename.indexOf(PSEnvironment.getPSStdPath()) < 0) {
            Filename = String.valueOf(PSEnvironment.getPSStdPath()) + Filename;
        }
        if (g instanceof PDFPrinterGraphics) {
            PDFPrinterGraphics pg = (PDFPrinterGraphics)g;
            pg.drawImage(x1, y1, x2, y2, Filename);
        } else {
            File bla;
            block10: {
                if (Filename.endsWith(".bmp")) {
                    Filename = String.valueOf(Filename.substring(0, Filename.lastIndexOf("."))) + ".gif";
                }
                bla = new File(Filename);
                try {
                    Filename = bla.getCanonicalPath();
                    if (!bla.exists()) break block10;
                    MediaTracker mt = new MediaTracker(PSEnvironment.mainframe);
                    Image img = Toolkit.getDefaultToolkit().getImage(Filename);
                    mt.addImage(img, 0, x2, y2);
                    try {
                        mt.waitForAll();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!mt.isErrorAny()) {
                        g.drawImage(img, x1, y1, x2, y2, PSEnvironment.mainframe);
                    }
                    mt = null;
                    img = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            bla = null;
        }
    }

    public void drawImage(int x1, int y1, int x2, int y2, com.lowagie.text.Image img, Graphics g) {
        PDFPrinterGraphics pg = (PDFPrinterGraphics)g;
        try {
            pg.drawImage(x1, y1, x2, y2, ImageIO.read(new ByteArrayInputStream(img.getOriginalData())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String insertCRLFSequence(String value, int lineWidth, Font font) {
        String result = "";
        boolean done = false;
        int actWidth = PSEnvironment.getComponentWidth(value, PSO.mainpanel, font);
        if (actWidth <= lineWidth) return value;
        String tmp = value;
        int bufferPos = 0;
        do {
            int pos = 0;
            while (PSEnvironment.getComponentWidth(tmp, PSO.mainpanel, font) > lineWidth) {
                pos = tmp.lastIndexOf(" ");
                if (pos == -1) {
                    done = true;
                    break;
                }
                tmp = tmp.substring(0, pos);
            }
            result = String.valueOf(result) + tmp.trim() + "\n";
            if (pos == 0) return result;
            tmp = value.substring((bufferPos += pos) + 1, value.length());
        } while (!done);
        return result;
    }

    protected Font getNextSmallerFont(int currentSize, int target) {
        Font targetFont = null;
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Font actFont;
                if (fields[i].get(this) instanceof Font && (actFont = (Font)fields[i].get(this)).getSize() == currentSize - target && actFont.isBold()) {
                    targetFont = actFont;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return targetFont == null ? this.getNextSmallerFont(currentSize, ++target) : targetFont;
    }

    public String setLength(String value, int length, int Position2) {
        if (value.trim().length() != length) {
            while (value.length() < length) {
                value = Position2 == 1 ? " " + value : String.valueOf(value) + " ";
                if (!PSEnvironment.DEBUG) continue;
                System.out.println("setLength -> " + value.length());
            }
        }
        return value;
    }

    public void setPrintModus(int modus) {
        this.printModus = modus;
    }

    public void drawVersionCopyrightAndLogo(Graphics g, int x, int y) {
        g.drawString("(c) 2025 POSTAKTUELL MANAGER Version 99.8.0", x, y);
        if (PSO.Modus != 4) {
            g.drawString("Stand der Haushaltszahlen: " + PSEnvironment.DB_HOUSEHOLDS, x, y + 7);
        } else {
            g.drawString("Stand der Briefabholer: " + PSEnvironment.DB_POBOXES, x, y + 7);
        }
        this.drawImage(x, y + 9, 135, 20, "./images/pso_logo_big.gif", g);
    }

    public void drawVersionCopyrightAndLogo(Graphics g, int x, int y, boolean schneidStapel) {
        if (!schneidStapel) {
            this.drawVersionCopyrightAndLogo(g, x, y);
            return;
        }
        g.drawString("(c) 2025 POSTAKTUELL MANAGER Version 99.8.0", x, y);
        if (PSO.Modus != 4) {
            g.drawString("Stand der Haushaltszahlen: " + PSEnvironment.DB_HOUSEHOLDS, x, y + 7);
        } else {
            g.drawString("Stand der Briefabholer: " + PSEnvironment.DB_POBOXES, x, y + 7);
        }
        this.drawImage(x, y + 9, 135, 20, "./images/pso_logo_big.gif", g);
    }

    public void drawVersionAndCopyright(Graphics g, int x, int y) {
        this.drawVersionAndCopyright(g, x, y, false);
    }

    public void drawVersionAndCopyright(Graphics g, int x, int y, boolean oneLine) {
        if (!oneLine) {
            g.drawString("(c) 2025 POSTAKTUELL MANAGER Version 99.8.0", x, y);
            if (PSO.Modus != 4) {
                g.drawString("Stand der Haushaltszahlen: " + PSEnvironment.DB_HOUSEHOLDS, x, y + 7);
            } else {
                g.drawString("Stand der Briefabholer: " + PSEnvironment.DB_POBOXES, x, y + 7);
            }
        } else {
            g.drawString("(c) 2025 POSTAKTUELL MANAGER Version 99.8.0 Stand der Haushaltszahlen: " + PSEnvironment.DB_HOUSEHOLDS, x, y);
        }
    }

    public void printBarcode(Graphics g, BufferedImage img, String zustell_termin, String am_auftragsid, int OffSetX, int OffSetY) {
        String locTermin = "";
        int posY = 330;
        if (PSO.mainpanel.AE.isUseAM()) {
            try {
                g.setFont(Arial9);
                String tmp = "";
                tmp = String.format("%s %s %s %s %s", am_auftragsid.substring(0, 2), am_auftragsid.substring(2, 5), am_auftragsid.substring(5, 8), am_auftragsid.substring(8, 11), am_auftragsid.substring(11, 14));
                g.drawString("AM-Nr.: " + tmp, 145 + OffSetX, 332 + (int)UnitConv.mm2pt((double)15.0) + OffSetY + 10);
                g.drawLine(201 + OffSetX, posY + OffSetY, 201 + OffSetX, posY + (int)UnitConv.mm2pt((double)15.0) + OffSetY);
                g.drawLine(202 + OffSetX, posY + OffSetY, 202 + OffSetX, posY + (int)UnitConv.mm2pt((double)15.0) + OffSetY);
                g.drawLine(204 + OffSetX, posY + OffSetY, 204 + OffSetX, posY + (int)UnitConv.mm2pt((double)15.0) + OffSetY);
                g.drawLine(205 + OffSetX, posY + OffSetY, 205 + OffSetX, posY + (int)UnitConv.mm2pt((double)15.0) + OffSetY);
                g.drawImage(img, 208 + OffSetX, posY + OffSetY, (int)UnitConv.mm2pt((double)15.0), (int)UnitConv.mm2pt((double)15.0), PSEnvironment.mainframe);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String formatAuftragsManagementId(String am_auftragsid) {
        String result = String.format("%s %s %s %s %s", am_auftragsid.substring(0, 2), am_auftragsid.substring(2, 5), am_auftragsid.substring(5, 8), am_auftragsid.substring(8, 11), am_auftragsid.substring(11, 14));
        return result;
    }

    protected Font getCondensedFont(Font orgFont) {
        HashMap<TextAttribute, Float> attributes = new HashMap<TextAttribute, Float>();
        attributes.put(TextAttribute.WIDTH, TextAttribute.WIDTH_CONDENSED);
        Font condensed = orgFont.deriveFont(attributes);
        return condensed;
    }

    protected void drawCondensedString(String value, int x, int y, float scaleX, float scaleY, Graphics g, Font font) {
        if (g instanceof PDFPrinterGraphics) {
            PDFPrinterGraphics pdfGraphics = (PDFPrinterGraphics)g;
            pdfGraphics.setFont(font);
            pdfGraphics.drawCondensedString(value, x, y, scaleX, scaleY);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            Font condensedFont = font.deriveFont(AffineTransform.getScaleInstance(scaleX, scaleY));
            g.setFont(condensedFont);
            g2d.drawString(value, x, y);
        }
    }

    protected String getPrintDate() {
        String result = "";
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        Date d = Calendar.getInstance().getTime();
        result = sdf.format(d);
        return result;
    }
}

