/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.printj2;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.printj2.PDFPrinterGraphics;
import prospektservice.printj2.PrintableObject;

public class PrintPaletteNotification
extends PrintableObject {
    private static long totalWeight = 0L;
    private static long totalPalCnt = 0L;
    private String pageData;

    public PrintPaletteNotification(String data) {
        this.pageData = data;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int actPage) throws PrinterException {
        Font Arial7b = Arial7.deriveFont(1);
        g.translate(20, 20);
        if (!PSAuftrag.isAbholungSelected()) {
            this.drawCondensedString("ELN-Transportavis an das Depot - Einlieferung > 20 Paletten", 25, 1, 0.75f, 1.0f, g, Arial12);
        } else {
            this.drawCondensedString("ELN-Transportavis an das Depot - Abholung", 25, 1, 0.75f, 1.0f, g, Arial12);
        }
        this.drawImage(395, -20, 140, 30, "images/dpostbw.bmp", g);
        if (g instanceof PDFPrinterGraphics) {
            PDFPrinterGraphics ppg = (PDFPrinterGraphics)g;
            ppg.setLineWidth(0.5f);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(0.5f));
        }
        g.drawLine(25, 4, 25, 20);
        g.drawLine(311, 4, 311, 20);
        g.drawLine(25, 20, 311, 20);
        this.drawCondensedString("E-Mail", 27, 9, 0.75f, 1.0f, g, Arial6n);
        int i = 0;
        while (i < 27) {
            if (i == 0 || i == 26) {
                g.drawLine(25 + i * 13, 38, 25 + i * 13, 54);
            } else {
                g.drawLine(25 + i * 13, 46, 25 + i * 13, 54);
            }
            ++i;
        }
        g.drawLine(25, 54, 363, 54);
        this.drawCondensedString("Auftrags-Nr.", 27, 43, 0.75f, 1.0f, g, Arial6n);
        i = 0;
        while (i < 9) {
            if (i == 0 || i == 2 || i == 4 || i == 8) {
                g.drawLine(436 + i * 13, 32, 436 + i * 13, 48);
            } else {
                g.drawLine(436 + i * 13, 40, 436 + i * 13, 48);
            }
            ++i;
        }
        g.drawLine(436, 48, 540, 48);
        this.drawCondensedString("Datum*", 438, 37, 0.75f, 1.0f, g, Arial6n);
        g.setColor(Color.black);
        g.fillRect(25, 53, 515, 13);
        g.setFont(Arial9);
        g.setColor(Color.white);
        this.drawCondensedString("Angaben zum Kunden", 27, 62, 0.75f, 1.0f, g, Arial8);
        g.setColor(Color.black);
        g.drawLine(25, 66, 25, 246);
        g.drawLine(155, 66, 155, 246);
        g.drawLine(337, 66, 337, 219);
        g.drawLine(438, 139, 438, 159);
        g.drawLine(540, 66, 540, 246);
        g.drawLine(25, 246, 540, 246);
        g.drawLine(155, 81, 540, 81);
        g.drawLine(25, 96, 540, 96);
        g.drawLine(155, 111, 540, 111);
        g.drawLine(25, 159, 540, 159);
        g.drawLine(25, 179, 540, 179);
        g.drawLine(155, 199, 540, 199);
        g.drawLine(155, 219, 540, 219);
        i = 0;
        while (i < 9) {
            g.drawLine(38 + i * 13, 88, 38 + i * 13, 96);
            g.drawLine(38 + i * 13, 118, 38 + i * 13, 126);
            ++i;
        }
        this.drawCondensedString("Einlieferer", 27, 72, 0.75f, 1.0f, g, Arial7b);
        this.drawCondensedString("Kundenummer", 27, 80, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Firma", 157, 72, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("E-Mail", 157, 87, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Ansprechpartner", 339, 72, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Telefon/Fax", 339, 87, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Absender", 27, 102, 0.75f, 1.0f, g, Arial7b);
        this.drawCondensedString("Kundenummer", 27, 110, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Firma", 157, 102, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("E-Mail", 157, 117, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Ansprechpartner", 339, 102, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Telefon/Fax", 339, 117, 0.75f, 1.0f, g, Arial7);
        g.fillRect(25, 126, 515, 13);
        g.setFont(Arial8);
        g.setColor(Color.white);
        g.drawRect(157, 129, 8, 8);
        this.drawCondensedString("Abholung", 167, 135, 0.75f, 1.0f, g, Arial8);
        g.drawRect(207, 129, 8, 8);
        this.drawCondensedString("Direkteinlieferung Kunde", 217, 135, 0.75f, 1.0f, g, Arial8);
        g.setColor(Color.black);
        this.drawCondensedString("Abholung bei/Direkteinlieferung durch", 27, 146, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("ZKZ (Pressepost)", 27, 166, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Aktionsbezeichnung/Titel", 27, 186, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Ansprechpartner", 157, 146, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Stra\u00dfe/Hausnummer", 157, 166, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("E-Mail", 157, 206, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Bemerkungen", 157, 226, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Abholdatum/Anfahrtsdatum", 339, 146, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Geplante Postauflieferung (Pal-Termin) am", 339, 166, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("PLZ/Ort", 157, 186, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Land", 339, 186, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Telefon", 339, 206, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Uhrzeit von-bis", 440, 146, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("Sendungsart", 27, 259, 0.75f, 1.0f, g, Arial8);
        this.drawCondensedString("Versandservice", 103, 259, 0.75f, 1.0f, g, Arial8);
        this.drawCondensedString("Einlieferung", 183, 259, 0.75f, 1.0f, g, Arial8);
        this.drawCondensedString("Paletten", 259, 259, 0.75f, 1.0f, g, Arial8);
        g.fillRect(375, 250, 165, 13);
        g.setFont(Arial9);
        g.setColor(Color.white);
        this.drawCondensedString("International", 377, 259, 0.75f, 1.0f, g, Arial8);
        g.setColor(Color.black);
        g.drawRect(27, 262, 8, 8);
        g.drawRect(27, 272, 8, 8);
        g.drawRect(27, 282, 8, 8);
        g.drawRect(27, 292, 8, 8);
        g.drawRect(27, 302, 8, 8);
        g.drawRect(27, 312, 8, 8);
        this.drawCondensedString("Dialogpost", 37, 268, 0.75f, 1.0f, g, Arial8n);
        this.drawCondensedString("Postaktuell", 37, 278, 0.75f, 1.0f, g, Arial8n);
        this.drawCondensedString("Postwurfspezial", 37, 288, 0.75f, 1.0f, g, Arial8n);
        this.drawCondensedString("Pressepost", 37, 298, 0.75f, 1.0f, g, Arial8n);
        this.drawCondensedString("Internat. Sendungen", 37, 308, 0.75f, 1.0f, g, Arial8n);
        this.drawCondensedString("Dialogpost schwer", 37, 318, 0.75f, 1.0f, g, Arial8n);
        g.drawRect(103, 292, 8, 8);
        g.drawRect(133, 292, 8, 8);
        this.drawCondensedString("E+2", 113, 298, 0.75f, 1.0f, g, Arial8n);
        this.drawCondensedString("E+4", 143, 298, 0.75f, 1.0f, g, Arial8n);
        g.drawRect(183, 262, 8, 8);
        g.drawRect(183, 272, 8, 8);
        g.drawRect(183, 282, 8, 8);
        g.drawRect(183, 302, 8, 8);
        this.drawCondensedString("Gesamteinlieferung", 193, 268, 0.75f, 1.0f, g, Arial8n);
        this.drawCondensedString("Teileinlieferung", 193, 278, 0.75f, 1.0f, g, Arial8n);
        this.drawCondensedString("letzte Einlieferung", 193, 288, 0.75f, 1.0f, g, Arial8n);
        this.drawCondensedString("Sammeltransportanmeldung", 193, 308, 0.75f, 1.0f, g, Arial8n);
        g.drawRect(259, 262, 8, 8);
        g.drawRect(259, 272, 8, 8);
        g.drawRect(259, 282, 8, 8);
        this.drawCondensedString("stapelf\u00e4hig", 269, 268, 0.75f, 1.0f, g, Arial8n);
        this.drawCondensedString("teilweise stapelf\u00e4hig", 269, 278, 0.75f, 1.0f, g, Arial8n);
        this.drawCondensedString("nicht stapelf\u00e4hig", 269, 288, 0.75f, 1.0f, g, Arial8n);
        g.drawRect(375, 264, 165, 63);
        i = 0;
        while (i < 6) {
            if (i < 5) {
                g.drawLine(375, 279 + i * 12, 540, 279 + i * 12);
            } else {
                g.drawLine(375, 279 + i * 12, 498, 279 + i * 12);
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            g.drawLine(375 + i * 41, 264, 375 + i * 41, 339);
            ++i;
        }
        this.drawCondensedString("PAL-Ziel", 383, 274, 0.75f, 1.0f, g, Arial7b);
        this.drawCondensedString("PAL-Anzahl", 421, 274, 0.75f, 1.0f, g, Arial7b);
        this.drawCondensedString("Gesamt-", 467, 270, 0.75f, 1.0f, g, Arial7b);
        this.drawCondensedString("Gewicht in kg", 459, 277, 0.75f, 1.0f, g, Arial7b);
        this.drawCondensedString("Abs./Titel/", 505, 270, 0.75f, 1.0f, g, Arial7b);
        this.drawCondensedString("sonst. Angaben", 499, 277, 0.75f, 1.0f, g, Arial7b);
        this.drawCondensedString("Summe", 386, 336, 0.75f, 1.0f, g, Arial7b);
        i = 0;
        while (i < 3) {
            g.fillRect(25 + i * 175, 347, 165, 13);
            g.setColor(Color.white);
            this.drawCondensedString("National", 27 + i * 175, 356, 0.75f, 1.0f, g, Arial8);
            g.setColor(Color.black);
            g.drawRect(25 + i * 175, 361, 165, 375);
            int j = 0;
            while (j < 33) {
                if (j < 31) {
                    g.drawLine(25 + i * 175, 376 + j * 12, 190 + i * 175, 376 + j * 12);
                } else if (j < 32) {
                    g.drawLine(25 + i * 175, 376 + j * 12, 148 + i * 175, 376 + j * 12);
                } else if (i == 2) {
                    g.drawLine(25 + i * 175, 382 + j * 12, 148 + i * 175, 382 + j * 12);
                    g.drawLine(25 + i * 175, 383 + j * 12, 148 + i * 175, 383 + j * 12);
                }
                ++j;
            }
            j = 0;
            while (j < 4) {
                if (i < 2) {
                    g.drawLine(25 + j * 41 + i * 175, 361, 25 + j * 41 + i * 175, 748);
                } else {
                    g.drawLine(25 + j * 41 + i * 175, 361, 25 + j * 41 + i * 175, 766);
                }
                ++j;
            }
            this.drawCondensedString("PAL-Ziel", 33 + i * 175, 371, 0.75f, 1.0f, g, Arial7b);
            this.drawCondensedString("PAL-Anzahl", 71 + i * 175, 371, 0.75f, 1.0f, g, Arial7b);
            this.drawCondensedString("Gesamt-", 117 + i * 175, 367, 0.75f, 1.0f, g, Arial7b);
            this.drawCondensedString("Gewicht in kg", 109 + i * 175, 374, 0.75f, 1.0f, g, Arial7b);
            this.drawCondensedString("Abs./Titel/", 155 + i * 175, 367, 0.75f, 1.0f, g, Arial7b);
            this.drawCondensedString("sonst. Angaben", 149 + i * 175, 374, 0.75f, 1.0f, g, Arial7b);
            this.drawCondensedString("Summe", 36 + i * 175, 745, 0.75f, 1.0f, g, Arial7b);
            if (i == 2) {
                this.drawCondensedString("Gesamt-", 35 + i * 175, 756, 0.75f, 1.0f, g, Arial7b);
                this.drawCondensedString("Summen", 35 + i * 175, 764, 0.75f, 1.0f, g, Arial7b);
            }
            ++i;
        }
        this.drawCondensedString("*Verbindliche Anmeldung bis sp\u00e4testens 12:00 Uhr am 2. Werktag vor der Abholung;", 25, 764, 0.75f, 1.0f, g, Arial7);
        this.drawCondensedString("(ohne Anrechnung Samstage, Sonn- und Feiertage, 24.12. und 31.12.)", 27, 771, 0.75f, 1.0f, g, Arial7);
        g.setFont(Arial6n);
        this.drawVersionAndCopyright(g, 27, 790);
        if (this.printModus < 4) {
            StringTokenizer t = new StringTokenizer(this.pageData, "|");
            try {
                g.setFont(Arial8n);
                String amNum = PSAuftrag.getAMNummer();
                int i2 = 0;
                while (i2 < amNum.length()) {
                    g.drawString(amNum.substring(i2, i2 + 1), 29 + i2 * 13, 50);
                    ++i2;
                }
                String jobname = PSAuftrag.getJobName();
                g.drawString(this.cutText(jobname, g, 120), 27, 200);
                SimpleDateFormat formatter = new SimpleDateFormat("ddMMyyyy");
                Calendar calender = Calendar.getInstance();
                Date rightNow = calender.getTime();
                String date = formatter.format(rightNow);
                int i3 = 0;
                while (i3 < date.length()) {
                    g.drawString(date.substring(i3, i3 + 1), 440 + i3 * 13, 44);
                    ++i3;
                }
                g.drawString(PSAuftrag.getDepotMail(), 29, 16);
                String einlKNR = PSAuftrag.cbformulare.cb_abs_einl ? PSAuftrag.absender.KDNR : PSAuftrag.einlieferer.KDNR;
                int i4 = 0;
                while (i4 < einlKNR.length()) {
                    g.drawString(einlKNR.substring(i4, i4 + 1), 29 + i4 * 13, 92);
                    ++i4;
                }
                String absKNR = PSAuftrag.absender.KDNR;
                int i5 = 0;
                while (i5 < absKNR.length()) {
                    g.drawString(absKNR.substring(i5, i5 + 1), 29 + i5 * 13, 122);
                    ++i5;
                }
                String einlieferer = PSAuftrag.cbformulare.cb_abs_einl ? PSAuftrag.absender.Name : PSAuftrag.einlieferer.Name;
                this.setRightFontSize(g, einlieferer, 165, 0);
                g.drawString(einlieferer, 173, 76);
                g.setFont(Arial8n);
                String einlTelefon = PSAuftrag.cbformulare.cb_abs_einl ? PSAuftrag.absender.Telefon : PSAuftrag.einlieferer.Telefon;
                g.drawString(einlTelefon, 372, 91);
                String absender = PSAuftrag.absender.Name;
                this.setRightFontSize(g, absender, 165, 0);
                g.drawString(absender, 173, 106);
                g.setFont(Arial8n);
                String absTelefon = PSAuftrag.absender.Telefon;
                g.drawString(absTelefon, 372, 121);
                Date d = PSAuftrag.getCommitalDate();
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                g.drawString(sdf.format(d), 372, 156);
                Date d2 = PSAuftrag.getCommitalTimeSpan();
                sdf = new SimpleDateFormat("HH:mm");
                if (d2 != null) {
                    g.drawString(String.valueOf(sdf.format(d)) + " - " + sdf.format(d2), 474, 156);
                } else {
                    g.drawString(sdf.format(d), 474, 156);
                }
                g.setFont(Arial10);
                g.drawString("X", 28, 280);
                g.drawString("X", 134, 300);
                g.drawString("X", 184, 270);
                g.setFont(Arial8n);
                if (PSAuftrag.isAbholungSelected()) {
                    String abholAnschrift = PSO.mainpanel.AE.getAbholer();
                    String[] abholAddress = abholAnschrift.split(",");
                    g.drawString(this.cutText(abholAddress[0], g, 120), 173, 176);
                    g.drawString(abholAddress[1].trim(), 173, 196);
                    g.setFont(Arial10);
                    g.setColor(Color.white);
                    g.drawString("X", 158, 137);
                } else {
                    String annahme = PSO.mainpanel.AE.getAnnahme();
                    String[] address = annahme.split(",");
                    g.drawString(this.cutText(address[1], g, 120), 173, 176);
                    g.drawString(address[0].trim(), 173, 196);
                    g.setFont(Arial10);
                    g.setColor(Color.white);
                    g.drawString("X", 208, 137);
                }
                g.setColor(Color.black);
                g.setFont(Arial8n);
                t.nextToken();
                t.nextToken();
                int rowCounter = 0;
                int colFactor = 175;
                int colCnt = 0;
                long palSum = 0L;
                long weightSum = 0L;
                while (t.hasMoreTokens()) {
                    StringTokenizer stLine = new StringTokenizer(t.nextToken(), ";");
                    g.drawString(stLine.nextToken(), 27 + colFactor * colCnt, 385 + rowCounter * 12);
                    String palCnt = stLine.nextToken();
                    palSum += (long)PSEnvironment.getIntValue(palCnt);
                    g.drawString(palCnt, 68 + colFactor * colCnt, 385 + rowCounter * 12);
                    String weight = stLine.nextToken();
                    weightSum += (long)PSEnvironment.getIntValue(weight);
                    String formattedWeight = PSEnvironment.Format(weight, "###,##0.00");
                    g.drawString(formattedWeight, 146 + colFactor * colCnt - this.getFontWidth(formattedWeight, g), 385 + rowCounter * 12);
                    if (++rowCounter % 30 != 0) continue;
                    g.drawString("" + palSum, 68 + colFactor * colCnt, 385 + rowCounter * 12);
                    formattedWeight = PSEnvironment.Format("" + weightSum, "###,##0.00");
                    g.drawString(formattedWeight, 146 + colFactor * colCnt - this.getFontWidth(formattedWeight, g), 385 + rowCounter * 12);
                    ++colCnt;
                    rowCounter = 0;
                    totalWeight += weightSum;
                    totalPalCnt += palSum;
                    palSum = 0L;
                    weightSum = 0L;
                }
                if (rowCounter % 30 != 0) {
                    totalWeight += weightSum;
                    totalPalCnt += palSum;
                }
                g.drawString("" + palSum, 68 + colFactor * colCnt, 745);
                String formattedWeight = PSEnvironment.Format("" + weightSum, "###,##0.00");
                g.drawString(formattedWeight, 146 + colFactor * colCnt - this.getFontWidth(formattedWeight, g), 745);
                g.drawString("" + totalPalCnt, 68 + colFactor * 2, 760);
                formattedWeight = PSEnvironment.Format("" + totalWeight, "###,##0.00");
                g.drawString(formattedWeight, 146 + colFactor * 2 - this.getFontWidth(formattedWeight, g), 760);
                PSAuftrag.setPaletteWeight(totalWeight);
                if (PSAuftrag.getPaletteWeight() < 5000.0) {
                    g.drawString("X", 184, 310);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        g.dispose();
        return 0;
    }

    public void endPrintJob() {
        totalPalCnt = 0L;
        totalWeight = 0L;
    }

    public int printBak(Graphics g, PageFormat pf, int actPage) throws PrinterException {
        g.translate(20, 20);
        g.setColor(Color.black);
        int startX = -8;
        int startY = 16;
        int lineHeight = 13;
        g.setFont(Arial14.deriveFont(16.0f));
        g.drawString("ELN-Transportanmeldung an das Depot", startX + 3, startY);
        g.setFont(Arial10);
        g.drawString("Datum: ", startX + 2, startY + lineHeight);
        g.drawLine(startX + 72, startY + lineHeight + 3, 184, startY + lineHeight + 3);
        g.drawString("(Verbindl. Anmeldung bis sp\u00e4testens 12.00 Uhr am 2. Werktag* vor Abholtag)", startX + 205, startY + lineHeight);
        g.drawString("An Fax: ", startX + 2, startY + 2 * ++lineHeight);
        g.drawLine(startX + 72, startY + 2 * lineHeight + 3, 184, startY + 2 * lineHeight + 3);
        g.drawString("Auftrags-Nr.:", startX + 205, startY + 2 * lineHeight);
        g.drawLine(startX + 274, startY + 2 * lineHeight + 3, 528, startY + 2 * lineHeight + 3);
        if (g instanceof PDFPrinterGraphics) {
            g.drawRect(startX, startY + 2 * lineHeight + 9, 560, 184);
            g.drawRect(startX + 1, startY + 2 * lineHeight + 10, 558, 182);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(2.0f));
            g.drawRect(startX, startY + 2 * lineHeight + 9, 560, 184);
            g2d.setStroke(oldStroke);
        }
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine(startX + 2, startY + 3 * --lineHeight + 12, startX + 558, startY + 3 * lineHeight + 12);
        g.drawLine(startX + 2, startY + 4 * lineHeight + 12, startX + 558, startY + 4 * lineHeight + 12);
        g.drawLine(startX + 2, startY + 5 * lineHeight + 12, startX + 558, startY + 5 * lineHeight + 12);
        g.drawLine(startX + 2, startY + 6 * lineHeight + 12, startX + 558, startY + 6 * lineHeight + 12);
        g.drawLine(startX + 2, startY + 7 * lineHeight + 12, startX + 558, startY + 7 * lineHeight + 12);
        g.drawLine(startX + 2, startY + 8 * lineHeight + 12, startX + 558, startY + 8 * lineHeight + 12);
        g.drawLine(startX + 2, startY + 10 * lineHeight + 12, startX + 558, startY + 10 * lineHeight + 12);
        g.drawLine(startX + 2, startY + 11 * lineHeight + 12, startX + 417, startY + 11 * lineHeight + 12);
        g.drawLine(startX + 2, startY + 12 * lineHeight + 12, startX + 417, startY + 12 * lineHeight + 12);
        g.drawLine(startX + 2, startY + 13 * lineHeight + 12, startX + 417, startY + 13 * lineHeight + 12);
        g.drawLine(startX + 2, startY + 14 * lineHeight + 12, startX + 417, startY + 14 * lineHeight + 12);
        g.drawLine(startX + 2, startY + 15 * lineHeight + 12, startX + 417, startY + 15 * lineHeight + 12);
        g.setColor(Color.BLACK);
        g.drawLine(startX, startY + 2 * ++lineHeight + 100, startX + 560, startY + 2 * lineHeight + 100);
        g.drawLine(startX, startY + 2 * lineHeight + 101, startX + 560, startY + 2 * lineHeight + 101);
        g.drawLine(startX + 72, startY + 2 * lineHeight + 10, startX + 72, startY + 2 * lineHeight + 192);
        g.drawLine(startX + 239, startY + 2 * lineHeight + 10, startX + 239, startY + 2 * lineHeight + 192);
        g.drawLine(startX + 418, startY + 2 * lineHeight + 10, startX + 418, startY + 2 * lineHeight + 192);
        g.drawLine(startX + 239, startY + 13 * --lineHeight + 12, startX + 418, startY + 13 * lineHeight + 12);
        g.drawString("Einlieferer", startX + 74, startY + 3 * lineHeight + 9);
        g.drawString("Empfangsstelle (Depot)", startX + 241, startY + 3 * lineHeight + 9);
        g.drawString("Absender", startX + 420, startY + 3 * lineHeight + 9);
        g.drawString("Kunden-Nr.:", startX + 2, startY + 4 * lineHeight + 9);
        g.drawString("Firma:", startX + 2, startY + 5 * lineHeight + 9);
        g.drawString("Ansprechp:", startX + 2, startY + 6 * lineHeight + 9);
        g.drawString("Telefon:", startX + 2, startY + 7 * lineHeight + 9);
        g.drawString("Fax:", startX + 2, startY + 8 * lineHeight + 9);
        g.drawString("E-Mail:", startX + 2, startY + 9 * lineHeight + 9);
        g.drawString("Abholung bei", startX + 2, startY + 10 * lineHeight + 9);
        g.drawString("Ansprechp:", startX + 2, startY + 11 * lineHeight + 9);
        g.drawString("Stra\u00dfe:", startX + 2, startY + 12 * lineHeight + 9);
        g.drawString("PLZ / Ort:", startX + 2, startY + 13 * lineHeight + 9);
        g.drawString("Telefon:", startX + 2, startY + 14 * lineHeight + 9);
        g.drawString("Fax:", startX + 2, startY + 15 * lineHeight + 9);
        g.drawString("E-Mail:", startX + 2, startY + 16 * lineHeight + 9);
        g.setFont(Arial10.deriveFont(11.0f));
        g.drawString("Abholdatum:", startX + 241, startY + 10 * lineHeight + 9);
        g.drawString("Abholuhrzeit:", startX + 241, startY + 11 * lineHeight + 9);
        g.setFont(Arial10n);
        g.drawString("Vorgangs-Nr.:", startX + 241, startY + 12 * lineHeight + 9);
        g.drawString("ZKZ (Pressepost):", startX + 241, startY + 13 * lineHeight + 9);
        g.setFont(Arial12);
        g.drawString("Aktionsbezeichnung / Titel:", startX + 241, startY + 14 * lineHeight + 9);
        g.setFont(Arial10);
        g.drawString("Bemerkungen:", startX + 420, startY + 10 * lineHeight + 9);
        g.drawString("Sendungsart", startX + 13, startY + 17 * lineHeight + 11);
        g.drawString("Einlieferung", startX + 150, startY + 17 * lineHeight + 11);
        g.drawString("Paletten", startX + 266, startY + 17 * lineHeight + 11);
        g.drawString("International", startX + 385, startY + 17 * lineHeight + 11);
        g.drawRect(startX + 11, (startY += 17) + 17 * --lineHeight + 14, lineHeight, lineHeight);
        g.drawRect(startX + 11, startY + 18 * lineHeight + 14, lineHeight, lineHeight);
        g.drawRect(startX + 11, startY + 19 * lineHeight + 14, lineHeight, lineHeight);
        g.drawRect(startX + 11, startY + 20 * lineHeight + 14, lineHeight, lineHeight);
        g.drawRect(startX + 11, startY + 21 * lineHeight + 14, lineHeight, lineHeight);
        g.setFont(Arial10n);
        g.drawString("Dialogpost", startX + lineHeight + 15, startY + 18 * lineHeight + 12);
        g.drawString("Postaktuell", startX + lineHeight + 15, startY + 19 * lineHeight + 12);
        g.drawString("Postwurfspezial", startX + lineHeight + 15, startY + 20 * lineHeight + 12);
        g.drawString("Pressepost", startX + lineHeight + 15, startY + 21 * lineHeight + 12);
        g.drawString("Internationale Sendungen", startX + lineHeight + 15, startY + 22 * lineHeight + 12);
        g.drawRect(startX + 148, startY + 17 * lineHeight + 14, lineHeight, lineHeight);
        g.drawRect(startX + 148, startY + 18 * lineHeight + 14, lineHeight, lineHeight);
        g.drawRect(startX + 148, startY + 19 * lineHeight + 14, lineHeight, lineHeight);
        g.drawString("Gesamteinlieferung", startX + lineHeight + 152, startY + 18 * lineHeight + 12);
        g.drawString("Teileinlieferung", startX + lineHeight + 152, startY + 19 * lineHeight + 12);
        g.drawString("letzte Einlieferung", startX + lineHeight + 152, startY + 20 * lineHeight + 12);
        g.drawRect(startX + 264, startY + 17 * lineHeight + 14, lineHeight, lineHeight);
        g.drawRect(startX + 264, startY + 18 * lineHeight + 14, lineHeight, lineHeight);
        g.drawRect(startX + 264, startY + 19 * lineHeight + 14, lineHeight, lineHeight);
        g.drawString("stapelf\u00e4hig", startX + lineHeight + 268, startY + 18 * lineHeight + 12);
        g.drawString("teilweise stapelf\u00e4hig", startX + lineHeight + 268, startY + 19 * lineHeight + 12);
        g.drawString("nicht stapelf\u00e4hig", startX + lineHeight + 268, startY + 20 * lineHeight + 12);
        g.drawString("Gesamtsumme Palettenstellpl\u00e4tze:", startX + lineHeight + 150, startY + 22 * lineHeight + 12);
        g.drawRect(startX + 148 + lineHeight, startY + 21 * lineHeight + 15, 200, lineHeight);
        g.drawRect(startX + 147 + lineHeight, startY + 21 * lineHeight + 14, 202, lineHeight + 2);
        g.drawRect(startX + 383, startY + 17 * lineHeight + 14, 177, 5 * lineHeight + 1);
        g.drawLine(startX + 384, startY + 19 * lineHeight + 14, startX + 560, startY + 19 * lineHeight + 14);
        g.drawLine(startX + 384, startY + 20 * lineHeight + 14, startX + 560, startY + 20 * lineHeight + 14);
        g.drawLine(startX + 384, startY + 21 * lineHeight + 14, startX + 560, startY + 21 * lineHeight + 14);
        g.drawLine(startX + 419, startY + 17 * lineHeight + 14, startX + 419, startY + 22 * lineHeight + 14);
        g.drawLine(startX + 454, startY + 17 * lineHeight + 14, startX + 454, startY + 22 * lineHeight + 14);
        g.drawLine(startX + 504, startY + 17 * lineHeight + 14, startX + 504, startY + 22 * lineHeight + 14);
        g.setFont(Arial9n);
        g.drawString("Pal-Ziel", startX + 386, startY + 19 * lineHeight + 11);
        g.drawString("Pal-", startX + 429, startY + 18 * lineHeight + 11);
        g.drawString("Anzahl", startX + 423, startY + 19 * lineHeight + 11);
        g.drawString("Gesamt-", startX + 462, startY + 18 * lineHeight + 11);
        g.drawString("gew. in kg", startX + 458, startY + 19 * lineHeight + 11);
        g.drawString("Abs. / Titel /", startX + 508, startY + 18 * lineHeight + 11);
        g.drawString("Einlieferer", startX + 512, startY + 19 * lineHeight + 11);
        g.setFont(Arial10);
        g.drawString("National", startX + 2, startY + 24 * lineHeight + 3);
        g.drawString("National", startX + 193, startY + 24 * lineHeight + 3);
        g.drawString("National", startX + 385, startY + 24 * lineHeight + 3);
        g.drawRect(startX, startY + 24 * lineHeight + 10, 177, 37 * lineHeight + 1);
        g.drawRect(startX + 191, startY + 24 * lineHeight + 10, 177, 37 * lineHeight + 1);
        g.drawRect(startX + 383, startY + 24 * lineHeight + 10, 177, 37 * lineHeight + 1);
        int i = 0;
        while (i < 34) {
            g.drawLine(startX, startY + (28 + i) * lineHeight, startX + 176, startY + (28 + i) * lineHeight);
            g.drawLine(startX + 192, startY + (28 + i) * lineHeight, startX + 368, startY + (28 + i) * lineHeight);
            g.drawLine(startX + 384, startY + (28 + i) * lineHeight, startX + 560, startY + (28 + i) * lineHeight);
            ++i;
        }
        g.drawLine(startX + 35, startY + 24 * lineHeight + 10, startX + 35, startY + 61 * lineHeight + 11);
        g.drawLine(startX + 70, startY + 24 * lineHeight + 10, startX + 70, startY + 61 * lineHeight + 11);
        g.drawLine(startX + 120, startY + 24 * lineHeight + 10, startX + 120, startY + 61 * lineHeight + 11);
        g.drawLine(startX + 226, startY + 24 * lineHeight + 10, startX + 226, startY + 61 * lineHeight + 11);
        g.drawLine(startX + 261, startY + 24 * lineHeight + 10, startX + 261, startY + 61 * lineHeight + 11);
        g.drawLine(startX + 311, startY + 24 * lineHeight + 10, startX + 311, startY + 61 * lineHeight + 11);
        g.drawLine(startX + 418, startY + 24 * lineHeight + 10, startX + 418, startY + 62 * lineHeight + 11);
        g.drawLine(startX + 454, startY + 24 * lineHeight + 10, startX + 454, startY + 62 * lineHeight + 11);
        g.drawLine(startX + 504, startY + 24 * lineHeight + 10, startX + 504, startY + 61 * lineHeight + 11);
        g.setFont(Arial9n);
        g.drawString("Pal-Ziel", startX + 3, startY + 27 * lineHeight + 10);
        g.drawString("Pal-", startX + 45, startY + 26 * lineHeight + 10);
        g.drawString("Anzahl", startX + 39, startY + 27 * lineHeight + 10);
        g.drawString("Gesamt-", startX + 78, startY + 25 * lineHeight + 10);
        g.drawString("gewicht", startX + 80, startY + 26 * lineHeight + 10);
        g.drawString("in kg", startX + 84, startY + 27 * lineHeight + 10);
        g.drawString("Abs. / Titel /", startX + 126, startY + 26 * lineHeight + 10);
        g.drawString("Einlieferer", startX + 129, startY + 27 * lineHeight + 10);
        g.drawString("Pal-Ziel", startX + 194, startY + 27 * lineHeight + 10);
        g.drawString("Pal-", startX + 236, startY + 26 * lineHeight + 10);
        g.drawString("Anzahl", startX + 230, startY + 27 * lineHeight + 10);
        g.drawString("Gesamt-", startX + 269, startY + 25 * lineHeight + 10);
        g.drawString("gewicht", startX + 271, startY + 26 * lineHeight + 10);
        g.drawString("in kg", startX + 275, startY + 27 * lineHeight + 10);
        g.drawString("Abs. / Titel /", startX + 317, startY + 26 * lineHeight + 10);
        g.drawString("Einlieferer", startX + 320, startY + 27 * lineHeight + 10);
        g.drawString("Pal-Ziel", startX + 386, startY + 27 * lineHeight + 10);
        g.drawString("Pal-", startX + 428, startY + 26 * lineHeight + 10);
        g.drawString("Anzahl", startX + 422, startY + 27 * lineHeight + 10);
        g.drawString("Gesamt-", startX + 462, startY + 25 * lineHeight + 10);
        g.drawString("gewicht", startX + 464, startY + 26 * lineHeight + 10);
        g.drawString("in kg", startX + 468, startY + 27 * lineHeight + 10);
        g.drawString("Abs. / Titel /", startX + 510, startY + 26 * lineHeight + 10);
        g.drawString("Einlieferer", startX + 513, startY + 27 * lineHeight + 10);
        g.drawLine(startX, startY + 16 * lineHeight + 11, startX, startY + 24 * lineHeight + 10);
        g.drawLine(startX + 560, startY + 16 * lineHeight + 11, startX + 560, startY + 24 * lineHeight + 10);
        g.drawRect(startX + 1, startY + 60 * lineHeight + 11, 175, lineHeight - 1);
        g.drawRect(startX + 192, startY + 60 * lineHeight + 11, 175, lineHeight - 1);
        g.drawRect(startX + 384, startY + 60 * lineHeight + 11, 175, lineHeight - 1);
        g.drawRect(startX + 383, startY + 61 * lineHeight + 10, 122, lineHeight + 1);
        g.drawRect(startX + 384, startY + 61 * lineHeight + 11, 120, lineHeight - 1);
        g.setFont(Arial8n);
        g.drawString("Summe", startX + 3, startY + 61 * lineHeight + 8);
        g.drawString("Summe", startX + 194, startY + 61 * lineHeight + 8);
        g.drawString("Summe", startX + 386, startY + 61 * lineHeight + 8);
        g.setFont(Arial9);
        g.drawString("Ges.", startX + 386, startY + 62 * lineHeight + 7);
        g.setFont(Arial6n);
        this.drawVersionAndCopyright(g, startX, startY + 63 * lineHeight + 7);
        if (this.printModus < 4) {
            StringTokenizer t = new StringTokenizer(this.pageData, "|");
            try {
                g.setFont(Arial10n);
                String amNum = PSAuftrag.getAMNummer();
                g.drawString(amNum, startX + 276, startY + 2 * lineHeight - 14);
                String jobname = PSAuftrag.getMainJobName();
                g.drawString(jobname, startX + 241, startY + 15 * lineHeight + 6);
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
                Calendar calender = Calendar.getInstance();
                Date rightNow = calender.getTime();
                String date = formatter.format(rightNow);
                g.drawString(date, startX + 74, startY - 3);
                g.drawString(PSAuftrag.getDepotFax(), startX + 74, startY + 2 * lineHeight - 14);
                if (!PSAuftrag.cbformulare.cb_abs_einl && PSAuftrag.einlieferer.Strasse.length() > 0) {
                    String einlKNR = PSAuftrag.einlieferer.KDNR;
                    g.drawString(einlKNR, startX + 74, startY + 3 * lineHeight + 8);
                    String einlieferer = PSAuftrag.einlieferer.Name;
                    g.drawString(einlieferer, startX + 74, startY + 4 * lineHeight + 9);
                    String einlTelefon = PSAuftrag.einlieferer.Telefon;
                    g.drawString(einlTelefon, startX + 74, startY + 7 * lineHeight - 1);
                }
                String absKNR = PSAuftrag.absender.KDNR;
                g.drawString(absKNR, startX + 420, startY + 3 * lineHeight + 8);
                String absender = PSAuftrag.absender.Name;
                g.drawString(absender, startX + 420, startY + 4 * lineHeight + 9);
                String absTelefon = PSAuftrag.absender.Telefon;
                g.drawString(absTelefon, startX + 420, startY + 7 * lineHeight - 1);
                String empfangsstelle = String.valueOf(PSAuftrag.getDepotName()) + ", " + PSAuftrag.getDepotZipTown();
                g.drawString(empfangsstelle, startX + 241, startY + 4 * lineHeight + 9);
                String depotPhone = PSAuftrag.getDepotPhone();
                g.drawString(depotPhone, startX + 241, startY + 7 * lineHeight - 1);
                String depotFax = PSAuftrag.getDepotFax();
                g.drawString(depotFax, startX + 241, startY + 8 * lineHeight);
                g.setFont(Arial14.deriveFont(15.0f));
                g.drawString("X", startX + 12, startY + 19 * lineHeight + 13);
                g.setFont(Arial10n);
                String abholDate = PSO.mainpanel.AE.getAbholTermin();
                String[] abholDateTime = abholDate.split(" ");
                g.drawString(abholDateTime[0], startX + 315, startY + 10 * lineHeight + 2);
                g.drawString(abholDateTime[1], startX + 315, startY + 11 * lineHeight + 3);
                String abholAnschrift = PSO.mainpanel.AE.getAbholer();
                String[] abholAddress = abholAnschrift.split(",");
                g.drawString(abholAddress[0], startX + 74, startY + 12 * lineHeight + 5);
                g.drawString(abholAddress[1].trim(), startX + 74, startY + 13 * lineHeight + 6);
                g.setFont(Arial8n);
                t.nextToken();
                t.nextToken();
                int rowCounter = 0;
                int colFactor = 191;
                int colCnt = 0;
                long palSum = 0L;
                long weightSum = 0L;
                while (t.hasMoreTokens()) {
                    StringTokenizer stLine = new StringTokenizer(t.nextToken(), ";");
                    g.drawString(stLine.nextToken(), startX + 3 + colFactor * colCnt, startY + 28 * lineHeight + 10 + rowCounter * lineHeight);
                    String palCnt = stLine.nextToken();
                    palSum += (long)PSEnvironment.getIntValue(palCnt);
                    g.drawString(palCnt, startX + 38 + colFactor * colCnt, startY + 28 * lineHeight + 10 + rowCounter * lineHeight);
                    String weight = stLine.nextToken();
                    weightSum += (long)PSEnvironment.getIntValue(weight);
                    String formattedWeight = PSEnvironment.Format(weight, "###,##0.00");
                    g.drawString(formattedWeight, startX + 118 + colFactor * colCnt - this.getFontWidth(formattedWeight, g), startY + 28 * lineHeight + 10 + rowCounter++ * lineHeight);
                    if (rowCounter % 33 != 0) continue;
                    g.drawString("" + palSum, startX + 38 + colFactor * colCnt, startY + 28 * lineHeight + 8 + rowCounter * lineHeight);
                    g.drawString(PSEnvironment.Format("" + weightSum, "###,##0.00"), startX + 73 + colFactor * colCnt, startY + 28 * lineHeight + 8 + rowCounter++ * lineHeight);
                    ++colCnt;
                    rowCounter = 0;
                }
                g.drawString("" + palSum, startX + 38 + colFactor * colCnt, startY + 28 * lineHeight + 8 + 33 * lineHeight);
                g.drawString(PSEnvironment.Format("" + weightSum, "###,##0.00"), startX + 73 + colFactor * colCnt, startY + 28 * lineHeight + 8 + 33 * lineHeight);
                g.drawString("" + palSum, startX + 38 + colFactor * 2, startY + 28 * lineHeight + 8 + 34 * lineHeight);
                g.drawString(PSEnvironment.Format("" + weightSum, "###,##0.00"), startX + 73 + colFactor * 2, startY + 28 * lineHeight + 8 + 34 * lineHeight);
                g.drawString("* ohne Anrechnung Samstage, Sonn- und Feiertage, 24.12. und 31.12.", startX + 2, startY + 28 * lineHeight + 8 + 34 * lineHeight);
                PSAuftrag.setPaletteWeight(weightSum);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }

    public int printOld(Graphics g, PageFormat pf, int actPage) throws PrinterException {
        g.translate(20, 20);
        this.drawImage(375, 4, 160, 40, "images/dpostbw.bmp", g);
        g.setColor(Color.black);
        g.setFont(Arial12);
        g.drawString("Palettenavisierung", 10, 25);
        g.setFont(Arial10);
        g.drawString("Auftrags-/Aktionsbezeichnung: ", 10, 40);
        g.drawString("Stand: ", 10, 52);
        g.setFont(Arial12);
        g.drawString("Einlieferer", 10, 75);
        g.setFont(Arial10n);
        g.drawString("Name und Anschrift:", 10, 90);
        g.drawString("Kunden- / Kartennummer:", 10, 102);
        g.drawString("Ansprechpartner:", 10, 114);
        g.drawString("Telefon:", 10, 126);
        g.drawString("Telefax:", 250, 126);
        g.setFont(Arial12);
        g.drawString("Absender", 10, 145);
        g.setFont(Arial10n);
        g.drawString("Name und Anschrift:", 10, 160);
        g.drawString("Kunden- / Kartennummer:", 10, 172);
        g.setFont(Arial12);
        g.drawString("Empfangsstelle", 10, 195);
        g.setFont(Arial10n);
        g.drawString("Name und Anschrift:", 10, 210);
        g.drawString("Ansprechpartner:", 10, 222);
        g.drawString("Telefon:", 10, 234);
        g.drawString("Telefax:", 250, 234);
        g.setFont(Arial12);
        g.drawString("Projekt", 10, 255);
        g.setFont(Arial10n);
        g.drawString("Sendungsart:", 10, 270);
        g.drawString("Einl.-Nr.:", 250, 270);
        g.drawString("Auftrags-/Aktionsbezeichnung:", 10, 282);
        g.setFont(Arial12);
        g.drawString("Abholung", 10, 305);
        g.setFont(Arial10n);
        g.drawString("Datum / Zeit:", 10, 320);
        g.drawString("Vorgangs-Nr.:", 250, 320);
        g.drawString("Lfd. Nr.:", 430, 320);
        g.drawString("Anschrift:", 10, 332);
        g.setFont(Arial12);
        g.drawString("Paletten", 10, 350);
        g.drawRect(10, 360, 168, 335);
        g.drawRect(186, 360, 168, 335);
        g.drawRect(362, 360, 168, 335);
        int i = 0;
        while (i < 26) {
            g.drawLine(10, 383 + i * 12, 178, 383 + i * 12);
            g.drawLine(186, 383 + i * 12, 354, 383 + i * 12);
            g.drawLine(362, 383 + i * 12, 530, 383 + i * 12);
            g.drawLine(10, 383 + i * 12, 10, 395 + i * 12);
            g.drawLine(50, 360 + i * 12, 50, 395 + i * 12);
            g.drawLine(85, 360 + i * 12, 85, 395 + i * 12);
            g.drawLine(150, 360 + i * 12, 150, 395 + i * 12);
            g.drawLine(178, 383 + i * 12, 178, 395 + i * 12);
            g.drawLine(186, 383 + i * 12, 186, 395 + i * 12);
            g.drawLine(226, 360 + i * 12, 226, 395 + i * 12);
            g.drawLine(261, 360 + i * 12, 261, 395 + i * 12);
            g.drawLine(326, 360 + i * 12, 326, 395 + i * 12);
            g.drawLine(354, 383 + i * 12, 354, 395 + i * 12);
            g.drawLine(362, 383 + i * 12, 362, 395 + i * 12);
            g.drawLine(402, 360 + i * 12, 402, 395 + i * 12);
            g.drawLine(437, 360 + i * 12, 437, 395 + i * 12);
            g.drawLine(502, 360 + i * 12, 502, 395 + i * 12);
            g.drawLine(530, 383 + i * 12, 530, 395 + i * 12);
            ++i;
        }
        g.setFont(Arial6n);
        i = 0;
        while (i < 3) {
            g.drawString("Paletten-", 12 + i * 176, 366);
            g.drawString("ziel", 12 + i * 176, 372);
            g.drawString("Anzahl", 52 + i * 176, 366);
            g.drawString("Gesamt-", 87 + i * 176, 366);
            g.drawString("gewicht", 87 + i * 176, 372);
            g.drawString("in kg", 87 + i * 176, 378);
            g.drawString("Abs. /", 152 + i * 176, 366);
            g.drawString("Titel /", 152 + i * 176, 372);
            g.drawString("Einl.", 152 + i * 176, 378);
            ++i;
        }
        g.drawRect(10, 699, 10, 10);
        g.setFont(Arial10n);
        g.drawString("Paletten stapelf\u00e4hig", 24, 708);
        g.drawString("Anzahl ben\u00f6tigter Stellpl\u00e4tze:", 250, 708);
        g.setFont(Arial12);
        g.drawString("Bemerkungen:", 10, 726);
        g.setFont(Arial6n);
        this.drawVersionCopyrightAndLogo(g, 10, 775);
        if (this.printModus < 4) {
            StringTokenizer t = new StringTokenizer(this.pageData, "|");
            try {
                g.setFont(Arial10n);
                String jobname = PSAuftrag.getMainJobName();
                g.drawString(jobname, 170, 40);
                g.drawString(jobname, 170, 282);
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
                Calendar calender = Calendar.getInstance();
                Date rightNow = calender.getTime();
                String date = formatter.format(rightNow);
                g.drawString(date, 170, 52);
                if (!PSAuftrag.cbformulare.cb_abs_einl && PSAuftrag.einlieferer.Strasse.length() > 0) {
                    String einlieferer = String.valueOf(PSAuftrag.einlieferer.Name) + ", " + PSAuftrag.einlieferer.Strasse + ", " + PSAuftrag.einlieferer.Land + " - " + PSAuftrag.einlieferer.PLZ + " " + PSAuftrag.einlieferer.Ort;
                    g.drawString(einlieferer, 170, 90);
                    String einlKNR = PSAuftrag.einlieferer.KDNR;
                    g.drawString(einlKNR, 170, 102);
                    String einlTelefon = PSAuftrag.einlieferer.Telefon;
                    g.drawString(einlTelefon, 170, 126);
                }
                String absender = String.valueOf(PSAuftrag.absender.Name) + ", " + PSAuftrag.absender.Strasse + ", " + PSAuftrag.absender.Land + " - " + PSAuftrag.absender.PLZ + " " + PSAuftrag.absender.Ort;
                String absKNR = PSAuftrag.absender.KDNR;
                g.drawString(absender, 170, 160);
                g.drawString(absKNR, 170, 172);
                String empfangsstelle = String.valueOf(PSAuftrag.getDepotName()) + ", " + PSAuftrag.getDepotZipTown();
                g.drawString(empfangsstelle, 170, 210);
                String depotPhone = PSAuftrag.getDepotPhone();
                g.drawString(depotPhone, 170, 234);
                String depotFax = PSAuftrag.getDepotFax();
                g.drawString(depotFax, 300, 234);
                String sendungsArt = "Postaktuell";
                g.drawString(sendungsArt, 170, 270);
                String abholDate = PSO.mainpanel.AE.getAbholTermin();
                g.drawString(abholDate, 170, 320);
                String abholAnschrift = PSO.mainpanel.AE.getAbholer();
                g.drawString(abholAnschrift, 170, 332);
                g.setFont(Arial6n);
                t.nextToken();
                t.nextToken();
                int rowCounter = 0;
                int colFactor = 176;
                int colCnt = 0;
                while (t.hasMoreTokens()) {
                    StringTokenizer stLine = new StringTokenizer(t.nextToken(), ";");
                    g.drawString(stLine.nextToken(), 12 + colFactor * colCnt, 389 + rowCounter * 12);
                    g.drawString(stLine.nextToken(), 52 + colFactor * colCnt, 389 + rowCounter * 12);
                    g.drawString(PSEnvironment.Format(stLine.nextToken(), "###,##0.00"), 87 + colFactor * colCnt, 389 + rowCounter++ * 12);
                    if (rowCounter % 26 != 0) continue;
                    ++colCnt;
                    rowCounter = 0;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }
}

