/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.printj2;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixBean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;
import prospektservice.PSEnvironment;

public class PrintBarcodes {
    int dpi = 100;
    String postalCompany = "";
    String frankingType = "";
    String submitterEKP = "";
    String productKey = "";
    String versionPPL = "";
    String idParticipation = "";
    String idSubmitter = "";
    String date = "";
    String option = "";
    String plz = "";
    String customerID = "";

    public PrintBarcodes() {
        this(150);
    }

    public PrintBarcodes(int dpiValue) {
        this.dpi = dpiValue;
        this.postalCompany = "DEA";
        this.frankingType = "J";
        this.productKey = "111";
        this.versionPPL = "18";
        this.idParticipation = "00";
        this.option = "02040";
        this.date = "0000";
        this.plz = "00000";
    }

    public BufferedImage CreatePaletteBarcode(String msg) {
        return this.CreatePaletteBarcode(msg, false);
    }

    public BufferedImage CreatePaletteBarcode(String msg, boolean fileoutput) {
        String filename = "";
        OutputStream out = null;
        BufferedImage img = null;
        try {
            Code39Bean bean = new Code39Bean();
            bean.setModuleWidth(UnitConv.in2mm((double)(1.0f / (float)this.dpi)));
            bean.setWideFactor(3.0);
            bean.doQuietZone(false);
            if (fileoutput) {
                filename = String.valueOf(PSEnvironment.getPSStdPath()) + "data/barcode_palette.jpg";
                File outputFile = new File(filename);
                if (outputFile.exists()) {
                    outputFile.delete();
                }
                out = new FileOutputStream(outputFile);
            } else {
                out = new ByteArrayOutputStream();
            }
            try {
                BitmapCanvasProvider canvas = new BitmapCanvasProvider(out, "image/jpeg", this.dpi, 12, false, 0);
                bean.generateBarcode((CanvasProvider)canvas, msg);
                canvas.finish();
                img = canvas.getBufferedImage();
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public BufferedImage CreateAZBarcode(String msg) {
        return this.CreateAZBarcode(msg, false);
    }

    public BufferedImage CreateAZBarcode(String msg, boolean fileoutput) {
        String filename = "";
        OutputStream out = null;
        BufferedImage img = null;
        try {
            DataMatrixBean bean = new DataMatrixBean();
            bean.setModuleWidth(UnitConv.in2mm((double)(10.85f / (float)this.dpi)));
            bean.setHeight(UnitConv.in2mm((double)(10.85f / (float)this.dpi)));
            bean.setQuietZone(0.0);
            bean.doQuietZone(false);
            if (fileoutput) {
                filename = String.valueOf(PSEnvironment.getPSStdPath()) + "data/barcode_az.jpg";
                File outputFile = new File(filename);
                if (outputFile.exists()) {
                    outputFile.delete();
                }
                out = new FileOutputStream(outputFile);
            } else {
                out = new ByteArrayOutputStream();
            }
            try {
                BitmapCanvasProvider canvas = new BitmapCanvasProvider(out, "image/jpeg", this.dpi, 12, false, 0);
                bean.generateBarcode((CanvasProvider)canvas, msg);
                canvas.finish();
                img = canvas.getBufferedImage();
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public String getBarcodeMessage() {
        String result = "";
        result = this.postalCompany;
        result = String.valueOf(result) + this.frankingType;
        result = String.valueOf(result) + this.doFormat(this.idParticipation, 2);
        result = String.valueOf(result) + this.doFormat(this.idSubmitter, 9);
        result = String.valueOf(result) + this.doFormat(this.submitterEKP, 8);
        result = String.valueOf(result) + this.doFormat(this.productKey, 5);
        result = String.valueOf(result) + this.doFormat(this.versionPPL, 3);
        result = String.valueOf(result) + this.date;
        result = String.valueOf(result) + this.option;
        result = String.valueOf(result) + this.doFormat(this.plz, 5);
        result = String.valueOf(result) + "~";
        result = String.valueOf(result) + this.doFormat(this.customerID, 15);
        return result;
    }

    public void setDate(String value) {
        this.date = this.doDateFormat(value);
    }

    public void setPLZ(String value) {
        if (value.trim().length() > 5) {
            value = value.substring(0, 5).trim();
        }
        this.plz = value;
    }

    public void setSubmitter(String value) {
        this.submitterEKP = value;
    }

    public void setIdSubmitter(String value) {
        String partDateTime = "";
        String partDate = "";
        String partTime = "";
        String partUser = "";
        Object locDate = null;
        partDate = value;
        partTime = "";
        this.idSubmitter = String.valueOf(partDate) + partTime;
    }

    public void setIdParticipation(String value) {
        if (value.trim().length() >= 4) {
            value = value.substring(value.length() - 2, value.length());
        }
        this.idParticipation = value;
    }

    public void setCustomerID(String value) {
        String tmp = "";
        Date locDate = null;
        if (value.trim().length() > 14) {
            tmp = value.substring(value.length() - 14, value.length());
            locDate = PSEnvironment.getDate(tmp, "ddMMyyyyHHmmss");
            SimpleDateFormat format = new SimpleDateFormat("DDD");
            tmp = format.format(locDate);
            format = new SimpleDateFormat("y");
            tmp = String.valueOf(tmp) + format.format(locDate).substring(1, 2);
            format = new SimpleDateFormat("HHmmss");
            tmp = String.valueOf(tmp) + format.format(locDate);
            tmp = String.valueOf(value.substring(0, value.length() - 14)) + tmp;
        }
        this.customerID = tmp;
    }

    public String doFormat(String value, int len) {
        String result = "";
        if (value.trim().length() < len) {
            result = "00000000000000000000" + value;
            result = result.substring(result.length() - len, result.length());
        } else {
            result = value.substring(0, len);
        }
        return result;
    }

    private String doDateFormat(String value) {
        return this.doDateFormat(value, "dd.MM.yyyy", true);
    }

    private String doDateFormat(String value, String formater, boolean inclYear) {
        String result = "";
        Date locDate = null;
        String calcDate = "";
        try {
            SimpleDateFormat format = new SimpleDateFormat(formater);
            locDate = format.parse(value);
            if (inclYear) {
                format = new SimpleDateFormat("y");
                calcDate = format.format(locDate);
                calcDate = calcDate.substring(1, 2);
            }
            format = new SimpleDateFormat("DDD");
            result = calcDate = String.valueOf(format.format(locDate)) + calcDate;
        }
        catch (Throwable ex) {
            result = "0000";
        }
        return result;
    }

    public BufferedImage createELBarcode(String barCodeData, boolean fileOutput) {
        String filename = "";
        OutputStream out = null;
        BufferedImage img = null;
        try {
            this.dpi = 300;
            DataMatrixBean bean = new DataMatrixBean();
            bean.setMinSize(new Dimension(104, 104));
            bean.setMaxSize(new Dimension(104, 104));
            bean.setModuleWidth(0.423333);
            bean.setHeight(0.423333);
            bean.setQuietZone(0.0);
            bean.doQuietZone(false);
            if (fileOutput) {
                filename = String.valueOf(PSEnvironment.getPSStdPath()) + "data/barcode_el.jpg";
                File outputFile = new File(filename);
                if (outputFile.exists()) {
                    outputFile.delete();
                }
                out = new FileOutputStream(outputFile);
            } else {
                out = new ByteArrayOutputStream();
            }
            try {
                BitmapCanvasProvider canvas = new BitmapCanvasProvider(out, "image/jpeg", this.dpi, 12, false, 0);
                bean.generateBarcode((CanvasProvider)canvas, barCodeData);
                canvas.finish();
                img = canvas.getBufferedImage();
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public BufferedImage createAzDMC(String barCodeData) {
        ByteArrayOutputStream out = null;
        BufferedImage img = null;
        try {
            this.dpi = 300;
            DataMatrixBean bean = new DataMatrixBean();
            bean.setMinSize(new Dimension(36, 36));
            bean.setMaxSize(new Dimension(36, 36));
            bean.setModuleWidth(0.423333);
            bean.setHeight(0.423333);
            bean.setQuietZone(0.0);
            bean.doQuietZone(false);
            out = new ByteArrayOutputStream();
            try {
                BitmapCanvasProvider canvas = new BitmapCanvasProvider((OutputStream)out, "image/jpeg", this.dpi, 12, false, 0);
                bean.generateBarcode((CanvasProvider)canvas, barCodeData);
                canvas.finish();
                img = canvas.getBufferedImage();
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }
}

