/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.karte;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PSImageIcon;
import prospektservice.base.TBJButton;
import prospektservice.karte.MapNavigator;
import prospektservice.layoutmanager.CellLayout;

public class frmNavigation
extends JDialog {
    private static final long serialVersionUID = 3257284712572924471L;
    private static final int WINWIDTH = PSEnvironment.isMacOSPlatform() ? 155 : 150;
    private static final int WINHEIGHT = 270;
    private static final int MAPWIDTH = 120;
    private static final int MAPHEIGHT = 180;
    private static ResourceBundle localProperty;
    private static int navplz;
    private PSO pso;
    private JPanel kartenpanel;
    private TBJButton cmdPLZ;
    private TBJButton cmdKreis;
    private JSlider zoomSlider;
    private boolean helperVisible = false;
    private MapNavigator mapNavigator;
    private JLayeredPane layeredPane;
    private int firstkey = 0;
    private int ovlIDOrte;

    static {
        navplz = -1;
    }

    public frmNavigation(PSO mainpanel) {
        super(mainpanel, "", false);
        this.pso = mainpanel;
        this.getContentPane().setLayout(new CellLayout());
        int x = this.pso.getLocation().x;
        int y = this.pso.getLocation().y + 155;
        this.setBounds(x, y, WINWIDTH, 270);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ((frmNavigation)frmNavigation.this).pso.Navigation_On = false;
            }
        });
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setMinimumSize(new Dimension(120, 180));
        this.cmdPLZ = new TBJButton(new PSImageIcon("images/pkarte_nor.gif"), (Icon)new PSImageIcon("images/pkarte_akt.gif"));
        this.cmdPLZ.setDisabledIcon(new PSImageIcon("images/pkarte_dis.gif"));
        this.cmdPLZ.setMinimumSize(new Dimension(32, 32));
        this.cmdPLZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PSEnvironment.aktiveKarte != 10) {
                    PSEnvironment.aktiveKarte = 10;
                    frmNavigation.this.pso.loadKarte();
                    if (PSO.mainpanel.mapLegend != null) {
                        PSO.mainpanel.mapLegend.setLegendeTabsEnabled();
                    }
                }
            }
        });
        this.cmdKreis = new TBJButton(new PSImageIcon("images/kkarte_nor.gif"), (Icon)new PSImageIcon("images/kkarte_akt.gif"));
        this.cmdKreis.setDisabledIcon(new PSImageIcon("images/kkarte_dis.gif"));
        this.cmdKreis.setMinimumSize(new Dimension(32, 32));
        this.cmdKreis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PSEnvironment.aktiveKarte != 11) {
                    PSEnvironment.aktiveKarte = 11;
                    frmNavigation.this.pso.loadKarte();
                    if (PSO.mainpanel.mapLegend != null) {
                        PSO.mainpanel.mapLegend.setLegendeTabsEnabled();
                    }
                }
            }
        });
        this.zoomSlider = new JSlider();
        this.zoomSlider.setOrientation(0);
        this.zoomSlider.setMinimumSize(new Dimension(120, 20));
        this.zoomSlider.setMaximum(1000);
        this.zoomSlider.setMinimum(1);
        this.zoomSlider.setInverted(true);
        this.zoomSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                frmNavigation.this.pso.setZoomedBySlider(true);
                frmNavigation.this.pso.setZoomedBySlider(false);
            }
        });
        this.getContentPane().add("x=1 y=1 w=2 h=1 f=n a=c wx=0 wy=50", this.layeredPane);
        this.getContentPane().add("x=1 y=2 w=2 h=1 f=n a=c wx=0 wy=50", this.zoomSlider);
        this.getContentPane().add("x=2 y=3 w=1 h=1 f=n a=c wx=0 wy=50", this.cmdKreis);
        this.getContentPane().add("x=1 y=3 w=1 h=1 f=n a=c wx=0 wy=50", this.cmdPLZ);
        this.setLanguage();
        this.setcmdKreiskarte(PSO.Modus != 3 && PSO.Modus != 4 && PSO.Modus != 5);
    }

    public void setLanguage() {
        localProperty = ResourceBundle.getBundle("properties.frmNavigation", PSUser.getLanguage());
        this.setTitle(localProperty.getString("titel"));
        this.cmdPLZ.setToolTipText(localProperty.getString("tooltip2"));
        this.cmdKreis.setToolTipText(localProperty.getString("tooltip3"));
        this.zoomSlider.setToolTipText(localProperty.getString("zoomSliderTT"));
    }

    public void setcmdKreiskarte(boolean value) {
        this.cmdKreis.setEnabled(value);
    }

    public void setSelectedArea(int plzregion) {
        if (plzregion == 0) {
            plzregion = 10;
        }
        this.firstkey = plzregion;
    }

    public void resetNavkarte() {
    }

    @Override
    public void setVisible(boolean value) {
        if (value && this.mapNavigator != null && !this.helperVisible) {
            this.layeredPane.add((Component)this.mapNavigator, JLayeredPane.MODAL_LAYER);
            this.helperVisible = true;
        }
        super.setVisible(value);
    }

    private void initNavigator() {
        this.layeredPane.add((Component)this.mapNavigator, JLayeredPane.MODAL_LAYER);
        this.layeredPane.invalidate();
        this.layeredPane.repaint();
        this.helperVisible = true;
    }

    public void updateZoomSlider() {
    }
}

