/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PSJCheckBox;
import prospektservice.base.PSJRadioButton;
import prospektservice.base.PamDialog;
import prospektservice.dialog.DlgChooseDirectory;

public class frmPrinterSettings
extends PamDialog {
    private static final long serialVersionUID = 3257567308653212726L;
    private static final int WIDTH = 380;
    private static final int HEIGHT = 285;
    private PSO pso;
    private static ResourceBundle localProperty;
    private JPanel centerPanel;
    private JLabel lblInfo;
    private PSJRadioButton radioDruckDefaultPrinter;
    private PSJRadioButton radioDruckPdf;
    private JButton btnSetPrinter;
    private PSJCheckBox chkOpenPDF;
    private PSJCheckBox chkSplitPdf;
    private JLabel lblPdfOutputDir;
    private JTextField txtPdfOutputDir;
    private JButton btnPdfOutputDir;
    private JPanel southPanel;
    private JLabel lblPrintToFileDir;
    private JTextField txtPrintToFileDir;
    private JButton btnOK;
    private JButton btnCancel;
    private boolean printToPdf;
    private boolean openPdf;
    private boolean splitPdf;
    private JButton btnPrintToFileDir;

    public frmPrinterSettings(PSO mainpanel, JFrame mainform) {
        super(mainform, "", true);
        this.pso = mainpanel;
        this.setDefaultCloseOperation(2);
        localProperty = ResourceBundle.getBundle("properties.frmPrinterSettings", PSUser.getLanguage());
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(localProperty.getString("Title"));
        this.setSize(380, PSUser.isDruckInDateiAktiv() ? 285 : 255);
        this.setFont(PSEnvironment.Arial10Table);
        this.setResizable(false);
        this.setLocationRelativeTo(mainform);
        this.printToPdf = this.pso.getPsc().getPrintToPdf();
        this.openPdf = this.pso.getPsc().getOpenPdf();
        this.splitPdf = this.pso.getPsc().isAutoSplitEnabled();
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(null);
        ButtonGroup groupSettings = new ButtonGroup();
        this.lblInfo = new JLabel(localProperty.getString("Label1"));
        this.lblInfo.setBounds(10, 10, 200, 15);
        this.centerPanel.add(this.lblInfo);
        this.radioDruckDefaultPrinter = new PSJRadioButton(localProperty.getString("radioDruckDefaultPrinter"));
        this.radioDruckDefaultPrinter.setBounds(10, 30, 180, 18);
        this.radioDruckDefaultPrinter.setSelected(!this.printToPdf);
        this.radioDruckDefaultPrinter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                frmPrinterSettings.this.btnSetPrinter.setEnabled(e.getStateChange() == 1);
            }
        });
        groupSettings.add(this.radioDruckDefaultPrinter);
        this.centerPanel.add(this.radioDruckDefaultPrinter);
        this.btnSetPrinter = new JButton(localProperty.getString("btnSetPrinter"));
        this.btnSetPrinter.setBounds(195, 28, 170, 25);
        this.btnSetPrinter.setEnabled(!this.printToPdf);
        this.btnSetPrinter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrinterJob prJob = PrinterJob.getPrinterJob();
                if (prJob.printDialog()) {
                    frmPrinterSettings.this.pso.getPsc().setPrintService(prJob.getPrintService());
                    PSEnvironment.setPSClientProperty("PS.SelectedPrinter", prJob.getPrintService().getName());
                }
            }
        });
        if (PSEnvironment.isWindowsPlatform()) {
            this.centerPanel.add(this.btnSetPrinter);
        }
        this.radioDruckPdf = new PSJRadioButton(localProperty.getString("radioDruckPdf"));
        this.radioDruckPdf.setBounds(10, 60, 240, 18);
        this.radioDruckPdf.setSelected(this.printToPdf);
        this.radioDruckPdf.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                frmPrinterSettings.this.chkOpenPDF.setEnabled(e.getStateChange() == 1);
                frmPrinterSettings.this.chkSplitPdf.setEnabled(e.getStateChange() == 1);
                frmPrinterSettings.this.btnPdfOutputDir.setEnabled(e.getStateChange() == 1);
                frmPrinterSettings.this.txtPdfOutputDir.setEnabled(e.getStateChange() == 1);
                frmPrinterSettings.this.pso.getPsc().setPrintToPdf(true);
                PSEnvironment.setPSClientProperty("PS.PrintToPDF", e.getStateChange() == 1 ? "1" : "0");
            }
        });
        groupSettings.add(this.radioDruckPdf);
        this.centerPanel.add(this.radioDruckPdf);
        this.chkOpenPDF = new PSJCheckBox(localProperty.getString("chkOpenPDF"));
        this.chkOpenPDF.setAlignmentX(0.0f);
        this.chkOpenPDF.setBounds(30, 85, 210, 18);
        this.chkOpenPDF.setEnabled(this.printToPdf);
        this.chkOpenPDF.setSelected(this.openPdf);
        this.centerPanel.add(this.chkOpenPDF);
        this.chkSplitPdf = new PSJCheckBox(localProperty.getString("chkSplitPdf"));
        this.chkSplitPdf.setAlignmentX(0.0f);
        this.chkSplitPdf.setBounds(30, 110, 250, 18);
        this.chkSplitPdf.setEnabled(this.printToPdf);
        this.chkSplitPdf.setSelected(this.splitPdf);
        this.centerPanel.add(this.chkSplitPdf);
        this.lblPdfOutputDir = new JLabel(localProperty.getString("lblDefaultPdfDir"));
        this.lblPdfOutputDir.setBounds(32, 135, 160, 18);
        this.centerPanel.add(this.lblPdfOutputDir);
        this.txtPdfOutputDir = new JTextField("");
        this.txtPdfOutputDir.setBounds(195, 135, 140, 25);
        this.txtPdfOutputDir.setText(PSEnvironment.getPSClientProperty("PS.PdfOutputDir", String.valueOf(PSEnvironment.getPSPath()) + "dokumente"));
        this.centerPanel.add(this.txtPdfOutputDir);
        this.btnPdfOutputDir = new JButton("...");
        this.btnPdfOutputDir.setBounds(330, 135, 30, 25);
        this.btnPdfOutputDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File defaultDir = DlgChooseDirectory.chooseDirectory(frmPrinterSettings.this.pso);
                if (defaultDir != null) {
                    frmPrinterSettings.this.txtPdfOutputDir.setText(defaultDir.getAbsolutePath());
                }
                frmPrinterSettings.this.toFront();
            }
        });
        this.centerPanel.add(this.btnPdfOutputDir);
        this.lblPrintToFileDir = new JLabel(localProperty.getString("lblPrintToFileDir"));
        this.lblPrintToFileDir.setBounds(10, 170, 240, 18);
        if (PSUser.isDruckInDateiAktiv()) {
            this.centerPanel.add(this.lblPrintToFileDir);
        }
        this.txtPrintToFileDir = new JTextField();
        this.txtPrintToFileDir.setBounds(10, 190, 322, 25);
        this.txtPrintToFileDir.setText(PSEnvironment.getPSClientProperty("PS.ExportPath", ""));
        if (PSUser.isDruckInDateiAktiv()) {
            this.centerPanel.add(this.txtPrintToFileDir);
        }
        this.btnPrintToFileDir = new JButton("...");
        this.btnPrintToFileDir.setBounds(330, 190, 30, 25);
        this.btnPrintToFileDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File defaultDir = DlgChooseDirectory.chooseDirectory(frmPrinterSettings.this.pso);
                if (defaultDir != null) {
                    frmPrinterSettings.this.txtPrintToFileDir.setText(defaultDir.getAbsolutePath());
                }
                frmPrinterSettings.this.toFront();
            }
        });
        if (PSUser.isDruckInDateiAktiv()) {
            this.centerPanel.add(this.btnPrintToFileDir);
        }
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.southPanel = new JPanel();
        this.southPanel.setLayout(new FlowLayout(2));
        this.btnOK = new JButton(localProperty.getString("btnOK"));
        this.btnOK.setPreferredSize(new Dimension(90, 25));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block4: {
                    String printToFileDir = frmPrinterSettings.this.txtPrintToFileDir.getText();
                    frmPrinterSettings.this.pso.getPsc().setPrintToPdf(frmPrinterSettings.this.radioDruckPdf.isSelected());
                    frmPrinterSettings.this.pso.getPsc().setOpenPdf(frmPrinterSettings.this.chkOpenPDF.isSelected());
                    frmPrinterSettings.this.pso.getPsc().setAutoSplitEnabled(frmPrinterSettings.this.chkSplitPdf.isSelected());
                    PSEnvironment.setPSClientProperty("PS.OpenPDF", frmPrinterSettings.this.chkOpenPDF.isSelected() ? "1" : "0");
                    PSEnvironment.setPSClientProperty("PS.AutoSplitPDF", frmPrinterSettings.this.chkSplitPdf.isSelected() ? "1" : "0");
                    PSEnvironment.setPSClientProperty("PS.PdfOutputDir", frmPrinterSettings.this.txtPdfOutputDir.getText());
                    PSEnvironment.setPSClientProperty("PS.ExportPath", printToFileDir);
                    try {
                        File f;
                        if (printToFileDir.length() <= 0 || (f = new File(printToFileDir)).exists()) break block4;
                        if (JOptionPane.showConfirmDialog(frmPrinterSettings.this.pso, String.valueOf(localProperty.getString("PtfQuestionPt1")) + printToFileDir + localProperty.getString("PtfQuestionPt2")) == 0) {
                            boolean success = f.mkdirs();
                            if (!success) {
                                throw new Exception("Something went wrong...");
                            }
                            break block4;
                        }
                        return;
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(frmPrinterSettings.this.pso, localProperty.getString("PtfErrMsg"));
                        return;
                    }
                }
                frmPrinterSettings.this.dispose();
            }
        });
        this.southPanel.add(this.btnOK);
        this.btnCancel = new JButton(localProperty.getString("btnCancel"));
        this.btnCancel.setPreferredSize(new Dimension(90, 25));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frmPrinterSettings.this.dispose();
            }
        });
        this.southPanel.add(this.btnCancel);
        this.getContentPane().add((Component)this.southPanel, "South");
        this.setVisible(true);
    }
}

