/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import prospektservice.Feedback;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PSFileFilter;
import prospektservice.base.PSImageIcon;
import prospektservice.base.PSJCheckBox;
import prospektservice.base.PSJRadioButton;
import prospektservice.base.PSJTable;
import prospektservice.base.PamDialog;
import prospektservice.base.progress.ProgressEvent;
import prospektservice.base.progress.VolumeProgressDialog;
import prospektservice.datamodels.PsoDefaultTableModel;
import prospektservice.dialog.frmHelp;

public class DlgTextImport
extends PamDialog {
    private static final long serialVersionUID = 3905239048103802676L;
    private static final int WIDTH = 650;
    private static final int HEIGHT = 450;
    private static final int PACKAGE_SIZE = 500;
    private static ResourceBundle localProperty;
    private DlgTextImport instance = this;
    private JButton btnCancel;
    private JButton btnHelp;
    private JButton btnAbort;
    private JButton btnOk;
    private JPanel btnPanel;
    private JLabel lblHeadline;
    private JLabel lblLogo;
    private JLabel lblDPAGLogo;
    private JPanel sidePanel;
    private JPanel topPanel;
    private JLabel lblExplanation;
    private JPanel panelDatatype;
    private PSJRadioButton optSeparated;
    private PSJRadioButton optFixedWidth;
    private PSJCheckBox chkEAImport;
    private int actPane = 0;
    private PSO pso;
    private Component glasspane;
    private JPanel workPanel;
    private String importFileName = "";
    private ActionListener cmdOKAction;
    private ActionListener cmdCancelActionListener;
    private ActionListener cmdHelpActionListener;
    private PSJTable previewTable;
    private JScrollPane tablePane;
    private PsoDefaultTableModel DefTableModel = new PsoDefaultTableModel();
    private Rectangle wndRect = null;
    private boolean isCSV = false;
    private boolean hasColumnHeader = false;
    private boolean isFixedWidth = false;
    private String separator = "";
    private Vector<String> lineStore;
    private boolean separatedData = false;
    private int plzColumn = 0;
    private int otColumn = 0;
    private int zusatzColumn;
    private JPanel panelSeparator;
    private PSJRadioButton optComma;
    private PSJRadioButton optSemi;
    private PSJRadioButton optTab;
    private PSJRadioButton optOther;
    private JTextField txtSeparator;
    private PSJCheckBox chkHasColumnHeader;
    private JPanel panelColumnSelection;
    private JLabel lblColSelection2;
    private JComboBox cmbColumns1;
    private JComboBox cmbColumns2;
    private long lineCount;
    private VolumeProgressDialog progress;
    private int totalCnt;
    private PSJRadioButton optOrtsteile;
    private PSJRadioButton optPLZ;
    private boolean isPLZImport = true;
    private JLabel lblPSOLogo;
    private boolean confirmed = false;
    private boolean isEAImport = false;
    private JLabel lblColSelection;
    private PSJCheckBox chkZusatzFeld;
    private JComboBox cmbXtraColumns;

    public DlgTextImport(PSO mainpanel) {
        super(mainpanel, "", true);
        this.pso = mainpanel;
        localProperty = ResourceBundle.getBundle("properties.DlgTextImport", PSUser.getLanguage());
        this.setTitle(localProperty.getString("Title"));
        this.setSize(650, 450);
        this.setLocationRelativeTo(mainpanel);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.confirmed = this.showFileChooser();
        this.isEAImport = this.pso.AE.postwurfan == 4;
    }

    @Override
    public void setVisible(boolean flag) {
        if (this.confirmed) {
            this.readImportFile();
            if (this.lineCount == 0L) {
                Feedback.showMessage(this, 35);
                this.dispose();
            } else {
                this.flipPanel(this.isCSV ? (this.actPane = this.actPane + 1) : 0, true);
                super.setVisible(flag);
            }
        } else if (flag) {
            this.dispose();
        }
    }

    public void flipPanel(int step, boolean forward) {
        if (PSEnvironment.DEBUG) {
            System.out.println("flipping panel -> " + step);
        }
        if (step < 0 || this.isCSV && step == 0) {
            if (PSEnvironment.DEBUG) {
                System.out.println("calling dispose!");
            }
            this.dispose();
            return;
        }
        if (step > 5) {
            return;
        }
        this.getContentPane().remove(this.workPanel);
        this.workPanel.removeAll();
        switch (step) {
            case 0: {
                this.buildColumnPanel();
                break;
            }
            case 1: {
                this.buildSeparatorPanel();
                break;
            }
            case 2: {
                this.buildImportColumnPanel();
                break;
            }
            case 3: {
                this.buildResultsPanel();
                break;
            }
            case 4: {
                this.dispose();
            }
        }
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.workPanel = new JPanel();
        this.workPanel.setLayout(new AbsoluteLayout());
        this.sidePanel = new JPanel();
        this.sidePanel.setLayout(new AbsoluteLayout());
        this.sidePanel.setBackground(new Color(247, 197, 0));
        this.lblDPAGLogo = new JLabel();
        this.lblDPAGLogo.setIcon(new PSImageIcon("./images/wizardlogo.gif"));
        this.lblDPAGLogo.setVerticalAlignment(1);
        this.sidePanel.add((Component)this.lblDPAGLogo, new AbsoluteConstraints(0, 0, 140, 60));
        this.lblPSOLogo = new JLabel();
        this.lblPSOLogo.setIcon(new PSImageIcon("./images/pso_logo.gif"));
        this.lblPSOLogo.setVerticalAlignment(1);
        this.sidePanel.add((Component)this.lblPSOLogo, new AbsoluteConstraints(2, 365, 140, 18));
        this.workPanel.add((Component)this.sidePanel, new AbsoluteConstraints(0, 0, 140, 394));
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new AbsoluteLayout());
        this.topPanel.setBackground(new Color(255, 255, 255));
        this.topPanel.setMaximumSize(new Dimension(390, 140));
        this.topPanel.setMinimumSize(new Dimension(390, 140));
        this.topPanel.setPreferredSize(new Dimension(300, 100));
        this.lblExplanation = new JLabel();
        this.lblExplanation.setFont(new Font("Tahoma", 0, 11));
        this.lblExplanation.setText("<html>" + localProperty.getString("stepImportTypeExplanation") + "</html>");
        this.lblExplanation.setBackground(Color.white);
        this.lblExplanation.setVerticalAlignment(1);
        this.topPanel.add((Component)this.lblExplanation, new AbsoluteConstraints(144, 38, 324, 62));
        this.lblHeadline = new JLabel();
        this.lblHeadline.setBackground(new Color(255, 255, 255));
        this.lblHeadline.setFont(new Font("Tahoma", 1, 11));
        this.lblHeadline.setText(localProperty.getString("stepImportTypeHeadline"));
        this.topPanel.add((Component)this.lblHeadline, new AbsoluteConstraints(146, 6, -1, -1));
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout(1, 10, 5));
        this.btnPanel.setBorder(new EtchedBorder());
        this.btnHelp = new JButton();
        this.btnHelp.setFont(new Font("Tahoma", 0, 11));
        this.btnHelp.setText(localProperty.getString("Button1"));
        this.cmdHelpActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frmHelp wnd = frmHelp.getInstance("hilfe/hilfe_txtimport" + (DlgTextImport.this.actPane + 1) + ".html", DlgTextImport.this.instance);
                wnd.setSize(800, 600);
            }
        };
        this.btnHelp.addActionListener(this.cmdHelpActionListener);
        this.btnPanel.add(this.btnHelp);
        this.btnAbort = new JButton();
        this.btnAbort.setFont(new Font("Tahoma", 0, 11));
        this.btnAbort.setText(localProperty.getString("Button3"));
        this.btnAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTextImport.this.dispose();
            }
        });
        this.btnPanel.add(this.btnAbort);
        this.btnCancel = new JButton();
        this.btnCancel.setFont(new Font("Tahoma", 0, 11));
        this.btnCancel.setText(localProperty.getString("Button2"));
        this.cmdCancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgTextImport.this.btnCancelActionPerformed(evt);
            }
        };
        this.btnCancel.addActionListener(this.cmdCancelActionListener);
        this.btnPanel.add(this.btnCancel);
        this.btnOk = new JButton();
        this.btnOk.setFont(new Font("Tahoma", 0, 11));
        this.btnOk.setText(localProperty.getString("Button4"));
        this.cmdOKAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgTextImport.this.btnOkActionPerformed(evt);
            }
        };
        this.btnOk.addActionListener(this.cmdOKAction);
        this.btnPanel.add(this.btnOk);
        this.getContentPane().add((Component)this.btnPanel, new AbsoluteConstraints(2, 386, 648, -1));
    }

    private void buildColumnPanel() {
        this.workPanel.add((Component)this.sidePanel, new AbsoluteConstraints(0, 0, 140, 394));
        this.workPanel.add((Component)this.topPanel, new AbsoluteConstraints(0, 0, 500, 140));
        this.panelDatatype = new JPanel();
        this.panelDatatype.setLayout(new AbsoluteLayout());
        this.panelDatatype.setBorder(new TitledBorder(localProperty.getString("panelDatatype")));
        this.panelDatatype.setBackground(Color.white);
        ButtonGroup bt = new ButtonGroup();
        this.optSeparated = new PSJRadioButton(localProperty.getString("optSeparated"));
        this.optSeparated.setBackground(Color.white);
        this.optSeparated.setSelected(this.separatedData);
        this.optSeparated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTextImport.this.isFixedWidth = false;
            }
        });
        bt.add(this.optSeparated);
        this.panelDatatype.add((Component)this.optSeparated, new AbsoluteConstraints(4, 20, -1, -1));
        JLabel lblSeparated = new JLabel(localProperty.getString("lblSeparated"));
        this.panelDatatype.add((Component)lblSeparated, new AbsoluteConstraints(90, 23, -1, -1));
        this.optFixedWidth = new PSJRadioButton(localProperty.getString("optFixedWidth"));
        this.optFixedWidth.setBackground(Color.white);
        this.optFixedWidth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DlgTextImport.this.isFixedWidth = e.getStateChange() == 1;
                DlgTextImport.this.separator = " ";
            }
        });
        this.optFixedWidth.setSelected(!this.separatedData);
        bt.add(this.optFixedWidth);
        this.panelDatatype.add((Component)this.optFixedWidth, new AbsoluteConstraints(4, 40, -1, -1));
        JLabel lblFixedWidth = new JLabel(localProperty.getString("lblFixedWidth"));
        this.panelDatatype.add((Component)lblFixedWidth, new AbsoluteConstraints(90, 43, -1, -1));
        JPanel panelPreview = new JPanel();
        panelPreview.setLayout(new AbsoluteLayout());
        panelPreview.setBorder(new TitledBorder(localProperty.getString("previewPanelTitle")));
        panelPreview.setBackground(Color.white);
        this.tablePane = new JScrollPane();
        this.previewTable = new PSJTable();
        this.previewTable.getTableHeader().setReorderingAllowed(false);
        this.previewTable.getTableHeader().setResizingAllowed(true);
        PsoDefaultTableModel dtm = new PsoDefaultTableModel();
        dtm.setColumnCount(1);
        int i = 0;
        while (i < this.lineStore.size()) {
            String line = this.lineStore.elementAt(i);
            Object[] tmp = new Object[]{line};
            dtm.addRow(tmp);
            ++i;
        }
        this.previewTable.setModel(dtm);
        this.tablePane.getViewport().add(this.previewTable);
        panelPreview.add((Component)this.tablePane, new AbsoluteConstraints(10, 20, 450, 120));
        this.workPanel.setBackground(Color.white);
        this.workPanel.add((Component)this.panelDatatype, new AbsoluteConstraints(144, 140, 470, 75));
        this.workPanel.add((Component)panelPreview, new AbsoluteConstraints(144, 230, 470, 150));
        this.getContentPane().add((Component)this.workPanel, new AbsoluteConstraints(0, 0, 650, 394));
    }

    private void buildSeparatorPanel() {
        this.lblExplanation.setText("<html>" + localProperty.getString("stepSeparatorExplanation") + "</html>");
        this.lblHeadline.setText(localProperty.getString("stepSeparatorHeadline"));
        this.topPanel.add((Component)this.lblHeadline, new AbsoluteConstraints(146, 6, -1, -1));
        this.workPanel.add((Component)this.sidePanel, new AbsoluteConstraints(0, 0, 140, 394));
        this.workPanel.add((Component)this.topPanel, new AbsoluteConstraints(0, 0, 500, 100));
        this.panelSeparator = new JPanel();
        this.panelSeparator.setLayout(new AbsoluteLayout());
        this.panelSeparator.setBorder(new TitledBorder(localProperty.getString("sepPanelTitle")));
        this.panelSeparator.setBackground(Color.white);
        ButtonGroup bg = new ButtonGroup();
        this.optComma = new PSJRadioButton(localProperty.getString("optSeparatorComma"));
        this.optComma.setEnabled(!this.isCSV && !this.isFixedWidth);
        this.optComma.setBackground(Color.white);
        if (this.separator.equals(",")) {
            this.optComma.setSelected(true);
        }
        this.optComma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTextImport.this.txtSeparator.setEnabled(false);
                DlgTextImport.this.separator = ",";
                DlgTextImport.this.updatePreview();
            }
        });
        bg.add(this.optComma);
        this.panelSeparator.add((Component)this.optComma, new AbsoluteConstraints(4, 20, -1, -1));
        this.optSemi = new PSJRadioButton(localProperty.getString("optSeparatorSemi"));
        this.optSemi.setBackground(Color.white);
        this.optSemi.setEnabled(!this.isCSV && !this.isFixedWidth);
        this.optSemi.setSelected(this.isCSV || this.separator.equals(";"));
        this.optSemi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTextImport.this.txtSeparator.setEnabled(false);
                DlgTextImport.this.separator = ";";
                DlgTextImport.this.updatePreview();
            }
        });
        bg.add(this.optSemi);
        this.panelSeparator.add((Component)this.optSemi, new AbsoluteConstraints(205, 20, -1, -1));
        this.optTab = new PSJRadioButton(localProperty.getString("optSeparatorTab"));
        this.optTab.setBackground(Color.white);
        this.optTab.setEnabled(!this.isCSV && !this.isFixedWidth);
        if (this.separator.equals("\t")) {
            this.optTab.setSelected(true);
        }
        this.optTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTextImport.this.txtSeparator.setEnabled(false);
                DlgTextImport.this.separator = "\t";
                DlgTextImport.this.updatePreview();
            }
        });
        bg.add(this.optTab);
        this.panelSeparator.add((Component)this.optTab, new AbsoluteConstraints(4, 45, -1, -1));
        this.optOther = new PSJRadioButton(localProperty.getString("optSeparatorOther"));
        this.optOther.setBackground(Color.white);
        this.optOther.setEnabled(!this.isCSV && !this.isFixedWidth);
        boolean isOther = !this.separator.equals(",") && !this.separator.equals(";") && !this.separator.equals("\t") && this.separator.length() > 0 && !this.isFixedWidth;
        this.optOther.setSelected(isOther);
        this.optOther.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTextImport.this.txtSeparator.setEnabled(true);
            }
        });
        bg.add(this.optOther);
        this.panelSeparator.add((Component)this.optOther, new AbsoluteConstraints(205, 45, -1, -1));
        this.txtSeparator = new JTextField();
        this.txtSeparator.setEnabled(false);
        if (isOther) {
            this.txtSeparator.setText(";");
        }
        this.txtSeparator.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (DlgTextImport.this.txtSeparator.getText().length() >= 1) {
                    e.consume();
                } else {
                    DlgTextImport.this.separator = "" + e.getKeyChar();
                    DlgTextImport.this.updatePreview();
                }
            }
        });
        this.panelSeparator.add((Component)this.txtSeparator, new AbsoluteConstraints(350, 45, 20, 20));
        JPanel panelHeader = new JPanel();
        panelHeader.setLayout(new AbsoluteLayout());
        panelHeader.setBackground(Color.white);
        this.chkHasColumnHeader = new PSJCheckBox(localProperty.getString("chkHasColumnHeader"));
        this.chkHasColumnHeader.setBackground(Color.white);
        this.chkHasColumnHeader.setSelected(this.hasColumnHeader);
        this.chkHasColumnHeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTextImport.this.hasColumnHeader = DlgTextImport.this.chkHasColumnHeader.isSelected();
                DlgTextImport.this.updatePreview();
            }
        });
        panelHeader.add((Component)this.chkHasColumnHeader, new AbsoluteConstraints(3, 5, -1, -1));
        JPanel panelPreview = new JPanel();
        panelPreview.setLayout(new AbsoluteLayout());
        panelPreview.setBorder(new TitledBorder(localProperty.getString("previewPanelTitle")));
        panelPreview.setBackground(Color.white);
        this.tablePane = new JScrollPane();
        this.previewTable = new PSJTable();
        this.previewTable.getTableHeader().setReorderingAllowed(false);
        this.previewTable.getTableHeader().setResizingAllowed(true);
        PsoDefaultTableModel dtm = new PsoDefaultTableModel();
        dtm.setColumnCount(1);
        int i = 0;
        while (i < this.lineStore.size()) {
            String line = this.lineStore.elementAt(i);
            Object[] tmp = new Object[]{line};
            dtm.addRow(tmp);
            ++i;
        }
        this.previewTable.setModel(dtm);
        this.tablePane.getViewport().add(this.previewTable);
        panelPreview.add((Component)this.tablePane, new AbsoluteConstraints(10, 20, 450, 120));
        this.workPanel.setBackground(Color.white);
        this.workPanel.add((Component)this.panelSeparator, new AbsoluteConstraints(144, 100, 470, 75));
        this.workPanel.add((Component)panelHeader, new AbsoluteConstraints(144, 180, 470, 40));
        this.workPanel.add((Component)panelPreview, new AbsoluteConstraints(144, 230, 470, 150));
        this.getContentPane().add((Component)this.workPanel, new AbsoluteConstraints(0, 0, 650, 394));
        if (this.isCSV || this.isFixedWidth || this.separator.length() > 0) {
            this.updatePreview();
        }
        this.btnOk.setEnabled(true);
    }

    private void buildImportColumnPanel() {
        this.workPanel.add((Component)this.sidePanel, new AbsoluteConstraints(0, 0, 140, 394));
        this.lblExplanation.setText("<html>" + localProperty.getString("stepColSelectionExplanation") + "</html>");
        this.lblHeadline.setText(localProperty.getString("stepColSelectionHeadline"));
        this.workPanel.add((Component)this.topPanel, new AbsoluteConstraints(0, 0, 500, 70));
        this.panelColumnSelection = new JPanel();
        this.panelColumnSelection.setLayout(new AbsoluteLayout());
        this.panelColumnSelection.setBackground(Color.white);
        ButtonGroup bg = new ButtonGroup();
        this.optPLZ = new PSJRadioButton(localProperty.getString("optPLZ"));
        this.optPLZ.setSelected(this.isPLZImport);
        this.optPLZ.setBackground(Color.white);
        this.optPLZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTextImport.this.isPLZImport = true;
                DlgTextImport.this.cmbColumns2.setVisible(false);
                DlgTextImport.this.lblColSelection2.setVisible(false);
                DlgTextImport.this.btnOk.setEnabled(DlgTextImport.this.isPLZImport || DlgTextImport.this.cmbColumns2.getSelectedIndex() > -1);
            }
        });
        bg.add(this.optPLZ);
        this.optOrtsteile = new PSJRadioButton(localProperty.getString(this.isEAImport ? "optZBN" : "optOrtsteile"));
        this.optOrtsteile.setSelected(!this.isPLZImport);
        this.optOrtsteile.setBackground(Color.white);
        this.optOrtsteile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTextImport.this.isPLZImport = false;
                if (!DlgTextImport.this.isEAImport) {
                    DlgTextImport.this.cmbColumns2.setVisible(true);
                    DlgTextImport.this.lblColSelection2.setVisible(true);
                    DlgTextImport.this.btnOk.setEnabled(DlgTextImport.this.cmbColumns1.getSelectedIndex() > -1 && DlgTextImport.this.cmbColumns2.getSelectedIndex() > -1);
                } else {
                    DlgTextImport.this.lblColSelection.setText(localProperty.getString("lblColSelection3"));
                }
            }
        });
        bg.add(this.optOrtsteile);
        this.panelColumnSelection.add((Component)this.optPLZ, new AbsoluteConstraints(10, 20, -1, -1));
        this.panelColumnSelection.add((Component)this.optOrtsteile, new AbsoluteConstraints(200, 20, -1, -1));
        this.lblColSelection = new JLabel(localProperty.getString("lblColSelection"));
        this.panelColumnSelection.add((Component)this.lblColSelection, new AbsoluteConstraints(5, 52, -1, -1));
        this.cmbColumns1 = new JComboBox();
        this.cmbColumns1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && DlgTextImport.this.cmbColumns1.getSelectedIndex() > -1) {
                    DlgTextImport.this.plzColumn = DlgTextImport.this.cmbColumns1.getSelectedIndex();
                    DlgTextImport.this.btnOk.setEnabled(DlgTextImport.this.isPLZImport || DlgTextImport.this.isEAImport || DlgTextImport.this.cmbColumns2.getSelectedIndex() > -1);
                }
            }
        });
        this.panelColumnSelection.add((Component)this.cmbColumns1, new AbsoluteConstraints(110, 50, -1, -1));
        this.lblColSelection2 = new JLabel(localProperty.getString("lblColSelection2"));
        this.lblColSelection2.setVisible(!this.isPLZImport);
        this.panelColumnSelection.add((Component)this.lblColSelection2, new AbsoluteConstraints(5, 82, -1, -1));
        this.cmbColumns2 = new JComboBox();
        this.cmbColumns2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DlgTextImport.this.otColumn = DlgTextImport.this.cmbColumns2.getSelectedIndex();
                    DlgTextImport.this.btnOk.setEnabled(DlgTextImport.this.cmbColumns1.getSelectedIndex() > -1 && DlgTextImport.this.cmbColumns2.getSelectedIndex() > -1);
                }
            }
        });
        this.cmbColumns2.setVisible(!this.isPLZImport);
        this.panelColumnSelection.add((Component)this.cmbColumns2, new AbsoluteConstraints(110, 80, -1, -1));
        this.chkZusatzFeld = new PSJCheckBox(localProperty.getString("chkZusatzFeld"));
        this.chkZusatzFeld.setBackground(Color.white);
        this.chkZusatzFeld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PSAuftrag.setZbnImportWithID(DlgTextImport.this.chkZusatzFeld.isSelected());
            }
        });
        this.panelColumnSelection.add((Component)this.chkZusatzFeld, new AbsoluteConstraints(1, 110, -1, -1));
        this.cmbXtraColumns = new JComboBox();
        this.cmbXtraColumns.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DlgTextImport.this.zusatzColumn = DlgTextImport.this.cmbXtraColumns.getSelectedIndex();
            }
        });
        this.panelColumnSelection.add((Component)this.cmbXtraColumns, new AbsoluteConstraints(110, 110, -1, -1));
        JPanel panelPreview = new JPanel();
        panelPreview.setLayout(new AbsoluteLayout());
        panelPreview.setBorder(new TitledBorder(localProperty.getString("previewPanelTitle")));
        panelPreview.setBackground(Color.white);
        this.tablePane = new JScrollPane();
        this.previewTable = new PSJTable();
        this.previewTable.getTableHeader().setReorderingAllowed(false);
        this.previewTable.getTableHeader().setResizingAllowed(true);
        PsoDefaultTableModel dtm = new PsoDefaultTableModel();
        dtm.setColumnCount(1);
        int i = 0;
        while (i < this.lineStore.size()) {
            String line = this.lineStore.elementAt(i);
            Object[] tmp = new Object[]{line};
            dtm.addRow(tmp);
            ++i;
        }
        this.previewTable.setModel(dtm);
        this.tablePane.getViewport().add(this.previewTable);
        panelPreview.add((Component)this.tablePane, new AbsoluteConstraints(10, 20, 450, 120));
        this.updatePreview();
        i = 0;
        while (i < this.previewTable.getModel().getColumnCount()) {
            this.cmbColumns1.addItem(this.previewTable.getModel().getColumnName(i));
            this.cmbColumns2.addItem(this.previewTable.getModel().getColumnName(i));
            this.cmbXtraColumns.addItem(this.previewTable.getModel().getColumnName(i));
            ++i;
        }
        this.cmbColumns1.setSelectedIndex(-1);
        this.cmbColumns2.setSelectedIndex(-1);
        this.cmbXtraColumns.setSelectedIndex(-1);
        this.workPanel.setBackground(Color.white);
        this.workPanel.add((Component)this.panelColumnSelection, new AbsoluteConstraints(144, 70, 470, 140));
        this.workPanel.add((Component)panelPreview, new AbsoluteConstraints(144, 230, 470, 150));
        this.btnOk.setEnabled(false);
        this.getContentPane().add((Component)this.workPanel, new AbsoluteConstraints(0, 0, 650, 394));
    }

    private void buildResultsPanel() {
        this.workPanel.add((Component)this.sidePanel, new AbsoluteConstraints(0, 0, 140, 394));
        this.lblExplanation.setText("<html>" + localProperty.getString("stepResultsExplanation") + "</html>");
        this.lblHeadline.setText(localProperty.getString("stepResultsHeadline"));
        this.workPanel.add((Component)this.topPanel, new AbsoluteConstraints(0, 0, 500, 100));
        JPanel panelPreview = new JPanel();
        panelPreview.setLayout(new AbsoluteLayout());
        panelPreview.setBorder(new TitledBorder(localProperty.getString("lblNotFound")));
        panelPreview.setBackground(Color.white);
        this.tablePane = new JScrollPane();
        this.previewTable = new PSJTable();
        this.previewTable.getTableHeader().setReorderingAllowed(false);
        this.previewTable.getTableHeader().setResizingAllowed(true);
        PsoDefaultTableModel dtm = new PsoDefaultTableModel();
        dtm.setColumnCount(this.isPLZImport ? 1 : 2);
        this.previewTable.setModel(dtm);
        this.tablePane.getViewport().add(this.previewTable);
        panelPreview.add((Component)this.tablePane, new AbsoluteConstraints(10, 20, 450, 120));
        JButton btnExport = new JButton(localProperty.getString("btnExport"));
        btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgTextImport.this.exportUnresolved();
            }
        });
        panelPreview.add((Component)btnExport, new AbsoluteConstraints(120, 145, 200, 25));
        this.workPanel.setBackground(Color.white);
        this.workPanel.add((Component)panelPreview, new AbsoluteConstraints(144, 100, 470, 180));
        this.getContentPane().add((Component)this.workPanel, new AbsoluteConstraints(0, 0, 650, 394));
        this.btnHelp.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnAbort.setVisible(false);
        this.btnOk.setText(localProperty.getString("stepResultsOKButton"));
        this.importToDB();
    }

    private void resetWndDimension() {
        if (this.wndRect != null) {
            this.setBounds(this.wndRect);
            this.setResizable(false);
        }
    }

    private void readImportFile() {
        try {
            File f = new File(this.importFileName);
            this.lineStore = new Vector();
            BufferedReader br = new BufferedReader(new FileReader(f));
            int cnt = 0;
            while (br.ready()) {
                String line = br.readLine();
                this.checkSeparated(line);
                if (cnt++ >= 10) continue;
                this.lineStore.addElement(line);
            }
            this.lineCount = cnt;
            br.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void checkSeparated(String line) {
        if (line.indexOf("\t") > -1 || line.indexOf(";") > -1 || line.indexOf(",") > -1) {
            this.separatedData = true;
        }
    }

    private void updatePreview() {
        try {
            String[] rowData = PSEnvironment.tokenStringToStringArray(this.lineStore.elementAt(0).toString(), this.separator);
            int cols = rowData.length;
            DefaultTableModel dtm = new DefaultTableModel();
            Vector v = new Vector();
            Vector<String> titles = new Vector<String>();
            int i = 0;
            while (i < this.lineStore.size()) {
                boolean isValidRow = true;
                String line = this.lineStore.elementAt(i);
                rowData = PSEnvironment.tokenStringToStringArray(line, this.separator);
                Vector<String> row = new Vector<String>();
                int j = 0;
                while (j < cols) {
                    try {
                        String data = rowData[j];
                        data = PSEnvironment.replace(data, "\"", "");
                        data = PSEnvironment.replace(data, "'", "");
                        if (i == 0) {
                            if (this.hasColumnHeader) {
                                titles.addElement(data);
                            } else {
                                titles.addElement(String.valueOf(localProperty.getString("colHeaderDef")) + (j + 1));
                                row.addElement(data);
                            }
                        } else {
                            row.addElement(data);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    ++j;
                }
                if ((i > 0 || !this.hasColumnHeader) && isValidRow) {
                    v.addElement(row);
                }
                ++i;
            }
            dtm.setDataVector(v, titles);
            this.previewTable.setModel(dtm);
            this.previewTable.invalidate();
            this.previewTable.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (PSEnvironment.isWindowsPlatform()) {
            Rectangle myRect = this.getBounds();
            if (this.getActPane() == 7) {
                g.drawImage(Toolkit.getDefaultToolkit().getImage("images/dragCorner.gif"), myRect.width - 17, myRect.height - 16, this);
            }
        }
    }

    private void importToDB() {
        try {
            PSAuftrag.setAutosaveAllowed(false);
            File f = new File(this.importFileName);
            BufferedReader br = new BufferedReader(new FileReader(f));
            this.totalCnt = 0;
            this.initProgress();
            int cnt = 0;
            String toSend = "";
            while (br.ready()) {
                String line = br.readLine();
                if (++cnt == 1 && this.hasColumnHeader || line.trim().length() == 0) continue;
                String[] values = PSEnvironment.tokenStringToStringArray(line, this.separator);
                if (values.length <= this.plzColumn) {
                    this.progress.closeProgressDialog();
                    int result = JOptionPane.showConfirmDialog(this.pso, localProperty.getString("errMsg"));
                    if (result == 0) {
                        this.initProgress();
                        continue;
                    }
                    this.progress.closeProgressDialog();
                    toSend = "";
                    break;
                }
                String plz = values[this.plzColumn];
                toSend = String.valueOf(toSend) + plz;
                if (!this.isPLZImport && !this.isEAImport) {
                    String ortsteil = "";
                    try {
                        ortsteil = values[this.otColumn];
                    }
                    catch (IndexOutOfBoundsException iex) {
                        ortsteil = " ";
                    }
                    toSend = String.valueOf(toSend) + "|" + ortsteil;
                }
                if (this.chkZusatzFeld.isSelected()) {
                    toSend = String.valueOf(toSend) + "|" + values[this.zusatzColumn];
                }
                toSend = String.valueOf(toSend) + ";";
                if (cnt % 500 != 0) continue;
                PSO.cc.SendMessage(this.isPLZImport || this.isEAImport ? 341 : 342, toSend);
                toSend = "";
            }
            if (toSend.length() > 0) {
                PSO.cc.SendMessage(this.isPLZImport || this.isEAImport ? 341 : 342, toSend);
            }
            PSO.cc.SendMessage(268, "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.progress.closeProgressDialog();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.flipPanel(--this.actPane, false);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.flipPanel(++this.actPane, true);
    }

    public int getActPane() {
        return this.actPane;
    }

    private void setActPane(int value) {
        this.actPane = value;
    }

    private void initProgress() {
        this.progress = new VolumeProgressDialog(this.pso, true, false, this.lineCount, 100, false){

            @Override
            public void progressDialogStarted(ProgressEvent ppe) {
            }

            @Override
            public void progressDialogBroken(ProgressEvent ppe) {
            }

            @Override
            public void progressDialogChanged(ProgressEvent ppe) {
                DlgTextImport.this.progress.setProgressValue(DlgTextImport.this.totalCnt);
                String type = this.getProgressLabel();
                type = type.substring(0, type.indexOf(" "));
                DlgTextImport.this.progress.setProgressLabel(String.valueOf(type) + " " + DlgTextImport.this.totalCnt + " / " + DlgTextImport.this.lineCount);
                DlgTextImport.this.progress.showProgressDialog();
            }

            @Override
            public void progressDialogEndet(ProgressEvent ppe) {
                PSAuftrag.setAutosaveAllowed(true);
            }
        };
        this.progress.setPureVolumeProgress(true);
        this.progress.setProgressTitle(localProperty.getString("progressString1"));
        String type = "";
        if (this.isPLZImport) {
            type = localProperty.getString("progressString2");
        } else if (!this.isEAImport) {
            type = localProperty.getString("progressString4");
        } else if (this.isEAImport && this.optOrtsteile.isSelected()) {
            type = localProperty.getString("progressString3");
        }
        this.progress.setProgressLabel(String.valueOf(type) + " " + this.totalCnt + " / " + this.lineCount);
        this.progress.run();
        this.progress.setActionButtonVisible(false);
    }

    private void setGlassPane() {
        this.glasspane = this.getGlassPane();
        this.glasspane.addMouseListener(new MouseAdapter(){});
        this.glasspane.setCursor(Cursor.getPredefinedCursor(3));
        this.glasspane.setVisible(true);
        this.pso.getGlassPane().setVisible(true);
    }

    public void resetGlassPane() {
        if (this.glasspane != null) {
            this.glasspane.setCursor(Cursor.getPredefinedCursor(0));
            this.glasspane.setVisible(false);
        }
        this.pso.getGlassPane().setVisible(false);
    }

    private boolean showFileChooser() {
        boolean result = false;
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText(localProperty.getString("Button4"));
        File f = new File(PSEnvironment.getPSPath());
        chooser.setCurrentDirectory(f);
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        if (PSEnvironment.isWindowsPlatform()) {
            PSFileFilter altFilter = new PSFileFilter(String.valueOf(localProperty.getString("fcDescr2")) + "|csv");
            chooser.addChoosableFileFilter(altFilter);
        }
        PSFileFilter filter = new PSFileFilter(String.valueOf(localProperty.getString("fcDescr")) + "|txt");
        chooser.addChoosableFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this.pso);
        if (returnVal == 0) {
            this.importFileName = chooser.getSelectedFile().getAbsolutePath();
            if (chooser.getSelectedFile().getName().toLowerCase().endsWith(".csv")) {
                this.isCSV = true;
                this.separator = ";";
            } else {
                this.isCSV = false;
            }
            if (PSEnvironment.DEBUG) {
                System.out.println("You chose to open this file: " + chooser.getSelectedFile().getName());
            }
            result = true;
        }
        return result;
    }

    public void addErrors(String data) {
        try {
            StringTokenizer t = new StringTokenizer(data, ";");
            this.totalCnt = (long)this.totalCnt < this.lineCount + 500L ? (this.totalCnt += 500) : (int)((long)this.totalCnt + (this.lineCount - (long)this.totalCnt));
            this.progress.setProgressValue(this.totalCnt);
            while (t.hasMoreTokens()) {
                if (this.isPLZImport) {
                    DefaultTableModel dtm = (DefaultTableModel)this.previewTable.getModel();
                    Object[] row = new String[]{t.nextToken()};
                    dtm.addRow(row);
                    this.previewTable.setModel(dtm);
                    continue;
                }
                String token = t.nextToken();
                StringTokenizer t2 = new StringTokenizer(token, "|");
                DefaultTableModel dtm = (DefaultTableModel)this.previewTable.getModel();
                Object[] row = new String[]{"", ""};
                if (t2.hasMoreTokens()) {
                    row[0] = t2.nextToken();
                }
                if (t2.hasMoreTokens()) {
                    row[1] = t2.nextToken();
                }
                dtm.addRow(row);
                this.previewTable.setModel(dtm);
            }
            if ((long)this.totalCnt >= this.lineCount) {
                this.progress.closeProgressDialog();
                if (this.previewTable.getModel().getRowCount() == 0) {
                    this.dispose();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void exportUnresolved() {
        try {
            File DataDir = new File(String.valueOf(PSEnvironment.getPSPath()) + "export" + PSEnvironment.FILE_SEPARATOR);
            if (!DataDir.exists()) {
                DataDir.mkdirs();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(PSEnvironment.getPSPath()) + "export" + PSEnvironment.FILE_SEPARATOR + "import.log"));
            int i = 0;
            while (i < this.previewTable.getRowCount()) {
                bw.write(this.previewTable.getValueAt(i, 0).toString());
                if (!this.isPLZImport) {
                    bw.write(";");
                    bw.write(this.previewTable.getValueAt(i, 1).toString());
                }
                bw.newLine();
                ++i;
            }
            bw.flush();
            bw.close();
            JOptionPane.showMessageDialog(this, String.valueOf(localProperty.getString("SaveMsgPt1")) + " " + PSEnvironment.getPSPath() + "export" + PSEnvironment.FILE_SEPARATOR + "import.log " + localProperty.getString("SaveMsgPt2"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

