/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import prospektservice.Feedback;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PSJCheckBox;
import prospektservice.base.PamDialog;
import prospektservice.dialog.frmHelp;

public class DlgExport
extends PamDialog {
    private static final long serialVersionUID = 3762810502291731507L;
    private static final int DATA_ZSP = 1;
    private static final int DATA_BFAH = 2;
    private static final int DATA_PLZ = 3;
    private static final int DATA_COUNTRY = 4;
    private static final int DATA_DISTRICTS = 5;
    private String mailAddress = PSUser.getEmailAddress();
    private PSO pso;
    private ResourceBundle localProperty;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel bottomPanel;
    private JLabel lblExplanation;
    private PSJCheckBox chkPLZ;
    private PSJCheckBox chkBundesland;
    private PSJCheckBox chkZSP;
    private PSJCheckBox chkAbhol;
    private PSJCheckBox chkOrtsteile;
    private JButton btnOK;
    private JButton btnCancel;
    private JButton btnHelp;
    private PSJCheckBox chkTargetAreas;

    public DlgExport(PSO mainpanel) {
        super(mainpanel, "", true);
        this.setSize(300, 170);
        this.localProperty = ResourceBundle.getBundle("properties.dlgExport", PSUser.getLanguage());
        this.setResizable(false);
        this.setLocationRelativeTo(this.pso);
        this.setTitle(this.localProperty.getString("Title"));
        this.getContentPane().setLayout(new BorderLayout());
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.setBorder(BorderFactory.createEtchedBorder());
        this.topPanel.setPreferredSize(new Dimension(1, 50));
        this.lblExplanation = new JLabel();
        this.lblExplanation.setBackground(this.getContentPane().getBackground());
        this.lblExplanation.setText("<html>" + this.localProperty.getString("lblExplanation") + " " + this.mailAddress + "</html>");
        this.topPanel.add(this.lblExplanation);
        this.getContentPane().add((Component)this.topPanel, "North");
        this.centerPanel = new JPanel();
        this.centerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.centerPanel.setLayout(new GridLayout(3, 2));
        this.centerPanel.setPreferredSize(new Dimension(1, 60));
        this.chkZSP = new PSJCheckBox(this.localProperty.getString("chkZSP"));
        this.centerPanel.add(this.chkZSP);
        this.chkAbhol = new PSJCheckBox(this.localProperty.getString("chkAbhol"));
        this.chkPLZ = new PSJCheckBox(this.localProperty.getString("chkPLZ"));
        this.centerPanel.add(this.chkPLZ);
        this.chkBundesland = new PSJCheckBox(this.localProperty.getString("chkBundesland"));
        this.centerPanel.add(this.chkBundesland);
        this.chkOrtsteile = new PSJCheckBox(this.localProperty.getString("chkOrtsteile"));
        this.centerPanel.add(this.chkOrtsteile);
        this.chkTargetAreas = new PSJCheckBox(this.localProperty.getString("chkTargetAreas"));
        this.centerPanel.add(this.chkTargetAreas);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setBorder(BorderFactory.createEtchedBorder());
        this.bottomPanel.setLayout(new FlowLayout(2));
        final DlgExport export = this;
        this.btnHelp = new JButton(this.localProperty.getString("btnHelp"));
        this.btnHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frmHelp.getInstance("hilfe/hilfe_export.html", export).setVisible(true);
            }
        });
        this.bottomPanel.add(this.btnHelp);
        this.btnCancel = new JButton(this.localProperty.getString("btnCancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgExport.this.dispose();
            }
        });
        this.bottomPanel.add(this.btnCancel);
        this.btnOK = new JButton(this.localProperty.getString("btnOK"));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgExport.this.chkBundesland.isSelected() || DlgExport.this.chkZSP.isSelected() || DlgExport.this.chkPLZ.isSelected() || DlgExport.this.chkAbhol.isSelected() || DlgExport.this.chkOrtsteile.isSelected() || DlgExport.this.chkTargetAreas.isSelected()) {
                    DlgExport.this.requestData();
                }
            }
        });
        this.bottomPanel.add(this.btnOK);
        this.getContentPane().add((Component)this.bottomPanel, "South");
    }

    private void requestData() {
        String dataMsg = "";
        if (this.chkTargetAreas.isSelected()) {
            dataMsg = "targetAreas;";
        }
        dataMsg = String.valueOf(dataMsg) + this.mailAddress + ";";
        if (this.chkPLZ.isSelected()) {
            dataMsg = String.valueOf(dataMsg) + "3|";
        }
        if (this.chkBundesland.isSelected()) {
            dataMsg = String.valueOf(dataMsg) + "4|";
        }
        if (this.chkZSP.isSelected()) {
            dataMsg = String.valueOf(dataMsg) + "1|";
        }
        if (this.chkAbhol.isSelected()) {
            dataMsg = String.valueOf(dataMsg) + "2|";
        }
        if (this.chkOrtsteile.isSelected()) {
            dataMsg = String.valueOf(dataMsg) + "5|";
        }
        Component gp = this.getGlassPane();
        gp.addMouseListener(new MouseAdapter(){});
        gp.setCursor(Cursor.getPredefinedCursor(3));
        gp.setVisible(true);
        PSO.cc.SendMessage(326, dataMsg);
    }

    public void YoRequestData(String data) {
        String msg = "";
        Component gp = this.getGlassPane();
        gp.setCursor(Cursor.getPredefinedCursor(0));
        gp.setVisible(false);
        msg = data.equals("1") ? this.localProperty.getString("successMsg") : this.localProperty.getString("failureMsg");
        this.dispose();
        Feedback.showMessage((Component)this, "Export", msg);
    }
}

