/*
 * Decompiled with CFR 0.152.
 */
package prospektservice.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import prospektservice.AddressManager;
import prospektservice.Feedback;
import prospektservice.PSAuftrag;
import prospektservice.PSEnvironment;
import prospektservice.PSO;
import prospektservice.PSUser;
import prospektservice.base.PamDialog;
import prospektservice.definitions.DefAddressData;

public class DlgAddressSelection
extends PamDialog {
    private static final long serialVersionUID = 649043940384552751L;
    private static final int WIDTH = 800;
    private static final int HEIGHT = 600;
    private ResourceBundle localProperty;
    private DefaultTableModel dtm;
    private JTable tblAddresses;
    boolean roleMode;
    private TableRowSorter<TableModel> sorter;
    private static Logger logger = Logger.getLogger("DlgAddressSelection");

    public DlgAddressSelection(boolean roleSelection) {
        super(PSO.mainpanel);
        this.roleMode = roleSelection;
        this.setModal(true);
        this.setSize(new Dimension(800, 600));
        this.setLocationRelativeTo(PSO.mainpanel);
        this.localProperty = ResourceBundle.getBundle("properties.DlgAddressSelection", PSUser.getLanguage());
        this.setTitle(this.localProperty.getString("dlgTitle"));
        Vector<String> headers = new Vector<String>();
        if (roleSelection) {
            headers.add(this.localProperty.getString("headers1"));
            headers.add(this.localProperty.getString("headers2"));
            headers.add(this.localProperty.getString("headers3"));
        }
        headers.add(this.localProperty.getString("headers4"));
        headers.add(this.localProperty.getString("headers5"));
        headers.add(this.localProperty.getString("headers6"));
        headers.add(this.localProperty.getString("headers7"));
        headers.add(this.localProperty.getString("headers8"));
        headers.add(this.localProperty.getString("headers9"));
        headers.add(this.localProperty.getString("headers10"));
        this.dtm = new DefaultTableModel(){
            private static final long serialVersionUID = 1010476947563076491L;

            @Override
            public boolean isCellEditable(int row, int column) {
                boolean hasPc;
                int maxColumn = 2;
                DefAddressData dad = AddressManager.getRecordFromAll(row);
                boolean bl = hasPc = dad.absender.ERGNR.length() > 0;
                if (hasPc || AddressManager.recordHasBankData(row)) {
                    maxColumn = 3;
                }
                return DlgAddressSelection.this.roleMode && column < maxColumn;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (DlgAddressSelection.this.roleMode && columnIndex < 3) {
                    return Boolean.class;
                }
                return super.getColumnClass(columnIndex);
            }
        };
        this.dtm.setColumnIdentifiers(headers);
        this.dtm.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                System.out.println("tbl event: " + e.getFirstRow() + ", " + e.getColumn());
                if (e.getColumn() < 3 && DlgAddressSelection.this.roleMode && e.getColumn() != -1) {
                    int col = e.getColumn();
                    int row = e.getFirstRow();
                    if (DlgAddressSelection.this.dtm.getValueAt(row, col) == Boolean.TRUE) {
                        int i = 0;
                        while (i < DlgAddressSelection.this.dtm.getRowCount()) {
                            if (i != row && DlgAddressSelection.this.dtm.getValueAt(i, col) == Boolean.TRUE) {
                                DlgAddressSelection.this.dtm.setValueAt(Boolean.FALSE, i, col);
                            }
                            ++i;
                        }
                        DefAddressData dad = AddressManager.getRecordFromAll(row);
                        if (dad.absender.emailAddress.length() == 0 && PSEnvironment.isGpwsClient()) {
                            if (Feedback.showQuestion(null, 22) == 0) {
                                int index = AddressManager.getAddressIndex(dad);
                                PSO.mainpanel.AE.cmbStoredAddresses.setSelectedIndex(index);
                                PSO.mainpanel.AE.setCurrentCustomerRecord(dad);
                                PSO.mainpanel.AE.txtAbsender_Email.requestFocus();
                                DlgAddressSelection.this.dispose();
                            } else {
                                DlgAddressSelection.this.dtm.setValueAt(Boolean.FALSE, row, col);
                            }
                        }
                    }
                }
            }
        });
        Vector<DefAddressData> addrData = AddressManager.getAddresses();
        logger.info("abs: " + PSAuftrag.absender.Name);
        logger.info("einl: " + PSAuftrag.einlieferer.Name);
        logger.info("zahl: " + PSAuftrag.zahlungspflichtiger.Name);
        int i = 0;
        while (i < addrData.size()) {
            DefAddressData dad = addrData.elementAt(i);
            logger.info("Name: " + dad.absender.Name);
            Vector<Object> rowData = new Vector<Object>();
            if (this.roleMode) {
                rowData.add(PSAuftrag.absender.equals(dad.absender));
                rowData.add(PSAuftrag.einlieferer.equals(dad.absender) || PSAuftrag.absender.equals(dad.absender) && PSAuftrag.cbformulare.cb_abs_einl);
                rowData.add(PSAuftrag.zahlungspflichtiger.equals(dad.absender) || PSAuftrag.absender.equals(dad.absender) && PSAuftrag.cbformulare.cb_zahlungspflichtiger == 0 || PSAuftrag.einlieferer.equals(dad.absender) && PSAuftrag.cbformulare.cb_zahlungspflichtiger == 1);
            }
            rowData.add(dad.absender.Name);
            rowData.add(dad.absender.Strasse);
            rowData.add(dad.absender.Land);
            rowData.add(dad.absender.PLZ);
            rowData.add(dad.absender.Ort);
            rowData.add(dad.absender.KDNR);
            rowData.add(String.valueOf(dad.absender.ERGNR) + dad.absender.KARTENNR);
            this.dtm.addRow(rowData);
            ++i;
        }
        this.tblAddresses = new JTable(this.dtm);
        this.sorter = new TableRowSorter<TableModel>(this.tblAddresses.getModel());
        this.tblAddresses.setRowSorter(this.sorter);
        this.tblAddresses.getTableHeader().setReorderingAllowed(false);
        int startCol = 0;
        if (this.roleMode) {
            this.tblAddresses.getTableHeader().getColumnModel().getColumn(startCol++).setPreferredWidth(60);
            this.tblAddresses.getTableHeader().getColumnModel().getColumn(startCol++).setPreferredWidth(60);
            this.tblAddresses.getTableHeader().getColumnModel().getColumn(startCol++).setPreferredWidth(80);
        }
        this.tblAddresses.getTableHeader().getColumnModel().getColumn(startCol++).setPreferredWidth(100);
        this.tblAddresses.getTableHeader().getColumnModel().getColumn(startCol++).setPreferredWidth(100);
        this.tblAddresses.getTableHeader().getColumnModel().getColumn(startCol++).setPreferredWidth(50);
        this.tblAddresses.getTableHeader().getColumnModel().getColumn(startCol++).setPreferredWidth(70);
        this.tblAddresses.getTableHeader().getColumnModel().getColumn(startCol++).setPreferredWidth(80);
        this.tblAddresses.getTableHeader().getColumnModel().getColumn(startCol++).setPreferredWidth(80);
        this.tblAddresses.getTableHeader().getColumnModel().getColumn(startCol++).setPreferredWidth(80);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        int skStart = this.roleMode ? 3 : 0;
        sortKeys.add(new RowSorter.SortKey(skStart++, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(skStart++, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(skStart++, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(skStart++, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(skStart++, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(skStart++, SortOrder.ASCENDING));
        sortKeys.add(new RowSorter.SortKey(skStart++, SortOrder.ASCENDING));
        this.sorter.setSortKeys(sortKeys);
        this.sorter.setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                return model.getValueAt(row, column).toString().toLowerCase();
            }
        });
        JScrollPane tableScrollPane = new JScrollPane();
        tableScrollPane.setViewportView(this.tblAddresses);
        this.tblAddresses.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !DlgAddressSelection.this.roleMode) {
                    int index = DlgAddressSelection.this.sorter.convertRowIndexToModel(DlgAddressSelection.this.tblAddresses.getSelectedRow());
                    DefAddressData record = AddressManager.getRecordFromAll(index);
                    PSO.mainpanel.AE.cmbStoredAddresses.setSelectedIndex(index);
                    PSO.mainpanel.AE.setCurrentCustomerRecord(record);
                    DlgAddressSelection.this.dispose();
                }
            }
        });
        this.tblAddresses.setDefaultRenderer(Boolean.class, new CheckBoxCellRenderer());
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(1));
        JButton btnOk = new JButton(this.localProperty.getString("btnOk"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgAddressSelection.this.roleMode) {
                    int absRow = -1;
                    int einlRow = -1;
                    int zahlRow = -1;
                    int i = 0;
                    while (i < DlgAddressSelection.this.dtm.getRowCount()) {
                        if (DlgAddressSelection.this.dtm.getValueAt(i, 0) == Boolean.TRUE) {
                            absRow = i;
                        }
                        if (DlgAddressSelection.this.dtm.getValueAt(i, 1) == Boolean.TRUE) {
                            einlRow = i;
                        }
                        if (DlgAddressSelection.this.dtm.getValueAt(i, 2) == Boolean.TRUE) {
                            zahlRow = i;
                        }
                        ++i;
                    }
                    if (absRow > -1) {
                        DefAddressData dad = AddressManager.getRecordFromAll(absRow);
                        PSAuftrag.absender = dad.absender;
                        PSO.mainpanel.AE.cmbAbsender.setSelectedIndex(absRow);
                        PSO.mainpanel.AE.txtAbs.setText(String.valueOf(dad.absender.Name) + " " + dad.absender.KDNR);
                        if (absRow == einlRow) {
                            PSAuftrag.cbformulare.cb_abs_einl = true;
                            PSO.mainpanel.AE.abs_gleich.setSelected(true);
                        }
                        if (absRow == zahlRow) {
                            PSAuftrag.cbformulare.cb_zahlungspflichtiger = 0;
                            PSO.mainpanel.AE.chkAZahlungspflichtiger.setSelected(true);
                        }
                    }
                    if (einlRow > -1 && einlRow != absRow) {
                        DefAddressData dad = AddressManager.getRecordFromAll(einlRow);
                        PSAuftrag.einlieferer = dad.absender;
                        PSO.mainpanel.AE.cmbEinlieferer.setSelectedIndex(einlRow);
                        PSO.mainpanel.AE.abs_gleich.setSelected(false);
                        PSAuftrag.cbformulare.cb_abs_einl = false;
                        PSO.mainpanel.AE.txtEinl.setText(String.valueOf(dad.absender.Name) + " " + dad.absender.KDNR);
                        if (einlRow == zahlRow) {
                            PSAuftrag.cbformulare.cb_zahlungspflichtiger = 1;
                            PSO.mainpanel.AE.chkEZahlungspflichtiger.setSelected(true);
                        }
                    }
                    if (zahlRow > -1 && zahlRow != absRow && zahlRow != einlRow) {
                        DefAddressData dad = AddressManager.getRecordFromAll(zahlRow);
                        PSAuftrag.zahlungspflichtiger = dad.absender;
                        PSO.mainpanel.AE.cmbZahlungspflichtiger.setSelectedIndex(zahlRow);
                        PSO.mainpanel.AE.txtZahler.setText(String.valueOf(dad.absender.Name) + " " + dad.absender.KDNR);
                        PSO.mainpanel.AE.chkAZahlungspflichtiger.setSelected(false);
                        PSO.mainpanel.AE.chkEZahlungspflichtiger.setSelected(false);
                        PSAuftrag.cbformulare.cb_zahlungspflichtiger = 2;
                    }
                    PSO.mainpanel.AE.setChangeAddressData(true);
                    PSO.mainpanel.AE.formulareSendData();
                } else {
                    int index = DlgAddressSelection.this.sorter.convertRowIndexToModel(DlgAddressSelection.this.tblAddresses.getSelectedRow());
                    if (index > -1) {
                        DefAddressData record = AddressManager.getRecordFromAll(index);
                        PSO.mainpanel.AE.cmbStoredAddresses.setSelectedIndex(index);
                        PSO.mainpanel.AE.setCurrentCustomerRecord(record);
                    }
                }
                DlgAddressSelection.this.dispose();
            }
        });
        btnPanel.add(btnOk);
        JButton btnCancel = new JButton(this.localProperty.getString("btnCancel"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgAddressSelection.this.dispose();
            }
        });
        btnPanel.add(btnCancel);
        this.getContentPane().add((Component)tableScrollPane, "Center");
        this.getContentPane().add((Component)btnPanel, "South");
    }

    class CheckBoxCellRenderer
    implements TableCellRenderer {
        private final JCheckBox renderer = new JCheckBox();

        public CheckBoxCellRenderer() {
            this.renderer.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color bg = isSelected ? table.getSelectionBackground() : table.getBackground();
            this.renderer.setBackground(bg);
            boolean enabled = table.isCellEditable(row, column);
            this.renderer.setEnabled(enabled);
            this.renderer.setSelected(value != null && (Boolean)value != false);
            this.renderer.setToolTipText(enabled ? "" : "Nicht aktivierbar, da keine Bankverbindung oder POSTCARD-Nr. hinterlegt.");
            return this.renderer;
        }
    }
}

